/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.integration;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import org.apache.log4j.Logger;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.data.CoAnnotationSet;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;

public class CoAnnoTargetBuilder {
    public static Logger logger = Logger.getLogger(CoAnnoTargetBuilder.class);

    public static CoAnnotationSet computeCoAnnoationSet(long organismId, String goBranch, org.genemania.engine.matricks.Matrix labels) {
        int numGenes = labels.numRows();
        int numCategories = labels.numCols();
        double[] ratiosData = CoAnnoTargetBuilder.computeSumPosRatios(numGenes, labels);
        DenseVector ratios = new DenseVector(ratiosData, false);
        double constant = CoAnnoTargetBuilder.computeConstant(numGenes, (Vector)ratios);
        logger.debug((Object)("constant: " + constant));
        DenseVector yHat = CoAnnoTargetBuilder.computeYHat(numGenes, ratiosData, labels);
        logger.debug((Object)"computed YHat");
        SymMatrix AHat = CoAnnoTargetBuilder.computeAHatLessMem(numGenes, numCategories, labels);
        logger.debug((Object)"computed AHat");
        CoAnnotationSet cas = new CoAnnotationSet(organismId, goBranch, AHat, yHat, constant);
        return cas;
    }

    public static double computeConstant(int numGenes, Vector ratios) {
        double constant = ratios.dot(ratios);
        return constant;
    }

    public static DenseVector computeYHat(int numGenes, double[] ratios, org.genemania.engine.matricks.Matrix labels) {
        double[] yHatTempData = new double[numGenes];
        labels.multAdd(ratios, yHatTempData);
        DenseVector yHat = new DenseVector(yHatTempData, false);
        yHat.scale(-2.0);
        return yHat;
    }

    public static SymMatrix computeAHatLessMem(int numGenes, int numCategories, org.genemania.engine.matricks.Matrix labels) {
        SymMatrix AHat = Config.instance().getMatrixFactory().symSparseMatrix(numGenes);
        int[] rows = new int[numGenes];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        for (int c = 0; c < numCategories; ++c) {
            int[] cols = new int[]{c};
            org.genemania.engine.matricks.Matrix yc = labels.subMatrix(rows, cols);
            MatrixCursor e1 = yc.cursor();
            while (e1.next()) {
                MatrixCursor e2 = yc.cursor();
                while (e2.next()) {
                    double z;
                    int j;
                    int i = e1.row();
                    if (i <= (j = e2.row()) || (z = e1.val() * e2.val()) == 0.0) continue;
                    AHat.add(i, j, z);
                }
            }
        }
        return AHat;
    }

    public static double[] computeSumPosRatios(int numGenes, org.genemania.engine.matricks.Matrix labels) {
        double[] ratiosData = new double[labels.numCols()];
        labels.columnSums(ratiosData);
        DenseVector ratios = new DenseVector(ratiosData, false);
        ratios.scale(1.0 / (double)numGenes);
        return ratiosData;
    }

    public static double computeKtT0(CoAnnotationSet annoSet, int numGenes) {
        double result = MatrixUtils.sum((Vector)annoSet.GetBHalf()) * (double)numGenes + annoSet.GetCoAnnotationMatrix().elementSum() + annoSet.GetConstant() * (double)numGenes * (double)numGenes;
        return result;
    }

    public static double computeKtTi(CoAnnotationSet annoSet, int numGenes, org.genemania.engine.matricks.Matrix network, double networkSum) {
        FlexCompColMatrix tempSum2 = new FlexCompColMatrix(1, numGenes);
        MatrixCursor cursor = network.cursor();
        while (cursor.next()) {
            tempSum2.set(0, cursor.col(), tempSum2.get(0, cursor.col()) + cursor.val() * annoSet.GetBHalf().get(cursor.row()));
        }
        double result = network.elementMultiplySum(annoSet.GetCoAnnotationMatrix()) + MatrixUtils.sum((Matrix)tempSum2) + networkSum * annoSet.GetConstant();
        return result;
    }
}

