/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.evaluation.correlation.AbstractPearson;
import org.genemania.engine.core.evaluation.correlation.PearsonRow;

public class PearsonColumnRank
extends AbstractPearson {
    private double dtd;
    private double dd;

    @Override
    protected void createPearsonRow() {
        Vector v;
        int i;
        DenseVector v2;
        int i2;
        List<Vector> geneExpressions = this.geneData.getGeneExpression();
        int numFeatures = geneExpressions.get(0).size();
        int numGenes = geneExpressions.size();
        ArrayList<DenseVector> columnValues = new ArrayList<DenseVector>(numFeatures);
        for (i2 = 0; i2 < numFeatures; ++i2) {
            if (geneExpressions.get(0) instanceof DenseVector) {
                v2 = new DenseVector(numGenes);
            } else if (geneExpressions.get(0) instanceof SparseVector) {
                v2 = new SparseVector(numGenes);
            } else {
                throw new RuntimeException("Unexpected vector type of " + geneExpressions.get(0).getClass().getName());
            }
            columnValues.add(v2);
        }
        for (i2 = 0; i2 < numGenes; ++i2) {
            v2 = geneExpressions.get(i2);
            for (VectorEntry e : v2) {
                ((Vector)columnValues.get(e.index())).set(i2, e.get());
            }
        }
        DenseVector d = new DenseVector(numFeatures);
        for (i = 0; i < numFeatures; ++i) {
            v = (Vector)columnValues.get(i);
            double zeroRank = PearsonColumnRank.getZeroRank(v);
            d.set(i, zeroRank);
            MatrixUtils.tiedRank(v);
            if (!(zeroRank > 0.0)) continue;
            for (VectorEntry e : v) {
                v.set(e.index(), e.get() + zeroRank - 1.0);
            }
        }
        for (i = 0; i < numFeatures; ++i) {
            v = (Vector)columnValues.get(i);
            for (VectorEntry e : v) {
                geneExpressions.get(e.index()).set(i, e.get());
            }
        }
        for (i = 0; i < this.rows.length; ++i) {
            v = geneExpressions.get(i);
            this.rows[i] = new PearsonRow(v, (Vector)d, 1.0, 0.0);
        }
        this.dd = MatrixUtils.sum((Vector)d);
        this.dtd = d.dot((Vector)d);
    }

    @Override
    protected double getDD() {
        return this.dd;
    }

    @Override
    protected double getDTD() {
        return this.dtd;
    }
}

