/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import org.genemania.engine.core.evaluation.correlation.AbstractMutualInformation;
import org.genemania.engine.core.evaluation.correlation.MutualInformationData;

public class MutualInformationEqualRange
extends AbstractMutualInformation {
    private final MutualInformationData.SizeType sizeType;
    private double[] range;

    public MutualInformationEqualRange(MutualInformationData.SizeType sizeType) {
        this.sizeType = sizeType;
    }

    @Override
    protected int getBinNumber(int index, Vector values, int k) {
        return this.getBinNumber(values.get(k), this.numBins, this.range[index * 2], this.range[index * 2 + 1]);
    }

    @Override
    protected void init() {
        this.numBins = this.getNumberOfBins(this.numFeatures, this.sizeType);
        this.range = new double[this.numGenes * 2];
        for (int i = 0; i < this.numGenes; ++i) {
            Vector v = (Vector)this.geneExpressions.get(i);
            boolean first = true;
            for (VectorEntry e : v) {
                double value = e.get();
                if (first || this.range[i * 2] > value) {
                    this.range[i * 2] = value;
                }
                if (first || this.range[i * 2 + 1] < value) {
                    this.range[i * 2 + 1] = value;
                }
                if (!first) continue;
                first = false;
            }
        }
    }
}

