/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import org.genemania.engine.core.evaluation.correlation.Correlation;
import org.genemania.engine.core.evaluation.correlation.LogScaledPearsonBinaryNoNormalization;
import org.genemania.engine.core.evaluation.correlation.LogScaledPearsonBinaryWithNormalization;
import org.genemania.engine.core.evaluation.correlation.MutualInformationBinary;
import org.genemania.engine.core.evaluation.correlation.MutualInformationData;
import org.genemania.engine.core.evaluation.correlation.MutualInformationEqualElem;
import org.genemania.engine.core.evaluation.correlation.MutualInformationEqualRange;
import org.genemania.engine.core.evaluation.correlation.Pearson;
import org.genemania.engine.core.evaluation.correlation.PearsonColumnRank;
import org.genemania.engine.core.evaluation.correlation.Spearman;

public class CorrelationFactory {
    public static Correlation getCorrelation(CorrelationType correlationType, MutualInformationData MIData) {
        switch (correlationType) {
            case PEARSON: {
                return new Pearson();
            }
            case SPEARMAN: {
                return new Spearman();
            }
            case PEARSON_RANK: {
                return new PearsonColumnRank();
            }
            case MUTUAL_INFORMATION: {
                if (!MIData.useBinning()) {
                    return new MutualInformationBinary();
                }
                if (MIData.isEqualElementBin()) {
                    return new MutualInformationEqualElem(MIData.getSizeType());
                }
                return new MutualInformationEqualRange(MIData.getSizeType());
            }
            case PEARSON_BIN_LOG_NORM: {
                return new LogScaledPearsonBinaryWithNormalization();
            }
            case PEARSON_BIN_LOG_NO_NORM: {
                return new LogScaledPearsonBinaryNoNormalization();
            }
        }
        throw new RuntimeException("Unknown correlation type:" + ((Object)((Object)correlationType)).getClass().getName());
    }

    public static enum CorrelationType {
        PEARSON,
        SPEARMAN,
        PEARSON_RANK,
        MUTUAL_INFORMATION,
        PEARSON_BIN_LOG_NORM,
        PEARSON_BIN_LOG_NO_NORM;

    }
}

