/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation.correlation;

import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.evaluation.ProfileData;
import org.genemania.engine.core.evaluation.correlation.Correlation;
import org.genemania.engine.core.evaluation.correlation.PearsonRow;

public abstract class AbstractPearson
implements Correlation {
    protected ProfileData geneData;
    protected PearsonRow[] rows;
    public static final double MIN_STDEV = 1.0E-12;

    protected abstract void createPearsonRow();

    protected abstract double getDTD();

    protected abstract double getDD();

    @Override
    public double computeCorrelations(int i, int j) {
        try {
            return PearsonRow.dot(this.rows[i], this.rows[j], this.getDTD(), this.getDD(), this.geneData.getGeneExpression().get(0).size());
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Please initialize the correlation with Correlation.init(ProfileData)");
        }
    }

    @Override
    public void init(ProfileData data) {
        this.geneData = data;
        this.rows = new PearsonRow[data.getGeneExpression().size()];
        this.createPearsonRow();
        this.normalize();
        this.replaceMissingData();
    }

    @Override
    public double getThresholdValue() {
        return 0.0;
    }

    protected void normalize() {
        List<Vector> geneExpressions = this.geneData.getGeneExpression();
        Vector counts = MatrixUtils.rowCountsIgnoreMissingData(geneExpressions);
        Vector means = MatrixUtils.rowMeanIgnoreMissingDataPearsonRow(this.rows, counts);
        Vector stdevs = MatrixUtils.rowVarianceIgnoreMissingDataPearsonRow(this.rows, means, counts);
        MatrixUtils.sqrt(stdevs);
        Vector sqrtCounts = counts.copy();
        MatrixUtils.sqrt(sqrtCounts);
        MatrixUtils.elementMult(stdevs, sqrtCounts);
        for (int i = 0; i < geneExpressions.size(); ++i) {
            double mean = means.get(i);
            double stdev = stdevs.get(i);
            if (stdev < 1.0E-12) {
                this.rows[i].zero();
                continue;
            }
            this.rows[i].normalize(mean, stdev);
        }
    }

    protected void replaceMissingData() {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].replaceMissingData(0.0);
        }
    }

    public static double getZeroRank(Vector v) {
        if (v instanceof DenseVector) {
            return 0.0;
        }
        if (v instanceof SparseVector) {
            int numZeroes = v.size() - ((SparseVector)v).getUsed();
            if (numZeroes == 0) {
                return 0.0;
            }
            return (double)((1 + numZeroes) * numZeroes) / (double)(2 * numZeroes);
        }
        throw new RuntimeException("unexpected vector type of " + v.getClass().getName());
    }
}

