/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.evaluation;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.genemania.engine.core.KHeap;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.evaluation.ProfileData;
import org.genemania.engine.core.evaluation.correlation.Correlation;
import org.genemania.engine.core.evaluation.correlation.CorrelationFactory;
import org.genemania.engine.core.evaluation.correlation.MutualInformationData;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.utils.FileUtils;
import org.genemania.exception.ApplicationException;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ProfileToNetworkDriver {
    private static Logger logger = Logger.getLogger(ProfileToNetworkDriver.class);
    private static final int MIN_NUMBER_OF_GENES = 1000;
    private ProfileData profile;
    private Matrix network;
    private ProgressReporter progress = NullProgressReporter.instance();
    private Map<String, String> synonyms = new LinkedHashMap<String, String>();
    private Map<String, List<Integer>> identifiers = new HashMap<String, List<Integer>>();
    public static final String CONTINUOUS = "cont";
    public static final String BINARY = "bin";
    public static final String NETWORK = "net";
    @Option(name="-in", usage="name of input file containing profile data")
    private String inFilename;
    @Option(name="-out", usage="name of output file to contain output network")
    private String outFilename;
    @Option(name="-k", usage="nearest k neighbours threshold")
    private int k = 50;
    @Option(name="-sep", usage="separator character for input file")
    private char sepChar = (char)9;
    @Option(name="-maxmissing", usage="max % of feature values for a given gene that are allowed to be missing before the entire gene is discarded")
    private double maxMissingPercentage = 25.0;
    @Option(name="-log", usage="name of processing log file to create (will truncate old file)")
    private String logFilename;
    @Option(name="-cor", usage="type of correlation to be computed")
    private CorrelationFactory.CorrelationType correlationType = CorrelationFactory.CorrelationType.PEARSON;
    @Option(name="-equalElementBin", usage="Do the bins have equal number of elements")
    private boolean equalElementBin = false;
    @Option(name="-binSize", usage="upper bound, lower bounder, or average of the two bounds")
    private MutualInformationData.SizeType sizeType = MutualInformationData.SizeType.MEDIAN;
    @Option(name="-proftype", usage="profile type: bin{ary}, cont{inuous} (default), net{work}")
    private String profileType = "cont";
    @Option(name="-syn", usage="name of identifier naming files")
    private String synFilename;
    @Option(name="-synsep", usage="separator character for synonuym file")
    private char synSepChar = (char)9;
    @Option(name="-synuid", usage="column # in synonym file for unique ids, 0-indexed")
    private int synIdColumn = 0;
    @Option(name="-synname", usage="column # in synonym file for identifier names, 0-indexed")
    private int synNameColumn = 1;
    @Option(name="-noHeader", usage="file does not have a header (for binary file only)")
    private boolean noHeader = false;
    @Option(name="-keepAllTies", usage="store more than top k if there are ties for the weakest interaction")
    private boolean keepAllTies = false;
    public static final String THRESHOLD_AUTO = "auto";
    public static final String THRESHOLD_OFF = "off";
    public static final String THRESHOLD_DEFAULT = "auto";
    @Option(name="-threshold", usage="only report correlations satisfying threshold, values=auto (method and possibly dataset dependent), off, default is auto")
    private String threshold = "auto";
    @Option(name="-limitTies")
    private boolean limitTies = false;
    static final double MAX_PERCENTAGE = 0.02;
    static final int MAX_ALLOWED_INTERACTIONS_INCLUDING_LEVEL_MATCH = 600;

    public static void main(String[] args) throws Exception {
        ProfileToNetworkDriver t = new ProfileToNetworkDriver();
        t.getCommandLineArgs(args);
        t.setupLogging();
        try {
            t.processProfile();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
        }
    }

    private void processProfile() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(this.inFilename));
        BufferedWriter out = new BufferedWriter(new FileWriter(this.outFilename));
        this.process(in, out);
        ((Writer)out).close();
        ((Reader)in).close();
    }

    public void process(Reader in, Writer out) throws IOException, ApplicationException {
        if (this.synonyms.size() == 0) {
            if (this.synFilename == null) {
                throw new ApplicationException("Please pass in the location of the identifier mapping file with -syn");
            }
            BufferedReader synonymSource = new BufferedReader(new FileReader(this.synFilename));
            this.synonyms = FileUtils.loadSynonyms(synonymSource, this.synSepChar, this.synIdColumn, this.synNameColumn, true);
        }
        if (this.profileType.toLowerCase().startsWith(CONTINUOUS)) {
            this.load(in, this.sepChar);
        } else if (this.profileType.toLowerCase().startsWith(BINARY)) {
            this.loadSparse(in, this.sepChar);
        } else if (this.profileType.toLowerCase().startsWith(NETWORK)) {
            this.loadNetwork(in, this.sepChar);
        } else {
            throw new ApplicationException("Unknown profile type: " + this.profileType);
        }
        if (this.progress.isCanceled()) {
            throw new CancellationException();
        }
        logger.info((Object)"computing network");
        long t1 = new Date().getTime();
        this.network = this.convertProfileToNetwork();
        long t2 = new Date().getTime();
        logger.info((Object)("Total genes in resulting network (after filtering/averaging): " + this.network.numRows()));
        logger.info((Object)("Time to compute network from profile (ms): " + (t2 - t1)));
        if (this.progress.isCanceled()) {
            throw new CancellationException();
        }
        PrintWriter writer = new PrintWriter(out);
        int totalInteractions = this.dump(writer);
        logger.info((Object)("Total #interactions in network (including symmetric interactions): " + totalInteractions));
        logger.info((Object)String.format("network sparsity: %.2f%%", (double)totalInteractions * 100.0 / (double)(this.network.numRows() * this.network.numColumns())));
        logger.info((Object)"done");
    }

    public void load(Reader source, char delim) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader(source, delim);
        ArrayList<Vector> geneExpressions = new ArrayList<Vector>(1000);
        ArrayList<String> geneList = new ArrayList<String>(1000);
        String[] header = null;
        int numFields = -1;
        int rowNum = !this.noHeader ? 0 : 1;
        while ((nextLine = reader.readNext()) != null) {
            String geneName;
            if (rowNum == 0) {
                header = nextLine;
                numFields = header.length;
                ++rowNum;
                this.logLine("skipping header", header);
                continue;
            }
            this.logLine("record " + rowNum, nextLine);
            if (numFields < 0) {
                numFields = nextLine.length;
            }
            if ((geneName = nextLine[0].trim().toUpperCase()) == null) {
                logger.info((Object)"skipping null key");
                continue;
            }
            if (!this.synonyms.containsKey(geneName)) {
                logger.info((Object)("name not found in identifer table (skipping): " + geneName));
                continue;
            }
            double[] values = new double[nextLine.length - 1];
            int zeroCounts = 0;
            for (int i = 1; i < nextLine.length; ++i) {
                double val;
                try {
                    val = Double.parseDouble(nextLine[i]);
                    if (Double.isNaN(val)) {
                        ++zeroCounts;
                    } else if (Double.isInfinite(val)) {
                        val = Double.NaN;
                        ++zeroCounts;
                    }
                }
                catch (NumberFormatException e) {
                    val = Double.NaN;
                    ++zeroCounts;
                }
                values[i - 1] = val;
            }
            if ((double)zeroCounts / (double)values.length * 100.0 < this.maxMissingPercentage) {
                String identifier = this.synonyms.get(geneName);
                List<Integer> index = this.identifiers.get(identifier);
                if (index == null) {
                    index = new ArrayList<Integer>();
                    this.identifiers.put(identifier, index);
                }
                index.add(rowNum - 1);
                geneList.add(geneName);
                DenseVector expressionLevels = new DenseVector(values);
                geneExpressions.add(rowNum - 1, (Vector)expressionLevels);
                ++rowNum;
                continue;
            }
            logger.info((Object)(geneName + " filtered out"));
        }
        int rows = geneExpressions.size();
        int cols = numFields - 1;
        logger.info((Object)("total gene records: " + rows));
        logger.info((Object)("total features: " + cols));
        this.profile = new ProfileData(geneExpressions, geneList);
    }

    public void loadSparse(Reader source, char delim) throws IOException {
        Object index;
        String[] nextLine;
        CSVReader reader = new CSVReader(source, delim);
        ArrayList<Vector> geneExpressions = new ArrayList<Vector>(1000);
        ArrayList<String> geneList = new ArrayList<String>(1000);
        int nextFeatureId = 0;
        HashMap<String, Integer> featureNameToIdMap = new HashMap<String, Integer>();
        ArrayList<Integer[]> allRows = new ArrayList<Integer[]>(1000);
        int rowNum = !this.noHeader ? 0 : 1;
        while ((nextLine = reader.readNext()) != null) {
            if (rowNum != 0) {
                String geneName = nextLine[0].toUpperCase().trim();
                String identifier = this.synonyms.get(geneName);
                index = this.identifiers.get(identifier);
                if (index == null) {
                    index = new ArrayList();
                    this.identifiers.put(identifier, (List<Integer>)index);
                }
                index.add(rowNum - 1);
                geneList.add(geneName);
                ArrayList<Object> indices = new ArrayList<Object>((nextLine.length - 1) / 2);
                for (int i = 1; i < nextLine.length; ++i) {
                    String featureName = nextLine[i];
                    if (featureNameToIdMap.containsKey(featureName)) {
                        indices.add(featureNameToIdMap.get(featureName));
                        continue;
                    }
                    featureNameToIdMap.put(featureName, nextFeatureId);
                    indices.add(nextFeatureId);
                    ++nextFeatureId;
                }
                Collections.sort(indices);
                allRows.add(indices.toArray(new Integer[0]));
            }
            ++rowNum;
        }
        for (Integer[] a : allRows) {
            index = new int[a.length];
            double[] data = new double[a.length];
            for (int i = 0; i < data.length; ++i) {
                data[i] = 1.0;
                index[i] = a[i];
            }
            SparseVector expressionLevels = new SparseVector(nextFeatureId, index, data);
            geneExpressions.add((Vector)expressionLevels);
        }
        int rows = geneExpressions.size();
        int cols = nextFeatureId - 1;
        logger.info((Object)("total gene records: " + rows));
        logger.info((Object)("total features: " + cols));
        this.profile = new ProfileData(geneExpressions, geneList);
    }

    public void loadNetwork(Reader source, char delim) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader(source, delim);
        HashMap<String, HashSet> features = new HashMap<String, HashSet>();
        boolean nextFeatureId = false;
        if (!this.noHeader) {
            reader.readNext();
        }
        while ((nextLine = reader.readNext()) != null) {
            HashSet set;
            String gene1 = nextLine[0].toUpperCase().trim();
            String gene2 = nextLine[1].toUpperCase().trim();
            if (features.containsKey(gene1)) {
                set = (HashSet)features.get(gene1);
                set.add(gene2);
            } else {
                set = new HashSet();
                set.add(gene2);
                features.put(gene1, set);
            }
            if (features.containsKey(gene2)) {
                set = (HashSet)features.get(gene2);
                set.add(gene1);
                continue;
            }
            set = new HashSet();
            set.add(gene1);
            features.put(gene2, set);
        }
        StringBuilder builder = new StringBuilder();
        if (!this.noHeader) {
            builder.append("header\n");
        }
        for (String gene : features.keySet()) {
            HashSet set = (HashSet)features.get(gene);
            builder.append(gene);
            for (String feature : set) {
                builder.append(delim);
                builder.append(feature);
            }
            builder.append("\n");
        }
        StringReader stringReader = new StringReader(builder.toString());
        this.loadSparse(stringReader, delim);
    }

    private Matrix convertProfileToNetwork() throws CancellationException {
        int j;
        int i;
        int numGene = this.profile.getGeneExpression().size();
        FlexCompColMatrix network = new FlexCompColMatrix(numGene, numGene);
        KHeap[] topInteractions = new KHeap[numGene];
        for (int i2 = 0; i2 < numGene; ++i2) {
            topInteractions[i2] = new KHeap(this.k, this.keepAllTies);
        }
        MutualInformationData MIData = null;
        if (this.correlationType == CorrelationFactory.CorrelationType.MUTUAL_INFORMATION) {
            if (this.profileType.toLowerCase().startsWith(CONTINUOUS)) {
                MIData = new MutualInformationData(true);
                MIData.setBinningInfo(this.equalElementBin, this.sizeType);
            } else {
                MIData = new MutualInformationData(false);
            }
        }
        Correlation cor = CorrelationFactory.getCorrelation(this.correlationType, MIData);
        logger.info((Object)"Initializing correlation with profile");
        long t1 = System.currentTimeMillis();
        cor.init(this.profile);
        long t2 = System.currentTimeMillis();
        logger.info((Object)("Correlation initialized. Total time: " + (t2 - t1)));
        double thresholdValue = cor.getThresholdValue();
        boolean isThresholdEnabled = "auto".equalsIgnoreCase(this.getThreshold());
        if (isThresholdEnabled) {
            logger.info((Object)("thresholding enabled at " + thresholdValue));
        }
        t1 = System.currentTimeMillis();
        Collection<List<Integer>> indices = this.identifiers.values();
        List[] indices_arr = indices.toArray(new ArrayList[0]);
        for (i = 0; i < indices_arr.length; ++i) {
            List i_indices = indices_arr[i];
            for (j = i + 1; j < indices_arr.length; ++j) {
                double totalCorrelation = 0.0;
                List j_indices = indices_arr[j];
                Iterator i$ = i_indices.iterator();
                while (i$.hasNext()) {
                    int i1 = (Integer)i$.next();
                    if (this.progress.isCanceled()) {
                        throw new CancellationException();
                    }
                    Iterator i$2 = j_indices.iterator();
                    while (i$2.hasNext()) {
                        int j1 = (Integer)i$2.next();
                        double correlation = cor.computeCorrelations(i1, j1);
                        totalCorrelation += correlation;
                    }
                }
                if (isThresholdEnabled && (totalCorrelation /= (double)(i_indices.size() * j_indices.size())) <= thresholdValue) continue;
                topInteractions[(Integer)i_indices.get(0)].offer((Integer)j_indices.get(0), totalCorrelation);
                topInteractions[(Integer)j_indices.get(0)].offer((Integer)i_indices.get(0), totalCorrelation);
            }
        }
        if (this.keepAllTies && this.limitTies) {
            this.levelControl(topInteractions);
        }
        for (i = 0; i < numGene; ++i) {
            int n = topInteractions[i].size();
            for (j = 0; j < n; ++j) {
                int i2 = (int)topInteractions[i].getId(j);
                double weight = topInteractions[i].getWeight(j);
                network.set(i, i2, weight);
            }
        }
        network = MatrixUtils.computeMaxTranspose((Matrix)network);
        t2 = System.currentTimeMillis();
        logger.info((Object)("Total time for calculating: " + (t2 - t1)));
        return network;
    }

    void levelControl(KHeap[] topInteractions) {
        int numGenes = this.getNumGenes();
        int sizeLimit = Math.max(this.k, Math.min((int)(0.02 * (double)numGenes), 600));
        logger.debug((Object)("level control at size limit of " + sizeLimit));
        for (KHeap heap : topInteractions) {
            if (heap.size() <= sizeLimit) continue;
            double lastLevel = heap.getWeight(0);
            int sizeBefore = heap.size();
            heap.popLE(lastLevel);
            logger.debug((Object)("trimmed heap from " + sizeBefore + " to " + heap.size()));
        }
    }

    int getNumGenes() {
        HashSet<String> uniqueIds = new HashSet<String>();
        uniqueIds.addAll(this.synonyms.values());
        return uniqueIds.size();
    }

    public int dump(PrintWriter writer) {
        DecimalFormat df = new DecimalFormat("#.#####");
        int n = 0;
        for (MatrixEntry e : this.network) {
            if (e.get() == 0.0 || e.row() == e.column()) continue;
            String line = this.profile.getGeneName().get(e.row()) + "\t" + this.profile.getGeneName().get(e.column()) + "\t" + df.format(e.get());
            writer.println(line);
            ++n;
        }
        return n;
    }

    private boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    private void setupLogging() throws Exception {
        if (this.logFilename == null) {
            return;
        }
        SimpleLayout layout = new SimpleLayout();
        FileAppender appender = new FileAppender((Layout)layout, this.logFilename, false);
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.DEBUG);
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setSepChar(char sepChar) {
        this.sepChar = sepChar;
    }

    public void setCorrelationType(CorrelationFactory.CorrelationType corType) {
        this.correlationType = corType;
    }

    public void setEqualElementBin(boolean equalElementBin) {
        this.equalElementBin = equalElementBin;
    }

    public void setSizeType(MutualInformationData.SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    public void setMaxMissingPercentage(double missingPercentage) {
        this.maxMissingPercentage = missingPercentage;
    }

    public void setSynSepChar(char synSepChar) {
        this.synSepChar = synSepChar;
    }

    public void setSynIdColumn(int col) {
        this.synIdColumn = col;
    }

    public void setSynNameColumn(int col) {
        this.synNameColumn = col;
    }

    public void setSynReader(Reader synReader) throws IOException {
        this.synonyms = FileUtils.loadSynonyms(synReader, this.synSepChar, this.synIdColumn, this.synNameColumn, true);
    }

    public boolean isNoHeader() {
        return this.noHeader;
    }

    public void setNoHeader(boolean val) {
        this.noHeader = val;
    }

    public void setProgressReporter(ProgressReporter progress) {
        this.progress = progress;
    }

    public ProgressReporter getProgressReporter() {
        return this.progress;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public boolean isKeepAllTies() {
        return this.keepAllTies;
    }

    public void setKeepAllTies(boolean keepAllTies) {
        this.keepAllTies = keepAllTies;
    }

    public boolean isLimitTies() {
        return this.limitTies;
    }

    public void setLimitTies(boolean limitTies) {
        this.limitTies = limitTies;
    }

    private void logLine(String msg, String[] line) {
    }
}

