/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.genemania.engine.core.data.Data;
import org.genemania.exception.ApplicationException;

public class NodeIds
extends Data {
    private static final long serialVersionUID = 7748900129975191354L;
    private long[] nodeIds;
    private Map<Long, Integer> reverseMap;

    public NodeIds(long organismId) {
        super("CORE", organismId);
    }

    public long[] getNodeIds() {
        return this.nodeIds;
    }

    public void setNodeIds(long[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), "nodeIds"};
    }

    public long getIdForIndex(int index) throws ApplicationException {
        try {
            return this.nodeIds[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ApplicationException("there is no id at index postion: " + index);
        }
    }

    public int getIndexForId(long id) throws ApplicationException {
        Integer index;
        if (this.reverseMap == null) {
            this.reverseMap = Data.makeReverseMap(this.nodeIds);
        }
        if ((index = this.reverseMap.get(id)) == null) {
            throw new ApplicationException("there is no index position for node id: " + id);
        }
        return index;
    }

    public List<Integer> getIndicesForIds(Collection<Long> ids) throws ApplicationException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Long id : ids) {
            indices.add(this.getIndexForId(id));
        }
        return indices;
    }
}

