/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core.data;

import no.uib.cipr.matrix.DenseMatrix;
import org.genemania.engine.core.data.Data;

public class KtK
extends Data {
    private static final long serialVersionUID = -513356220806789800L;
    private String goBranch;
    private DenseMatrix data;

    public KtK(String namespace, long organismId, String goBranch) {
        super(namespace, organismId);
        this.goBranch = goBranch;
    }

    @Override
    public KtK copy(String newNamespace) {
        KtK copy = new KtK(newNamespace, this.getOrganismId(), this.getGoBranch());
        DenseMatrix newData = this.data.copy();
        copy.setData(newData);
        return copy;
    }

    public DenseMatrix getData() {
        return this.data;
    }

    public void setData(DenseMatrix data) {
        this.data = data;
    }

    public String getGoBranch() {
        return this.goBranch;
    }

    public void setGoBranch(String goBranch) {
        this.goBranch = goBranch;
    }

    @Override
    public String[] getKey() {
        return new String[]{this.getNamespace(), "" + this.getOrganismId(), this.getGoBranch() + ".KtK"};
    }

    public void removeNetworkAtIndex(int index) {
        DenseMatrix newData = new DenseMatrix(this.data.numRows() - 1, this.data.numColumns() - 1);
        int k = 0;
        for (int i = 0; i < this.data.numRows(); ++i) {
            int l = 0;
            if (i == index) continue;
            for (int j = 0; j < this.data.numColumns(); ++j) {
                if (j == index) continue;
                newData.set(k, l, this.data.get(i, j));
                ++l;
            }
            ++k;
        }
        this.data = newData;
    }
}

