/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.core;

import java.io.PrintWriter;
import java.util.List;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import org.genemania.engine.core.KHeap;
import org.genemania.engine.core.MatrixUtils;

public class SparseBinaryToNetwork {
    int numFeatures;
    int numGenes;
    int[] numNonZerosPerFeature;
    double[] pf;
    double[] nf;
    double[] ppf;
    double[] pnf;
    double[] nnf;
    double baseline;
    KHeap[] topInteractions;

    public SparseBinaryToNetwork(int numGenes, int numFeatures) {
        this.numGenes = numGenes;
        this.numFeatures = numFeatures;
    }

    public void convert(List<int[]> profileData, int k) {
        this.countNonZerosPerFeature(profileData);
        this.computeFactors();
        this.computeNegBaseline();
        this.computeCorrelations(profileData, k);
    }

    protected void countNonZerosPerFeature(List<int[]> profileData) {
        this.numNonZerosPerFeature = new int[this.numFeatures];
        for (int[] g : profileData) {
            for (int i = 0; i < g.length; ++i) {
                int n = g[i];
                this.numNonZerosPerFeature[n] = this.numNonZerosPerFeature[n] + 1;
            }
        }
    }

    protected void computeFactors() {
        this.pf = new double[this.numFeatures];
        this.nf = new double[this.numFeatures];
        this.ppf = new double[this.numFeatures];
        this.pnf = new double[this.numFeatures];
        this.nnf = new double[this.numFeatures];
        for (int i = 0; i < this.numFeatures; ++i) {
            double mean = 1.0 * (double)this.numNonZerosPerFeature[i] / (double)this.numGenes;
            if (mean == 0.0) continue;
            this.pf[i] = -Math.log(mean);
            this.nf[i] = Math.log(1.0 - mean);
            this.ppf[i] = this.pf[i] * this.pf[i];
            this.pnf[i] = this.pf[i] * this.nf[i];
            this.nnf[i] = this.nf[i] * this.nf[i];
        }
    }

    protected void computeNegBaseline() {
        double baseline = 0.0;
        for (int i = 0; i < this.numFeatures; ++i) {
            baseline += this.nnf[i];
        }
        this.baseline = baseline;
    }

    protected double computeCorrelation(int[] a, int[] b) {
        int i = 0;
        int j = 0;
        double correction = 0.0;
        int u = 0;
        int v = 0;
        while (i < a.length || j < b.length) {
            u = i < a.length ? a[i] : this.numFeatures;
            if (u < (v = j < b.length ? b[j] : this.numFeatures)) {
                correction += -this.nnf[u] + this.pnf[u];
                ++i;
                continue;
            }
            if (u > v) {
                correction += -this.nnf[v] + this.pnf[v];
                ++j;
                continue;
            }
            correction += -this.nnf[u] + this.ppf[u];
            ++i;
            ++j;
        }
        return this.baseline + correction;
    }

    protected void computeCorrelations(List<int[]> profileData, int k) {
        int i;
        int numGenes = profileData.size();
        this.topInteractions = new KHeap[numGenes];
        for (i = 0; i < numGenes; ++i) {
            this.topInteractions[i] = new KHeap(k);
        }
        System.out.println("computing correlations");
        for (i = 0; i < numGenes; ++i) {
            for (int j = 0; j < i; ++j) {
                double weight = this.computeCorrelation(profileData.get(i), profileData.get(j));
                this.topInteractions[i].offer(j, weight);
                this.topInteractions[j].offer(i, weight);
            }
        }
        System.out.println("done");
    }

    public Matrix convertToInteractionMatrix() {
        int numGenes = this.topInteractions.length;
        FlexCompColMatrix matrix = new FlexCompColMatrix(numGenes, numGenes);
        for (int i = 0; i < numGenes; ++i) {
            int n = this.topInteractions[i].size();
            for (int j = 0; j < n; ++j) {
                int i2 = (int)this.topInteractions[i].getId(j);
                double weight = this.topInteractions[i].getWeight(j);
                matrix.set(i, i2, weight);
            }
        }
        matrix = MatrixUtils.computeMaxTranspose((Matrix)matrix);
        return matrix;
    }

    public int dump(PrintWriter writer, String[] geneNames) {
        int numGenes = this.topInteractions.length;
        int totalInteractions = 0;
        for (int i = 0; i < numGenes; ++i) {
            String name1 = geneNames[i];
            int n = this.topInteractions[i].size();
            for (int j = 0; j < n; ++j) {
                long id = this.topInteractions[i].getId(j);
                double weight = this.topInteractions[i].getWeight(j);
                String name2 = geneNames[(int)id];
                writer.println(name1 + "\t" + name2 + "\t" + weight);
                ++totalInteractions;
            }
        }
        return totalInteractions;
    }
}

