/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter;

import java.io.File;
import java.io.IOException;
import no.uib.cipr.matrix.Matrix;
import org.genemania.engine.converter.CursorNetworkMatrixProvider;
import org.genemania.engine.converter.INetworkMatrixProvider;
import org.genemania.engine.converter.Mapping;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.impl.FileInteractionCursor;
import org.genemania.util.ProgressReporter;

public class FileNetworkMatrixProvider
extends CursorNetworkMatrixProvider
implements INetworkMatrixProvider {
    private int organismId;
    private String networkDir;

    public FileNetworkMatrixProvider(int organismId, String networkDir, Mapping<String, Integer> mapping) {
        this.organismId = organismId;
        this.networkDir = networkDir;
        this.mapping = mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matrix getNetworkMatrix(int networkId, ProgressReporter progress) throws ApplicationException {
        File file;
        try {
            file = this.getFile(networkId);
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        this.cursor = new FileInteractionCursor((long)networkId, file, "UTF8", 0, 1, 2, '\t');
        try {
            Matrix matrix = this.convertNetworkToMatrix(progress);
            return matrix;
        }
        finally {
            this.cursor.close();
        }
    }

    private File getFile(long networkId) throws IOException {
        File file = new File(this.networkDir + File.separator + this.organismId + "." + networkId + ".txt.gz");
        if (file.exists()) {
            return file;
        }
        return new File(this.networkDir + File.separator + this.organismId + "." + networkId + ".txt");
    }
}

