/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.converter;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.CompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import org.apache.log4j.Logger;
import org.genemania.engine.converter.INetworkMatrixProvider;
import org.genemania.engine.converter.Mapping;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.InteractionCursor;
import org.genemania.util.ProgressReporter;

public abstract class CursorNetworkMatrixProvider
implements INetworkMatrixProvider {
    private static Logger logger = Logger.getLogger(CursorNetworkMatrixProvider.class);
    protected InteractionCursor cursor;
    protected Mapping<String, Integer> mapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Matrix convertNetworkToMatrix(ProgressReporter progress) throws ApplicationException {
        logger.debug((Object)String.format("loading interactions for network %d from db using cursor", this.cursor.getNetworkId()));
        progress.setMaximumProgress((int)this.cursor.getTotalInteractions());
        int count = 0;
        int n = this.mapping.size();
        FlexCompColMatrix matrix = new FlexCompColMatrix(n, n);
        try {
            while (this.cursor.next()) {
                progress.setProgress(count);
                int fromNodeIndex = this.mapping.getIndexForUniqueId((int)this.cursor.getFromNodeId());
                int toNodeIndex = this.mapping.getIndexForUniqueId((int)this.cursor.getToNodeId());
                double weight = this.cursor.getWeight();
                if (fromNodeIndex == -1) {
                    throw new ApplicationException("couldn't find fromNode id " + this.cursor.getFromNodeId());
                }
                if (toNodeIndex == -1) {
                    throw new ApplicationException("couldn't find toNode id " + this.cursor.getToNodeId());
                }
                matrix.set(fromNodeIndex, toNodeIndex, weight);
                ++count;
            }
        }
        finally {
            this.cursor.close();
        }
        MatrixUtils.setDiagonalZero((Matrix)matrix);
        MatrixUtils.setToMaxTranspose((Matrix)matrix);
        MatrixUtils.normalizeNetwork((Matrix)matrix);
        return new CompColMatrix((Matrix)matrix);
    }
}

