/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;

public class SoftRefObjectCache {
    RefMap softCache = new RefMap();
    static SoftRefObjectCache instance = new SoftRefObjectCache();

    SoftRefObjectCache() {
    }

    public static SoftRefObjectCache instance() {
        return instance;
    }

    public Object get(String key) {
        SoftReference ref = (SoftReference)this.softCache.get(key);
        if (ref == null) {
            this.softCache.remove(key);
            return null;
        }
        Object object = ref.get();
        if (object == null) {
            this.softCache.remove(key);
            return null;
        }
        return object;
    }

    public void put(String key, Object object) {
        SoftReference<Object> ref = new SoftReference<Object>(object);
        this.softCache.put(key, ref);
    }

    public void remove(String key) {
        this.softCache.remove(key);
    }

    public void clear() {
        this.softCache.clear();
    }

    public void compact() {
        for (String key : this.softCache.keySet()) {
            SoftReference ref = (SoftReference)this.softCache.get(key);
            if (ref == null) {
                this.softCache.remove(key);
                continue;
            }
            if (ref.get() != null) continue;
            this.softCache.remove(key);
        }
    }

    protected class RefMap
    extends HashMap<String, SoftReference<Object>> {
        protected RefMap() {
        }
    }
}

