/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import no.uib.cipr.matrix.Matrix;

public class NetworkMemCache {
    RefMap softCache = new RefMap();
    static NetworkMemCache instance = new NetworkMemCache();
    public static final String CORE = "core";

    NetworkMemCache() {
    }

    public static NetworkMemCache instance() {
        return instance;
    }

    public Matrix get(int organismId, int networkId) {
        return this.get(null, organismId, networkId);
    }

    public Matrix get(String namespace, int organismId, int networkId) {
        String key = this.makeKey(namespace, organismId, networkId);
        SoftReference ref = (SoftReference)this.softCache.get(key);
        if (ref == null) {
            this.softCache.remove(key);
            return null;
        }
        Matrix m = (Matrix)ref.get();
        if (m == null) {
            this.softCache.remove(key);
            return null;
        }
        return m;
    }

    public void put(int organismId, int networkId, Matrix network) {
        this.put(null, organismId, networkId, network);
    }

    public void put(String namespace, int organismId, int networkId, Matrix network) {
        String key = this.makeKey(namespace, organismId, networkId);
        SoftReference<Matrix> ref = new SoftReference<Matrix>(network);
        this.softCache.put(key, ref);
    }

    public void clear() {
        this.softCache.clear();
    }

    public void compact() {
        for (String key : this.softCache.keySet()) {
            SoftReference ref = (SoftReference)this.softCache.get(key);
            if (ref == null) {
                this.softCache.remove(key);
                continue;
            }
            if (ref.get() != null) continue;
            this.softCache.remove(key);
        }
    }

    private String makeKey(String namespace, int organismId, int networkId) {
        if (namespace == null) {
            return String.format("%s.%d.%d", CORE, organismId, networkId);
        }
        return String.format("%s.%d.%d", namespace, organismId, networkId);
    }

    protected class RefMap
    extends HashMap<String, SoftReference<Matrix>> {
        protected RefMap() {
        }
    }
}

