/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import no.uib.cipr.matrix.DenseVector;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.core.data.AttributeData;
import org.genemania.engine.core.data.AttributeGroups;
import org.genemania.engine.core.data.CategoryIds;
import org.genemania.engine.core.data.CoAnnotationSet;
import org.genemania.engine.core.data.CombinedNetwork;
import org.genemania.engine.core.data.Data;
import org.genemania.engine.core.data.DataSupport;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.FeatureTargetCorrelation;
import org.genemania.engine.core.data.GoAnnotations;
import org.genemania.engine.core.data.GoCoAnnotationCounts;
import org.genemania.engine.core.data.GoIds;
import org.genemania.engine.core.data.KtK;
import org.genemania.engine.core.data.KtKFeatures;
import org.genemania.engine.core.data.KtT;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.engine.core.data.NodeDegrees;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.engine.core.integration.Feature;
import org.genemania.engine.core.integration.FeatureList;
import org.genemania.engine.matricks.Matrix;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;

public class DataCache {
    private static Logger logger = Logger.getLogger(DataCache.class);
    private IObjectCache cache;

    public String getCacheDir() throws ApplicationException {
        return this.cache.getCacheDir();
    }

    public DataCache(IObjectCache cache) {
        this.cache = cache;
    }

    public void putNetwork(Network network) throws ApplicationException {
        if (!"CORE".equals(network.getNamespace()) && network.getId() >= 0L) {
            throw new ApplicationException("can not write core network into user namespace");
        }
        this.cache.put(network.getKey(), network.getData(), DataSupport.isVolatile(network));
    }

    public Network getNetwork(String namespace, long organismId, long networkId) throws ApplicationException {
        Network network = !"CORE".equals(namespace) && networkId >= 0L ? new Network("CORE", organismId, networkId) : new Network(namespace, organismId, networkId);
        SymMatrix data = (SymMatrix)this.cache.get(network.getKey(), DataSupport.isVolatile(network));
        network.setData(data);
        return network;
    }

    public NodeIds getNodeIds(long organismId) throws ApplicationException {
        NodeIds nodeIds = new NodeIds(organismId);
        nodeIds.setOrganismId(organismId);
        long[] data = (long[])this.cache.get(nodeIds.getKey(), DataSupport.isVolatile(nodeIds));
        nodeIds.setNodeIds(data);
        return nodeIds;
    }

    public void putNodeIds(NodeIds nodeIds) throws ApplicationException {
        this.cache.put(nodeIds.getKey(), nodeIds.getNodeIds(), DataSupport.isVolatile(nodeIds));
    }

    public NetworkIds getNetworkIds(String namespace, long organismId) throws ApplicationException {
        NetworkIds networkIds = new NetworkIds(namespace, organismId);
        long[] data = (long[])this.cache.get(networkIds.getKey(), DataSupport.isVolatile(networkIds));
        networkIds.setNetworkIds(data);
        return networkIds;
    }

    public void putNetworkIds(NetworkIds networkIds) throws ApplicationException {
        this.cache.put(networkIds.getKey(), networkIds.getNetworkIds(), DataSupport.isVolatile(networkIds));
    }

    public GoIds getGoIds(long organismId, String goBranch) throws ApplicationException {
        GoIds goIds = new GoIds(organismId, goBranch);
        String[] ids = (String[])this.cache.get(goIds.getKey(), DataSupport.isVolatile(goIds));
        goIds.setGoIds(ids);
        return goIds;
    }

    public void putGoIds(GoIds goIds) throws ApplicationException {
        this.cache.put(goIds.getKey(), goIds.getGoIds(), DataSupport.isVolatile(goIds));
    }

    public CategoryIds getCategoryIds(long organismId, long ontologyId) throws ApplicationException {
        CategoryIds categoryIds = new CategoryIds(organismId, ontologyId);
        long[] ids = (long[])this.cache.get(categoryIds.getKey(), DataSupport.isVolatile(categoryIds));
        categoryIds.setCategoryIds(ids);
        return categoryIds;
    }

    public void putCategoryIds(CategoryIds categoryIds) throws ApplicationException {
        this.cache.put(categoryIds.getKey(), categoryIds.getCategoryIds(), DataSupport.isVolatile(categoryIds));
    }

    public GoCoAnnotationCounts getGoCoAnnotationCounts(long organismId, String goBranch) throws ApplicationException {
        GoCoAnnotationCounts annoCounts = new GoCoAnnotationCounts(organismId, goBranch);
        SymMatrix data = (SymMatrix)this.cache.get(annoCounts.getKey(), DataSupport.isVolatile(annoCounts));
        annoCounts.setData(data);
        return annoCounts;
    }

    public void putGoCoAnnotationCounts(GoCoAnnotationCounts annoCounts) throws ApplicationException {
        this.cache.put(annoCounts.getKey(), annoCounts.getData(), DataSupport.isVolatile(annoCounts));
    }

    public GoAnnotations getGoAnnotations(long organismId, String goBranch) throws ApplicationException {
        GoAnnotations annos = new GoAnnotations(organismId, goBranch);
        Matrix data = (Matrix)this.cache.get(annos.getKey(), DataSupport.isVolatile(annos));
        annos.setData(data);
        return annos;
    }

    public void putGoAnnotations(GoAnnotations annos) throws ApplicationException {
        this.cache.put(annos.getKey(), annos.getData(), DataSupport.isVolatile(annos));
    }

    public void putCoAnnotationSet(CoAnnotationSet annoSet) throws ApplicationException {
        this.putData(annoSet);
    }

    public CoAnnotationSet getCoAnnotationSet(long organismId, String goBranch) throws ApplicationException {
        CoAnnotationSet annoSet = new CoAnnotationSet(organismId, goBranch);
        return (CoAnnotationSet)this.cache.get(annoSet.getKey(), DataSupport.isVolatile(annoSet));
    }

    public void putCombinedNetwork(CombinedNetwork combined) throws ApplicationException {
        this.cache.put(combined.getKey(), combined, DataSupport.isVolatile(combined));
    }

    public CombinedNetwork getCombinedNetwork(String namespace, long organismId, String methodParamKey) throws ApplicationException {
        CombinedNetwork combined = new CombinedNetwork(namespace, organismId, methodParamKey);
        combined = (CombinedNetwork)this.cache.get(combined.getKey(), DataSupport.isVolatile(combined));
        combined.fix();
        return combined;
    }

    public void putKtK(KtK ktk) throws ApplicationException {
        this.putData(ktk);
    }

    public KtK getKtK(String namespace, long organismId, String goBranch) throws ApplicationException {
        KtK ktk = new KtK(namespace, organismId, goBranch);
        return (KtK)this.cache.get(ktk.getKey(), DataSupport.isVolatile(ktk));
    }

    public void putKtT(KtT ktt) throws ApplicationException {
        this.putData(ktt);
    }

    public KtT getKtT(String namespace, long organismId, String goBranch) throws ApplicationException {
        KtT ktt = new KtT(namespace, organismId, goBranch);
        return (KtT)this.cache.get(ktt.getKey(), DataSupport.isVolatile(ktt));
    }

    public void putDatasetInfo(DatasetInfo info) throws ApplicationException {
        this.putData(info);
    }

    public DatasetInfo getDatasetInfo(long organismId) throws ApplicationException {
        DatasetInfo info = new DatasetInfo(organismId);
        return (DatasetInfo)this.cache.get(info.getKey(), DataSupport.isVolatile(info));
    }

    public void removeOrganism(String namespace, long organismId) throws ApplicationException {
        this.cache.remove(Data.getOrganismKey(namespace, organismId));
    }

    public void removeNamespace(String namespace) throws ApplicationException {
        this.cache.remove(Data.getNamespaceKey(namespace));
    }

    public NodeDegrees getNodeDegrees(String namespace, long organismId) throws ApplicationException {
        NodeDegrees nodeDegrees = new NodeDegrees(namespace, organismId);
        DenseVector degrees = (DenseVector)this.cache.get(nodeDegrees.getKey(), DataSupport.isVolatile(nodeDegrees));
        nodeDegrees.setDegrees(degrees);
        return nodeDegrees;
    }

    public void putNodeDegrees(NodeDegrees nodeDegrees) throws ApplicationException {
        this.cache.put(nodeDegrees.getKey(), nodeDegrees.getDegrees(), DataSupport.isVolatile(nodeDegrees));
    }

    public AttributeGroups getAttributeGroups(String namespace, long organismId) throws ApplicationException {
        AttributeGroups attributeGroups = new AttributeGroups(namespace, organismId);
        HashMap data = (HashMap)this.cache.get(attributeGroups.getKey(), DataSupport.isVolatile(attributeGroups));
        attributeGroups.setAttributeGroups(data);
        return attributeGroups;
    }

    public void putAttributeGroups(AttributeGroups attributeGroups) throws ApplicationException {
        this.cache.put(attributeGroups.getKey(), attributeGroups.getAttributeGroups(), DataSupport.isVolatile(attributeGroups));
    }

    public AttributeData getAttributeData(String namespace, long organismId, long attributeGroupId) throws ApplicationException {
        namespace = DataCache.checkNamespace(namespace, attributeGroupId);
        AttributeData attributeData = new AttributeData(namespace, organismId, attributeGroupId);
        Matrix data = (Matrix)this.cache.get(attributeData.getKey(), DataSupport.isVolatile(attributeData));
        attributeData.setData(data);
        return attributeData;
    }

    public void putAttributeData(AttributeData attributeData) throws ApplicationException {
        this.cache.put(attributeData.getKey(), attributeData.getData(), DataSupport.isVolatile(attributeData));
    }

    public FeatureTargetCorrelation getFeatureAttributeCorrelation(String namespace, long organismId, long attributeGroupId) throws ApplicationException {
        return (FeatureTargetCorrelation)this.getData(new FeatureTargetCorrelation(namespace, organismId, attributeGroupId));
    }

    public KtKFeatures getKtKFeatures(String namespace, long organismId) throws ApplicationException {
        KtKFeatures ktkFeatures = null;
        if (!namespace.equals("CORE")) {
            namespace = "CORE";
        }
        try {
            ktkFeatures = (KtKFeatures)this.getData(new KtKFeatures(namespace, organismId));
        }
        catch (ApplicationException e) {
            ktkFeatures = this.buildImplicitKtKFeatures(namespace, organismId);
        }
        return ktkFeatures;
    }

    private KtKFeatures buildImplicitKtKFeatures(String namespace, long organismId) throws ApplicationException {
        FeatureList featureList = new FeatureList();
        featureList.addBias();
        if (!namespace.equals("CORE")) {
            namespace = "CORE";
        }
        NetworkIds networkIds = this.getNetworkIds(namespace, organismId);
        long[] ids = networkIds.getNetworkIds();
        for (int i = 0; i < ids.length; ++i) {
            long networkId = ids[i];
            Feature feature = new Feature(Constants.NetworkType.SPARSE_MATRIX, 1L, networkId);
            featureList.add(feature);
        }
        KtKFeatures ktkFeatures = new KtKFeatures(namespace, organismId);
        ktkFeatures.setFeatures(featureList);
        return ktkFeatures;
    }

    public void initNamespace(String namespace, long organismId) throws ApplicationException {
        if (namespace == null || namespace.equals("")) {
            throw new ApplicationException("no namespace given");
        }
        if (namespace.equals("CORE")) {
            return;
        }
        if (this.namespaceExists(namespace, organismId)) {
            return;
        }
        NetworkIds coreNetworkIds = this.getNetworkIds("CORE", organismId);
        NetworkIds networkIds = coreNetworkIds.copy(namespace);
        this.putNetworkIds(networkIds);
        boolean ok = false;
        KtK userKtK = null;
        KtT[] userKtT = new KtT[Constants.goBranches.length];
        try {
            KtK coreUserKtK = this.getKtK("CORE", organismId, Constants.DataFileNames.KtK_BASIC.getCode());
            userKtK = coreUserKtK.copy(namespace);
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                KtT coreUserKtT = this.getKtT("CORE", organismId, Constants.goBranches[branch]);
                userKtT[branch] = coreUserKtT.copy(namespace);
            }
            ok = true;
        }
        catch (Exception e) {
            logger.debug((Object)"failed to load core KtK/KtT", (Throwable)e);
        }
        if (ok) {
            this.putKtK(userKtK);
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                this.putKtT(userKtT[branch]);
            }
        }
        AttributeGroups coreAttributeGroups = null;
        ok = false;
        try {
            coreAttributeGroups = this.getAttributeGroups("CORE", organismId);
            ok = true;
        }
        catch (Exception e) {
            logger.debug((Object)"failed to load core attribute groups", (Throwable)e);
        }
        if (ok) {
            AttributeGroups attributeGroups = new AttributeGroups(namespace, organismId);
            HashMap<Long, ArrayList<Long>> groupIds = new HashMap<Long, ArrayList<Long>>();
            for (Map.Entry<Long, ArrayList<Long>> entry : coreAttributeGroups.getAttributeGroups().entrySet()) {
                ArrayList value = new ArrayList();
                value.addAll(entry.getValue());
                groupIds.put(entry.getKey(), value);
            }
            attributeGroups.setAttributeGroups(groupIds);
            this.putAttributeGroups(attributeGroups);
        }
    }

    private boolean namespaceExists(String namespace, long organismId) throws ApplicationException {
        boolean exists = false;
        try {
            NetworkIds networkIds = this.getNetworkIds(namespace, organismId);
            exists = true;
        }
        catch (ApplicationException e) {
            // empty catch block
        }
        return exists;
    }

    public void putData(Data object) throws ApplicationException {
        this.cache.put(object.getKey(), object, DataSupport.isVolatile(object));
    }

    public void removeData(Data object) throws ApplicationException {
        this.cache.remove(object.getKey());
    }

    public Data getData(Data object) throws ApplicationException {
        return (Data)this.cache.get(object.getKey(), DataSupport.isVolatile(object));
    }

    private static String checkNamespace(String namespace, long objectId) throws ApplicationException {
        if (objectId < 0L) {
            if ("CORE".equals(namespace)) {
                throw new ApplicationException("user objects not allowed in core namespace");
            }
            return namespace;
        }
        return "CORE";
    }
}

