/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps.support;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import no.uib.cipr.matrix.Vector;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.engine.core.data.NodeIds;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.NodeMediator;

public class LabelWriter {
    private String basePath;
    private NodeMediator nodeMediator;
    private long organismId;

    public LabelWriter(String basePath, NodeMediator nodeMediator, long organismId) {
        this.basePath = basePath;
        this.nodeMediator = nodeMediator;
        this.organismId = organismId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String queryName, int fold, Vector label, Vector discriminant, Collection<Integer> labelIndices, NodeIds nodeIds) throws ApplicationException {
        FileWriter fileWriter;
        String path = String.format("%s-labels-%s-%d", this.basePath, queryName, fold);
        try {
            fileWriter = new FileWriter(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PrintWriter writer = new PrintWriter(fileWriter);
        try {
            List<LabelResult> results = this.sortResults(label, discriminant, labelIndices, nodeIds);
            for (LabelResult result : results) {
                writer.printf("%s\t%d\t%f\n", result.getName(), result.getLabel() == 1.0 ? 1 : 0, result.getScore());
            }
        }
        finally {
            writer.close();
        }
    }

    List<LabelResult> sortResults(Vector label, Vector discriminant, Collection<Integer> labelIndices, NodeIds nodeIds) throws ApplicationException {
        ArrayList<LabelResult> list = new ArrayList<LabelResult>();
        for (int index : labelIndices) {
            long nodeId = nodeIds.getIdForIndex(index);
            Node node = this.nodeMediator.getNode(nodeId, this.organismId);
            Gene gene = this.getPreferredGene(node);
            list.add(new LabelResult(gene.getSymbol(), label.get(index), discriminant.get(index)));
        }
        Collections.sort(list);
        return list;
    }

    Gene getPreferredGene(Node node) {
        Gene best = null;
        byte bestRank = -128;
        Collection genes = node.getGenes();
        for (Gene gene : genes) {
            byte rank = gene.getNamingSource().getRank();
            if (rank <= bestRank) continue;
            best = gene;
            bestRank = rank;
        }
        return best;
    }

    static class LabelResult
    implements Comparable<LabelResult> {
        private String name;
        private double label;
        private double score;

        public LabelResult(String name, double label, double score) {
            this.name = name;
            this.label = label;
            this.score = score;
        }

        public String getName() {
            return this.name;
        }

        public double getScore() {
            return this.score;
        }

        public double getLabel() {
            return this.label;
        }

        @Override
        public int compareTo(LabelResult other) {
            int result = Double.compare(this.score, other.score);
            if (result != 0) {
                return result;
            }
            result = Double.compare(this.label, other.label);
            if (result != 0) {
                return result;
            }
            return this.name.compareToIgnoreCase(other.name);
        }
    }
}

