/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.engine.IMania;
import org.genemania.engine.Mania2;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.FileSerializedObjectCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.validation.ResultWriter;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.type.CombiningMethod;
import org.genemania.type.ScoringMethod;
import org.genemania.util.NullProgressReporter;
import org.kohsuke.args4j.Option;

public class QueryBench
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(QueryBench.class);
    @Option(name="-method", usage="network combination method, should be one of 'equal' or 'smart'")
    private String combiningMethodName;
    @Option(name="-orgid", usage="organism id")
    private long organismId = -1L;
    @Option(name="-netids", usage="comma delim list of network ids to use eg '3,4,19', or 'all', or 'default'.")
    private String networkIdsList;
    @Option(name="-nodeids", usage="comma delim list of node ids eg '230,231,555', or 'default' for organism defaults")
    private String nodeIds;
    @Option(name="-out", usage="name of output file to contain validation results.")
    private String outFilename;
    @Option(name="-appendOut", usage="append to existing output file, if present. defaults to false, out file will be overriden")
    private boolean appendOut;
    @Option(name="-warmupIters", usage="# of warmup iterations to perform")
    private int warmupIters;
    @Option(name="-timingIters", usage="# of timing iterations to perform")
    private int timingIters;
    @Option(name="-clearMemCache", usage="clear memory cache between algorithm invocations, defaults to false")
    private boolean clearMemCache;
    @Option(name="-compCache", usage="use compressed cache, defaults to false")
    private boolean compressedCache;
    private Organism organism;
    private ResultWriter writer;
    private Collection<Collection<Long>> benchmarkNetworkIds;
    private Collection<Long> benchmarkNodeIds;
    private int numNodesUsed;
    private int numNetworksUsed;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = Long.MIN_VALUE;
    private long totalTime = 0L;

    public void initBench() throws Exception {
        logger.info((Object)"initializing benchmark");
        this.organism = this.getOrganism();
        this.benchmarkNetworkIds = this.getNetworkIdList();
        this.benchmarkNodeIds = this.getGeneIdList();
        if (this.outFilename != null) {
            File f = new File(this.outFilename);
            if (this.appendOut && f.exists()) {
                this.writer = new ResultWriter(this.outFilename, '\t', true);
            } else {
                this.writer = new ResultWriter(this.outFilename, '\t', false);
                this.writer.write(QueryBench.formatHeader());
                this.writer.flush();
            }
        } else {
            this.writer = ResultWriter.getNullWriter();
        }
    }

    private static void dumpSystemProperties() {
        Properties p = System.getProperties();
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)p.get(key);
            System.out.println(key + ": " + value);
        }
    }

    public void cleanupBench() {
        this.writer.close();
    }

    private Collection<Collection<Long>> getNetworkIdList() throws ApplicationException, DataStoreException {
        Collection<Collection<Long>> idList = null;
        idList = this.networkIdsList.equalsIgnoreCase("all") ? QueryBench.getAllNetworks(this.organism) : (this.networkIdsList.equalsIgnoreCase("default") ? QueryBench.getDefaultNetworks(this.organism) : QueryBench.getNetworksById(this.organism, this.networkIdsList));
        this.numNetworksUsed = QueryBench.count(idList);
        logger.info((Object)String.format("total %d networks selected", this.numNetworksUsed));
        return idList;
    }

    public List<Long> getGeneIdList() throws ApplicationException, DataStoreException {
        logger.info((Object)"loading gene list");
        if (this.nodeIds == null || this.nodeIds.equalsIgnoreCase("default")) {
            return this.getDefaultNodes();
        }
        return this.getNodesById();
    }

    private List<Long> getNodesById() throws ApplicationException {
        String[] idlist = this.nodeIds.split(",");
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; i < idlist.length; ++i) {
            Node node = this.nodeMediator.getNode(Long.parseLong(idlist[i]), this.organism.getId());
            if (node == null) {
                throw new ApplicationException("node id not found in db: " + idlist[i]);
            }
            result.add(node.getId());
        }
        this.numNodesUsed = result.size();
        return result;
    }

    private List<Long> getDefaultNodes() throws DataStoreException {
        List genes = this.organismMediator.getDefaultGenes(this.organism.getId());
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Gene gene : genes) {
            ids.add(gene.getNode().getId());
        }
        this.numNodesUsed = ids.size();
        return ids;
    }

    private Organism getOrganism() throws ApplicationException, DataStoreException {
        Organism organism = this.getOrganismById(this.organismId);
        logger.info((Object)("quering organism: " + organism.getName()));
        return organism;
    }

    private Organism getOrganismById(long organismId) throws ApplicationException, DataStoreException {
        Organism organism = this.organismMediator.getOrganism(organismId);
        return organism;
    }

    public void bench() throws Exception {
        int i;
        logger.info((Object)"performaing benchmark");
        IMania mania = this.getMania();
        logger.info((Object)String.format("executing %d warmup iterations", this.warmupIters));
        for (i = 0; i < this.warmupIters; ++i) {
            this.runQuery(mania, false);
        }
        logger.info((Object)String.format("executing %d timing iterations", this.timingIters));
        for (i = 0; i < this.timingIters; ++i) {
            this.runQuery(mania, true);
        }
    }

    private IMania getMania() {
        IObjectCache cache = new FileSerializedObjectCache(this.getCacheDir(), this.compressedCache);
        cache = new MemObjectCache(cache);
        return new Mania2(new DataCache(cache));
    }

    private void runQuery(IMania mania, boolean shouldReport) throws ApplicationException {
        RelatedGenesEngineRequestDto request = new RelatedGenesEngineRequestDto();
        request.setOrganismId(this.organism.getId());
        request.setCombiningMethod(CombiningMethod.AUTOMATIC);
        request.setScoringMethod(ScoringMethod.DISCRIMINANT);
        request.setPositiveNodes(this.benchmarkNodeIds);
        request.setInteractionNetworks(this.benchmarkNetworkIds);
        request.setLimitResults(10);
        request.setProgressReporter(NullProgressReporter.instance());
        if (this.clearMemCache) {
            mania.clearMemCache();
        }
        long t0 = System.nanoTime();
        RelatedGenesEngineResponseDto response = mania.findRelated(request);
        long t1 = System.nanoTime();
        long duration = t1 - t0;
        if (shouldReport) {
            if (duration < this.minTime) {
                this.minTime = duration;
            }
            if (duration > this.maxTime) {
                this.maxTime = duration;
            }
            this.totalTime += duration;
        }
    }

    public static List<String> formatHeader() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("organism id");
        fields.add("organism name");
        fields.add("combining method");
        fields.add("networks");
        fields.add("num networks");
        fields.add("num genes");
        fields.add("warmup iters");
        fields.add("timing iters");
        fields.add("clear mem cache");
        fields.add("status");
        fields.add("ave time");
        fields.add("min time");
        fields.add("max time");
        fields.add("java vm name");
        fields.add("java version");
        fields.add("max mem");
        return fields;
    }

    public List<String> formatResult(boolean success, String msg) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("" + this.organism.getId());
        fields.add("" + this.organism.getName());
        fields.add(this.combiningMethodName);
        fields.add(this.networkIdsList);
        fields.add("" + this.numNetworksUsed);
        fields.add("" + this.numNodesUsed);
        fields.add("" + this.warmupIters);
        fields.add("" + this.timingIters);
        fields.add("" + Boolean.toString(this.clearMemCache));
        if (success) {
            fields.add(msg);
            double secs = (double)this.totalTime * 1.0E-9;
            double aveSecs = secs / (double)this.timingIters;
            fields.add("" + aveSecs);
            secs = (double)this.minTime * 1.0E-9;
            fields.add("" + secs);
            secs = (double)this.maxTime * 1.0E-9;
            fields.add("" + secs);
        } else {
            fields.add(msg);
            fields.add("-");
            fields.add("-");
            fields.add("-");
        }
        fields.add(System.getProperty("java.vm.name"));
        fields.add(System.getProperty("java.version"));
        fields.add("" + Runtime.getRuntime().maxMemory());
        return fields;
    }

    public void reportBench(boolean success, String msg) {
        this.writer.write(this.formatResult(success, msg));
        this.writer.flush();
    }

    @Override
    public void process() throws Exception {
        try {
            this.bench();
            this.reportBench(true, "ok");
        }
        catch (OutOfMemoryError e) {
            logger.warn((Object)"out of memory", (Throwable)e);
            this.reportBench(false, "out of memory");
        }
        catch (Exception e) {
            logger.warn((Object)"unexpected error", (Throwable)e);
            this.reportBench(false, "unexpected error");
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.initBench();
    }

    @Override
    public void cleanup() throws Exception {
        this.cleanupBench();
        super.cleanup();
    }

    public static void main(String[] args) throws Exception {
        QueryBench bench = new QueryBench();
        if (!bench.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            bench.init();
            bench.process();
            bench.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal exception", (Throwable)e);
            System.exit(1);
        }
    }
}

