/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.config.Config;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.matricks.MatrixCursor;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.engine.summary.ReporterFactory;
import org.genemania.engine.summary.Summarizer;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.lucene.exporter.IndexUpdater;
import org.kohsuke.args4j.Option;

public class PostSparsifier
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(PostSparsifier.class);
    long total = 0L;
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private Long orgId = null;
    @Option(name="-group", usage="network group to sparsify specified by short code, defaults to coexp")
    private String group = "coexp";
    @Option(name="-thresh", usage="interaction count below which interactions will be pruned, defaults to 2")
    private int threshold = 2;
    private String reportSubdir;

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void summarize(Summarizer summarizer, ReporterFactory reporterFactory) throws Exception {
        summarizer.setUp();
        try {
            summarizer.summarize(reporterFactory);
        }
        finally {
            summarizer.tearDown();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    Collection<UpdateRecord> processOrganism(Organism organism) throws Exception {
        this.total = 0L;
        ArrayList<UpdateRecord> networksForSparsification = new ArrayList<UpdateRecord>();
        networksForSparsification.addAll(this.getNetworks(this.group, organism));
        if (networksForSparsification.size() == 0) {
            logger.warn((Object)("no networks to be sparsified for " + organism.getName()));
            return networksForSparsification;
        }
        logger.info((Object)"computing overlap");
        ArrayList<UpdateRecord> allNetworks = new ArrayList<UpdateRecord>();
        allNetworks.addAll(this.getNetworks("*", organism));
        SymMatrix overlap = this.computeOverlap(organism, allNetworks);
        logger.info((Object)"sparsifying");
        this.sparsifyAll(organism, networksForSparsification, overlap);
        return networksForSparsification;
    }

    public SymMatrix computeOverlap(Organism organism, ArrayList<UpdateRecord> networksList) throws Exception {
        SymMatrix overlap = null;
        for (UpdateRecord record : networksList) {
            Network network = this.getCache().getNetwork("CORE", organism.getId(), record.networkId);
            SymMatrix iData = network.getData();
            if (overlap == null) {
                int size = iData.numRows();
                overlap = Config.instance().getMatrixFactory().symSparseMatrix(size);
            }
            this.addCount(overlap, iData);
        }
        System.out.println(String.format("interactions total: %d", this.total));
        return overlap;
    }

    public void sparsifyAll(Organism organism, ArrayList<UpdateRecord> networksList, SymMatrix overlap) throws Exception {
        for (UpdateRecord record : networksList) {
            Network network = this.getCache().getNetwork("CORE", organism.getId(), record.networkId);
            SymMatrix networkData = network.getData();
            logger.info((Object)("sparsifying network " + record.networkId));
            SymMatrix sparsifiedNetworkData = this.sparsify(record, networkData, overlap);
            network.setData(sparsifiedNetworkData);
            this.getCache().putNetwork(network);
        }
    }

    public SymMatrix sparsify(UpdateRecord record, SymMatrix network, SymMatrix overlap) {
        SymMatrix sparsifiedNetwork = Config.instance().getMatrixFactory().symSparseMatrix(network.numRows());
        MatrixCursor cursor = network.cursor();
        int keepers = 0;
        int removed = 0;
        while (cursor.next()) {
            int c;
            int r = cursor.row();
            if (r <= (c = cursor.col())) continue;
            if (overlap.get(r, c) >= (double)this.threshold) {
                sparsifiedNetwork.set(r, c, cursor.val());
                ++keepers;
                continue;
            }
            ++removed;
        }
        sparsifiedNetwork.compact();
        record.newCount = keepers;
        logger.info((Object)String.format("kept %d, removed %d, reduction %5f%%", keepers, removed, (double)removed * 100.0 / (double)(keepers + removed)));
        return sparsifiedNetwork;
    }

    public void addCount(SymMatrix counts, SymMatrix m) {
        MatrixCursor cursor = m.cursor();
        while (cursor.next()) {
            double v;
            int c;
            int r = cursor.row();
            if (r <= (c = cursor.col()) || !((v = cursor.val()) > 0.0)) continue;
            ++this.total;
            counts.add(r, c, 1.0);
        }
    }

    @Override
    public void process() throws Exception {
        Date datasetDate = this.getStatsMediator().getLatestStatistics().getDate();
        System.out.println(datasetDate);
        logger.info((Object)("writing report to " + this.reportSubdir));
        ArrayList<UpdateRecord> allUpdateRecords = new ArrayList<UpdateRecord>();
        if (this.orgId != null) {
            Organism organism = this.getDataConnector().getOrganismMediator().getOrganism(this.orgId.longValue());
            allUpdateRecords.addAll(this.processOrganism(organism));
        } else {
            for (Organism organism : this.getDataConnector().getOrganismMediator().getAllOrganisms()) {
                logger.info((Object)String.format("Organism %d: %s", organism.getId(), organism.getName()));
                allUpdateRecords.addAll(this.processOrganism(organism));
            }
        }
        this.updateCounts(allUpdateRecords);
    }

    private Collection<UpdateRecord> getNetworks(String groupCode, Organism organism) throws ApplicationException, DataStoreException {
        Collection groups = organism.getInteractionNetworkGroups();
        ArrayList<UpdateRecord> records = new ArrayList<UpdateRecord>();
        for (InteractionNetworkGroup group : groups) {
            System.out.println(group.getName());
            if (!groupCode.equals("*") && !group.getCode().equals(groupCode)) continue;
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork n : networks) {
                NetworkMetadata metadata = n.getMetadata();
                logger.debug((Object)String.format("using network %d containing %d interactions from group %s: %s", n.getId(), metadata.getInteractionCount(), group.getName(), n.getName()));
                UpdateRecord record = new UpdateRecord(organism.getId(), n.getId(), metadata.getInteractionCount(), 0L);
                records.add(record);
            }
        }
        if (records.size() == 0) {
            throw new ApplicationException("no networks found!");
        }
        logger.info((Object)String.format("total %d networks selected", records.size()));
        return records;
    }

    private void updateCounts(Collection<UpdateRecord> records) throws IOException {
        this.getSearcher().close();
        IndexUpdater updater = new IndexUpdater(new File(this.getIndexDir()), this.getAnalyzer());
        for (UpdateRecord record : records) {
            if (record.oldCount == record.newCount) continue;
            updater.updateNetworkStats(record.organismId, record.networkId, record.newCount);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            PostSparsifier instance = new PostSparsifier();
            instance.getCommandLineArgs(args);
            instance.setupLogging();
            instance.init();
            instance.process();
            instance.cleanup();
            logger.info((Object)"Sparsification completed.");
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }

    class UpdateRecord {
        long organismId;
        long networkId;
        long oldCount;
        long newCount;

        UpdateRecord(long organismId, long networkId, long oldCount, long newCount) {
            this.organismId = organismId;
            this.networkId = networkId;
            this.oldCount = oldCount;
            this.newCount = newCount;
        }
    }
}

