/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.genemania.domain.Gene;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Organism;
import org.genemania.dto.NetworkDto;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.core.utils.ObjectSelector;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.lucene.exporter.IndexUpdater;
import org.genemania.type.CombiningMethod;
import org.genemania.type.ScoringMethod;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class DefaultNetworkSelector
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(DefaultNetworkSelector.class);
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private int orgId = -1;
    @Option(name="-num", usage="# of coexp networks to include in default set, defaults to 20")
    private int numCoexp = 20;
    private Mania2 mania2;
    private static String COEXP_GROUP_CODE = "coexp";

    @Override
    public void process() throws DataStoreException, ApplicationException, IOException {
        if (this.orgId == -1) {
            this.processAllOrganisms(NullProgressReporter.instance());
        } else {
            this.processOrganism(this.orgId, NullProgressReporter.instance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOrganisms(ProgressReporter progress) throws ApplicationException, DataStoreException, IOException {
        ArrayList<Long> organismIds = new ArrayList<Long>();
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            organismIds.add(organism.getId());
        }
        for (Long organismId : organismIds) {
            this.processOrganism(organismId, progress);
        }
    }

    public void processOrganism(long orgId, ProgressReporter progress) throws ApplicationException, DataStoreException, IOException {
        Organism organism = this.organismMediator.getOrganism(orgId);
        this.processOrganism(organism, progress);
    }

    public void processOrganism(Organism organism, ProgressReporter progress) throws ApplicationException, DataStoreException, IOException {
        logger.info((Object)("processing organism " + organism.getId() + " " + organism.getName()));
        Collection<Collection<Long>> networkIds = DefaultNetworkSelector.getDefaultPlusCoexpNetworks(organism);
        Collection<Long> coexpNetworks = this.getNetworkGroupByCode(organism, COEXP_GROUP_CODE);
        if (coexpNetworks.size() == 0) {
            logger.warn((Object)String.format("No coexp networks found for %s, skipping", organism.getName()));
        } else {
            RelatedGenesEngineRequestDto request = this.buildRequest(organism, networkIds);
            RelatedGenesEngineResponseDto response = this.mania2.findRelated(request);
            this.updateDefaultNetworks(organism, coexpNetworks, response);
        }
    }

    public static Collection<Collection<Long>> getDefaultPlusCoexpNetworks(Organism organism) throws ApplicationException, DataStoreException {
        int numFound = 0;
        Collection groups = organism.getInteractionNetworkGroups();
        ArrayList<Collection<Long>> ids = new ArrayList<Collection<Long>>();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            ArrayList<Long> list = new ArrayList<Long>();
            for (InteractionNetwork n : networks) {
                if (!n.isDefaultSelected() && !group.getCode().equalsIgnoreCase(COEXP_GROUP_CODE)) continue;
                NetworkMetadata metadata = n.getMetadata();
                list.add(n.getId());
                ++numFound;
            }
            if (list.size() <= 0) continue;
            ids.add(list);
        }
        if (ids.size() == 0) {
            throw new ApplicationException("no networks found!");
        }
        return ids;
    }

    private Collection<Long> getNetworkGroupByCode(Organism organism, String code) throws ApplicationException {
        int numFound = 0;
        Collection groups = organism.getInteractionNetworkGroups();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (InteractionNetworkGroup group : groups) {
            if (!group.getCode().equalsIgnoreCase(code)) continue;
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork n : networks) {
                ids.add(n.getId());
                ++numFound;
            }
        }
        if (ids.size() == 0) {
            throw new ApplicationException("no default networks found!");
        }
        return ids;
    }

    private void updateDefaultNetworks(Organism organism, Collection<Long> coexpNetworks, RelatedGenesEngineResponseDto response) throws IOException, ApplicationException {
        ArrayList<InteractionNetwork> topNetworks = this.getTopNetworks(response, coexpNetworks);
        if (topNetworks.size() == 0) {
            throw new ApplicationException(String.format("strange, selected no default coexpression networks for %s, please investigate!", organism.getName()));
        }
        this.getSearcher().close();
        IndexUpdater updater = new IndexUpdater(new File(this.getIndexDir()), this.getAnalyzer());
        for (Long id : coexpNetworks) {
            updater.updateNetworkIsDefault(organism.getId(), id.longValue(), false);
        }
        for (InteractionNetwork nw : topNetworks) {
            logger.info((Object)String.format("setting network %s for oganism %s to default", nw.getName(), organism.getName()));
            updater.updateNetworkIsDefault(organism.getId(), nw.getId(), true);
        }
        this.getAnalyzer().close();
        this.initLucene(this.getIndexDir());
        this.initDataConnector();
    }

    private ArrayList<InteractionNetwork> getTopNetworks(RelatedGenesEngineResponseDto response, Collection<Long> coexpNetworks) {
        ObjectSelector<InteractionNetwork> selector = new ObjectSelector<InteractionNetwork>();
        for (NetworkDto nwDto : response.getNetworks()) {
            long id = nwDto.getId();
            double weight = nwDto.getWeight();
            weight = -1.0 * weight;
            InteractionNetwork nw = this.dataConnector.getNetworkMediator().getNetwork(id);
            InteractionNetworkGroup group = this.dataConnector.getNetworkMediator().getNetworkGroupForNetwork(id);
            if (!group.getCode().equalsIgnoreCase(COEXP_GROUP_CODE)) continue;
            selector.add(nw, weight);
        }
        ObjectSelector result = selector.selectLevelledSmallestScores(this.numCoexp, this.numCoexp);
        return result.getElements();
    }

    Collection<Long> getDefaultGeneList(Organism organism) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Gene gene : organism.getDefaultGenes()) {
            ids.add(gene.getNode().getId());
        }
        return ids;
    }

    Collection<Long> getDefaultAttributeGroups(Organism organism) {
        return new ArrayList<Long>();
    }

    RelatedGenesEngineRequestDto buildRequest(Organism organism, Collection<Collection<Long>> networkIds) {
        RelatedGenesEngineRequestDto request = new RelatedGenesEngineRequestDto();
        request.setOrganismId(organism.getId());
        request.setAttributeGroups(new ArrayList());
        request.setCombiningMethod(CombiningMethod.BP);
        request.setScoringMethod(ScoringMethod.DISCRIMINANT);
        request.setInteractionNetworks(networkIds);
        request.setPositiveNodes(this.getDefaultGeneList(organism));
        request.setAttributeGroups(this.getDefaultAttributeGroups(organism));
        request.setProgressReporter(NullProgressReporter.instance());
        return request;
    }

    @Override
    public boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.mania2 = new Mania2(this.cache);
    }

    public static void main(String[] args) throws Exception {
        DefaultNetworkSelector selector = new DefaultNetworkSelector();
        if (!selector.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            selector.init();
            selector.process();
            selector.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

