/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.dto.AddOrganismEngineRequestDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.actions.AddOrganism;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.converter.sym.FileNetworkSymMatrixProvider;
import org.genemania.engine.converter.sym.INetworkSymMatrixProvider;
import org.genemania.engine.core.data.Network;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.NodeCursor;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class CacheBuilder
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(CacheBuilder.class);
    @Option(name="-networkDir", usage="if provided, networks are read as text files from the specified dir, otherwise networks are read from the INTERACTIONS table of the db")
    private String networkDir = null;
    @Option(name="-orgId", usage="optional organism id, otherwise will process all oganisms")
    private static int orgId = -1;

    public String getNetworkDir() {
        return this.networkDir;
    }

    public void setNetworkDir(String networkDir) {
        this.networkDir = networkDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOrganisms(ProgressReporter progress) throws ApplicationException, DataStoreException {
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism, progress);
        }
    }

    public void processOrganism(int orgId, ProgressReporter progress) throws ApplicationException, DataStoreException {
        Organism organism = this.organismMediator.getOrganism((long)orgId);
        this.processOrganism(organism, progress);
    }

    public void processOrganism(Organism organism, ProgressReporter progress) throws ApplicationException, DataStoreException {
        logger.info((Object)("processing organism " + organism.getId() + " " + organism.getName()));
        this.addOrganism(organism, progress);
        this.buildNetworkIds(organism, progress);
        this.buildNetworks(organism, progress);
    }

    public void addOrganism(Organism organism, ProgressReporter progress) throws ApplicationException, DataStoreException {
        List<Long> nodeIds = this.loadNodeIds(organism, progress);
        AddOrganismEngineRequestDto request = new AddOrganismEngineRequestDto();
        request.setOrganismId(organism.getId());
        request.setNodeIds(nodeIds);
        Mania2 mania = new Mania2(this.cache);
        mania.addOrganism(request);
    }

    public List<Long> loadNodeIds(Organism organism, ProgressReporter progress) throws ApplicationException, DataStoreException {
        NodeCursor cursor = this.organismMediator.createNodeCursor(organism.getId());
        ArrayList<Long> allNodeIds = new ArrayList<Long>();
        while (cursor.next()) {
            if (progress.isCanceled()) {
                logger.info((Object)"cancelled");
                return null;
            }
            allNodeIds.add(cursor.getId());
        }
        return allNodeIds;
    }

    public void buildNetworkIds(Organism organism, ProgressReporter progress) throws ApplicationException {
        logger.info((Object)("building network/index mapping for organism " + organism.getId()));
        ArrayList<Long> allNetworkIds = new ArrayList<Long>();
        Collection groups = organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            if (progress.isCanceled()) {
                return;
            }
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork network : networks) {
                allNetworkIds.add(network.getId());
            }
        }
        long[] table = AddOrganism.buildPrimitiveTable(allNetworkIds);
        NetworkIds networkIds = new NetworkIds("CORE", organism.getId());
        networkIds.setNetworkIds(table);
        this.cache.putNetworkIds(networkIds);
    }

    public void buildNetworks(Organism organism, ProgressReporter progress) throws ApplicationException {
        FileNetworkSymMatrixProvider provider = new FileNetworkSymMatrixProvider(organism.getId(), this.getNetworkDir(), this.cache.getNodeIds(organism.getId()), false);
        Collection groups = organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            if (progress.isCanceled()) {
                return;
            }
            Collection networks = group.getInteractionNetworks();
            for (InteractionNetwork network : networks) {
                this.processNetwork(provider, organism, network, progress);
            }
        }
    }

    public void processNetwork(INetworkSymMatrixProvider provider, Organism organism, InteractionNetwork network, ProgressReporter progress) throws ApplicationException {
        logger.info((Object)("building matrix for network " + network.getId() + " " + network.getName() + " organism " + organism.getId()));
        SymMatrix matrix = provider.getNetworkMatrix(network.getId(), progress);
        matrix.compact();
        Network networkObj = new Network("CORE", organism.getId(), network.getId());
        networkObj.setData(matrix);
        this.cache.putNetwork(networkObj);
    }

    @Override
    public boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    public void createCacheDir() {
        File dir = new File(this.getCacheDir());
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public void logParams() {
        logger.info((Object)("network dir: " + this.networkDir));
        logger.info((Object)("cache dir: " + this.getCacheDir()));
    }

    @Override
    public void process() throws DataStoreException, ApplicationException {
        if (orgId == -1) {
            this.processAllOrganisms(NullProgressReporter.instance());
        } else {
            this.processOrganism(orgId, NullProgressReporter.instance());
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.createCacheDir();
        this.logParams();
    }

    public static void main(String[] args) throws Exception {
        CacheBuilder cacheBuilder = new CacheBuilder();
        if (!cacheBuilder.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            cacheBuilder.init();
            cacheBuilder.process();
            cacheBuilder.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

