/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Organism;
import org.genemania.dto.AddAttributeGroupEngineRequestDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.actions.support.attribute.SparseAttributeProfileCursor;
import org.genemania.engine.apps.AbstractEngineApp;
import org.genemania.engine.utils.FileUtils;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class AttributeBuilder
extends AbstractEngineApp {
    private static Logger logger = Logger.getLogger(AttributeBuilder.class);
    static char SEP = (char)9;
    @Option(name="-genericDbDir", usage="folder containing data for loading")
    private static String genericDbDir;
    Mania2 mania;
    Map<String, String[]> schemas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllOrganisms(ProgressReporter progress) throws ApplicationException, DataStoreException {
        for (Organism organism : this.organismMediator.getAllOrganisms()) {
            this.processOrganism(organism, progress);
        }
    }

    public void processOrganism(int orgId, ProgressReporter progress) throws ApplicationException, DataStoreException {
        Organism organism = this.organismMediator.getOrganism((long)orgId);
        this.processOrganism(organism, progress);
    }

    public void processOrganism(Organism organism, ProgressReporter progress) throws ApplicationException, DataStoreException {
        logger.info((Object)("processing organism " + organism.getId() + " " + organism.getName()));
        this.buildAttributes(organism, progress);
    }

    public void buildAttributes(Organism organism, ProgressReporter progress) throws ApplicationException {
        try {
            List<AttributeGroup> grps = this.getAttributeGroups(organism.getId());
            for (AttributeGroup group : grps) {
                logger.info((Object)("processing group " + group.getId()));
                AddAttributeGroupEngineRequestDto request = new AddAttributeGroupEngineRequestDto();
                request.setAttributeGroupId(group.getId());
                request.setNamespace("CORE");
                request.setOrganismId(organism.getId());
                request.setProgressReporter(progress);
                ArrayList<Long> attributeIds = new ArrayList<Long>();
                List<Attribute> attrs = this.getAttributes(group.getId());
                for (Attribute attr : attrs) {
                    attributeIds.add(attr.getId());
                }
                request.setAttributeIds(attributeIds);
                String filename = genericDbDir + File.separator + "ATTRIBUTES" + File.separator + group.getId() + ".txt";
                ArrayList<ArrayList<Long>> nodeAttributeAssociations = this.loadAssocs(filename);
                request.setNodeAttributeAssociations(nodeAttributeAssociations);
                this.mania.addAttributeGroup(request);
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    ArrayList<ArrayList<Long>> loadAssocs(String filename) throws FileNotFoundException, ApplicationException {
        ArrayList<ArrayList<Long>> nodeAttributeAssociations = new ArrayList<ArrayList<Long>>();
        SparseAttributeProfileCursor cursor = new SparseAttributeProfileCursor(new FileReader(filename), SEP);
        while (cursor.next()) {
            ArrayList<Long> assoc = new ArrayList<Long>();
            assoc.add(cursor.getNodeId());
            assoc.add(cursor.getAttributeId());
            nodeAttributeAssociations.add(assoc);
        }
        return nodeAttributeAssociations;
    }

    @Override
    public boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    public void createCacheDir() {
        File dir = new File(this.getCacheDir());
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public void logParams() {
        logger.info((Object)("cache dir: " + this.getCacheDir()));
    }

    @Override
    public void process() throws DataStoreException, ApplicationException, IOException {
        String schemaFile = genericDbDir + File.separator + "SCHEMA.txt";
        this.loadSchemas(schemaFile);
        this.processAllOrganisms(NullProgressReporter.instance());
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.createCacheDir();
        this.mania = new Mania2(this.cache);
        this.logParams();
    }

    public static void main(String[] args) throws Exception {
        AttributeBuilder cacheBuilder = new AttributeBuilder();
        if (!cacheBuilder.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            cacheBuilder.init();
            cacheBuilder.process();
            cacheBuilder.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }

    void loadSchemas(String schemaFile) throws IOException {
        this.schemas = new HashMap<String, String[]>();
        BufferedReader reader = new BufferedReader(new FileReader(schemaFile));
        Vector<String[]> lines = FileUtils.loadRecords(reader, SEP, '#');
        for (String[] line : lines) {
            String name = line[0];
            String[] fields = new String[line.length - 1];
            System.arraycopy(line, 1, fields, 0, fields.length);
            this.schemas.put(name, fields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttributeGroup> getAttributeGroups(long organismId) throws NumberFormatException, IOException {
        ArrayList<AttributeGroup> result = new ArrayList<AttributeGroup>();
        String filename = genericDbDir + File.separator + "ATTRIBUTE_GROUPS.txt";
        String[] schema = this.schemas.get("ATTRIBUTE_GROUPS");
        TextCursor cursor = new TextCursor(schema, filename, "ORGANISM_ID", "" + organismId);
        try {
            while (cursor.next()) {
                AttributeGroup grp = new AttributeGroup();
                grp.setId(Long.parseLong(cursor.get("ID")));
                result.add(grp);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Attribute> getAttributes(long groupId) throws IOException {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        String filename = genericDbDir + File.separator + "ATTRIBUTES.txt";
        String[] schema = this.schemas.get("ATTRIBUTES");
        TextCursor cursor = new TextCursor(schema, filename, "ATTRIBUTE_GROUP_ID", "" + groupId);
        try {
            while (cursor.next()) {
                Attribute attr = new Attribute();
                attr.setId(Long.parseLong(cursor.get("ID")));
                result.add(attr);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    static class TextCursor {
        Map<String, Integer> schema = new HashMap<String, Integer>();
        CSVReader reader;
        String[] line;
        String filterKey;
        String filterVal;

        TextCursor(String[] schema, String filename, String filterKey, String filterVal) throws FileNotFoundException {
            this.filterKey = filterKey;
            this.filterVal = filterVal;
            this.loadSchema(schema);
            this.reader = new CSVReader((Reader)new BufferedReader(new FileReader(filename)), SEP);
        }

        void loadSchema(String[] schema) {
            for (int i = 0; i < schema.length; ++i) {
                this.schema.put(schema[i], i);
            }
        }

        boolean next() throws IOException {
            do {
                this.line = this.reader.readNext();
                if (this.line != null) continue;
                return false;
            } while (this.filterKey == null || !this.line[this.schema.get(this.filterKey)].equals(this.filterVal));
            return true;
        }

        String get(String field) {
            int index = this.schema.get(field);
            return this.line[index];
        }

        void close() throws IOException {
            this.reader.close();
        }
    }
}

