/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.apps;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.SimpleLayout;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Organism;
import org.genemania.engine.apps.support.DataConnector;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.FileSerializedObjectCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.engine.config.Config;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.NetworkMediator;
import org.genemania.mediator.NodeMediator;
import org.genemania.mediator.OntologyMediator;
import org.genemania.mediator.OrganismMediator;
import org.genemania.mediator.StatsMediator;
import org.genemania.mediator.lucene.LuceneAttributeMediator;
import org.genemania.mediator.lucene.LuceneGeneMediator;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneNetworkMediator;
import org.genemania.mediator.lucene.LuceneNodeMediator;
import org.genemania.mediator.lucene.LuceneOntologyMediator;
import org.genemania.mediator.lucene.LuceneOrganismMediator;
import org.genemania.mediator.lucene.LuceneStatsMediator;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public abstract class AbstractEngineApp {
    private static Logger logger = Logger.getLogger(AbstractEngineApp.class);
    @Option(name="-cachedir", usage="location of cache directory")
    private String cacheDir;
    @Option(name="-indexDir", usage="location of lucene indices")
    String indexDir;
    @Option(name="-log", usage="name of processing log file to create (will truncate old file)")
    String logFilename;
    @Option(name="-config", usage="optional, properties file containing engine settings like regularization etc. To explicitly specify builtin defaults, use DEFAULT")
    private String engineConfig = "DEFAULT";
    private static final String DEFAULT_ENGINE_CONFIG_SPECIFIER = "DEFAULT";
    DataConnector dataConnector;
    Analyzer analyzer;
    Searcher searcher;
    OrganismMediator organismMediator;
    NetworkMediator networkMediator;
    GeneMediator geneMediator;
    NodeMediator nodeMediator;
    OntologyMediator ontologyMediator;
    StatsMediator statsMediator;
    AttributeMediator attributeMediator;
    DataCache cache;

    protected static Searcher createSearcher(String indexPath) throws IOException {
        ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
        File indices = new File(indexPath);
        for (File file : indices.listFiles()) {
            if (!LuceneMediator.indexExists((File)file)) continue;
            try {
                FSDirectory directory = FSDirectory.open((File)file);
                searchers.add(new IndexSearcher((Directory)directory));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (searchers.size() == 0) {
            throw new IOException("No indices found");
        }
        return new MultiSearcher(searchers.toArray(new Searchable[searchers.size()]));
    }

    public void initLucene(String indexDir) throws IOException {
        this.analyzer = LuceneMediator.createDefaultAnalyzer();
        this.searcher = AbstractEngineApp.createSearcher(indexDir);
        this.setGeneMediator((GeneMediator)new LuceneGeneMediator(this.searcher, this.analyzer));
        this.setNetworkMediator((NetworkMediator)new LuceneNetworkMediator(this.searcher, this.analyzer));
        this.setOrganismMediator((OrganismMediator)new LuceneOrganismMediator(this.searcher, this.analyzer));
        this.setNodeMediator((NodeMediator)new LuceneNodeMediator(this.searcher, this.analyzer));
        this.setOntologyMediator((OntologyMediator)new LuceneOntologyMediator(this.searcher, this.analyzer));
        this.setStatsMediator((StatsMediator)new LuceneStatsMediator(this.searcher, this.analyzer));
        this.setAttributeMediator((AttributeMediator)new LuceneAttributeMediator(this.searcher, this.analyzer));
    }

    void initDataConnector() {
        DataConnector dataConnector = new DataConnector();
        dataConnector.setCache(this.cache);
        dataConnector.setGeneMediator(this.geneMediator);
        dataConnector.setNetworkMediator(this.networkMediator);
        dataConnector.setNodeMediator(this.nodeMediator);
        dataConnector.setOntologyMediator(this.ontologyMediator);
        dataConnector.setOrganismMediator(this.organismMediator);
        dataConnector.setStatsMediator(this.statsMediator);
        dataConnector.setAttributeMediator(this.attributeMediator);
        this.setDataConnector(dataConnector);
    }

    public static Collection<Collection<Long>> getDefaultNetworks(Organism organism) throws ApplicationException, DataStoreException {
        int numFound = 0;
        Collection groups = organism.getInteractionNetworkGroups();
        ArrayList<Collection<Long>> ids = new ArrayList<Collection<Long>>();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            ArrayList<Long> list = new ArrayList<Long>();
            for (InteractionNetwork n : networks) {
                if (!n.isDefaultSelected()) continue;
                NetworkMetadata metadata = n.getMetadata();
                logger.info((Object)String.format("using default network %d containing %d interactions from group %s: %s", n.getId(), metadata.getInteractionCount(), group.getName(), n.getName()));
                list.add(n.getId());
                ++numFound;
            }
            if (list.size() <= 0) continue;
            ids.add(list);
        }
        if (ids.size() == 0) {
            throw new ApplicationException("no default networks found!");
        }
        return ids;
    }

    public static Collection<Collection<Long>> getAllNetworks(Organism organism) {
        Collection groups = organism.getInteractionNetworkGroups();
        int numFound = 0;
        ArrayList<Collection<Long>> ids = new ArrayList<Collection<Long>>();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            ArrayList<Long> list = new ArrayList<Long>();
            for (InteractionNetwork n : networks) {
                list.add(n.getId());
                ++numFound;
            }
            if (list.size() <= 0) continue;
            ids.add(list);
        }
        return ids;
    }

    static Collection<Collection<Long>> getNetworksById(Organism organism, String idsArg) throws ApplicationException, DataStoreException {
        String[] parts = idsArg.split(",");
        HashSet<String> wantedIds = new HashSet<String>();
        wantedIds.addAll(Arrays.asList(parts));
        int numFound = 0;
        Collection groups = organism.getInteractionNetworkGroups();
        ArrayList<Collection<Long>> ids = new ArrayList<Collection<Long>>();
        for (InteractionNetworkGroup group : groups) {
            Collection networks = group.getInteractionNetworks();
            ArrayList<Long> list = new ArrayList<Long>();
            for (InteractionNetwork n : networks) {
                NetworkMetadata metadata = n.getMetadata();
                String key = "" + n.getId();
                if (!wantedIds.contains(key)) continue;
                logger.info((Object)String.format("using network %d containing %d interactions from group %s: %s", n.getId(), metadata.getInteractionCount(), group.getName(), n.getName()));
                list.add(n.getId());
                ++numFound;
            }
            if (list.size() <= 0) continue;
            ids.add(list);
        }
        if (numFound != parts.length) {
            throw new ApplicationException("some of the specified networks could not be found");
        }
        return ids;
    }

    public static int count(Collection<Collection<Long>> networkIds) {
        int sum = 0;
        for (Collection<Long> group : networkIds) {
            sum += group.size();
        }
        return sum;
    }

    public void initDataCache(String cacheDir, boolean memCacheEnabled) {
        IObjectCache objectCache = new FileSerializedObjectCache(cacheDir);
        if (memCacheEnabled) {
            objectCache = new MemObjectCache(objectCache);
        }
        objectCache = new SynchronizedObjectCache(objectCache);
        this.cache = new DataCache(objectCache);
    }

    public void initDataCache(String cacheDir) {
        this.initDataCache(cacheDir, true);
    }

    public DataCache getCache() {
        return this.cache;
    }

    public void setCache(DataCache cache) {
        this.cache = cache;
    }

    public GeneMediator getGeneMediator() {
        return this.geneMediator;
    }

    public void setGeneMediator(GeneMediator geneMediator) {
        this.geneMediator = geneMediator;
    }

    public NetworkMediator getNetworkMediator() {
        return this.networkMediator;
    }

    public void setNetworkMediator(NetworkMediator networkMediator) {
        this.networkMediator = networkMediator;
    }

    public NodeMediator getNodeMediator() {
        return this.nodeMediator;
    }

    public void setNodeMediator(NodeMediator nodeMediator) {
        this.nodeMediator = nodeMediator;
    }

    public OrganismMediator getOrganismMediator() {
        return this.organismMediator;
    }

    public void setOrganismMediator(OrganismMediator organismMediator) {
        this.organismMediator = organismMediator;
    }

    public OntologyMediator getOntologyMediator() {
        return this.ontologyMediator;
    }

    public void setOntologyMediator(OntologyMediator ontologyMediator) {
        this.ontologyMediator = ontologyMediator;
    }

    public StatsMediator getStatsMediator() {
        return this.statsMediator;
    }

    public void setStatsMediator(StatsMediator statsMediator) {
        this.statsMediator = statsMediator;
    }

    public AttributeMediator getAttributeMediator() {
        return this.attributeMediator;
    }

    public void setAttributeMediator(AttributeMediator attributeMediator) {
        this.attributeMediator = attributeMediator;
    }

    public void setDataConnector(DataConnector dataConnector) {
        this.dataConnector = dataConnector;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        AbstractEngineApp.logger = logger;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String indexDir) {
        this.indexDir = indexDir;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public void setLogFilename(String logFilename) {
        this.logFilename = logFilename;
    }

    public void setEngineConfig(String engineConfig) {
        this.engineConfig = engineConfig;
    }

    public String getEngineConfig() {
        return this.engineConfig;
    }

    public DataConnector getDataConnector() {
        return this.dataConnector;
    }

    public boolean getCommandLineArgs(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar myprogram.jar [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.setupLogging();
        this.initLucene(this.indexDir);
        this.loadEngineConfig();
        this.initDataCache(this.cacheDir);
        this.initDataConnector();
    }

    public void loadEngineConfig() throws ApplicationException {
        if (this.getEngineConfig() != null && !this.getEngineConfig().equalsIgnoreCase(DEFAULT_ENGINE_CONFIG_SPECIFIER)) {
            logger.info((Object)("loading engine configuration from " + this.getEngineConfig()));
            Config.reload(this.getEngineConfig());
        }
    }

    public void cleanup() throws Exception {
        logger.info((Object)"done");
    }

    public void setupLogging() throws Exception {
        ConsoleAppender appender;
        if (this.logFilename == null) {
            return;
        }
        if (this.logFilename.equalsIgnoreCase("console")) {
            SimpleLayout layout = new SimpleLayout();
            appender = new ConsoleAppender((Layout)layout);
        } else {
            PatternLayout layout = new PatternLayout("%d{HH:mm:ss} %-5p: %m%n");
            appender = new FileAppender((Layout)layout, this.logFilename, false);
        }
        Logger.getLogger((String)"org.genemania").setLevel(Level.DEBUG);
        Logger.getRootLogger().addAppender((Appender)appender);
    }

    public abstract void process() throws Exception;

    public static void main(String[] args) throws Exception {
        AbstractEngineApp app = new AbstractEngineApp(){

            @Override
            public void process() throws Exception {
                for (Organism organism : this.getDataConnector().getOrganismMediator().getAllOrganisms()) {
                    logger.info((Object)String.format("Organism %d: %s", organism.getId(), organism.getName()));
                }
            }
        };
        if (!app.getCommandLineArgs(args)) {
            System.exit(1);
        }
        try {
            app.init();
            app.process();
            app.cleanup();
        }
        catch (Exception e) {
            logger.error((Object)"Fatal error", (Throwable)e);
            System.exit(1);
        }
    }
}

