/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions.support.attribute;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import org.genemania.engine.actions.support.attribute.AttributeCursor;
import org.genemania.exception.ApplicationException;

public class SparseAttributeProfileCursor
implements AttributeCursor {
    CSVReader csvReader;
    protected String[] nextLine;
    int pos;

    public SparseAttributeProfileCursor(Reader reader, char delim) throws ApplicationException {
        this.csvReader = new CSVReader((Reader)new BufferedReader(reader), delim);
    }

    public SparseAttributeProfileCursor(File file, String fileEncoding, char delim) throws ApplicationException {
        try {
            InputStream stream = this.getStream(file);
            BufferedReader source = new BufferedReader(new InputStreamReader(stream, fileEncoding));
            this.csvReader = new CSVReader((Reader)source, delim);
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private InputStream getStream(File file) throws FileNotFoundException {
        try {
            return new GZIPInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return new FileInputStream(file);
        }
    }

    @Override
    public long getNodeId() {
        return Long.parseLong(this.nextLine[0]);
    }

    @Override
    public long getAttributeId() {
        return Long.parseLong(this.nextLine[this.pos]);
    }

    @Override
    public boolean next() throws ApplicationException {
        boolean next = this.nextAssociation();
        if (next) {
            return true;
        }
        return this.nextLine();
    }

    private boolean nextLine() throws ApplicationException {
        try {
            this.nextLine = this.csvReader.readNext();
            this.pos = 1;
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
        return this.nextLine != null;
    }

    private boolean nextAssociation() throws ApplicationException {
        if (this.nextLine == null) {
            return false;
        }
        if (this.pos + 1 < this.nextLine.length) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws ApplicationException {
        if (this.csvReader != null) {
            try {
                this.csvReader.close();
                this.csvReader = null;
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e);
            }
        }
    }
}

