/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions.support;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import org.apache.log4j.Logger;
import org.genemania.engine.Constants;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.MatrixUtils;
import org.genemania.engine.core.data.CoAnnotationSet;
import org.genemania.engine.core.data.DatasetInfo;
import org.genemania.engine.core.data.KtK;
import org.genemania.engine.core.data.KtT;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.engine.core.integration.gram.BasicGramBuilder;
import org.genemania.engine.exception.CancellationException;
import org.genemania.engine.matricks.SymMatrix;
import org.genemania.exception.ApplicationException;
import org.genemania.util.ProgressReporter;

public class UserDataPrecomputer {
    private static Logger logger = Logger.getLogger(UserDataPrecomputer.class);
    String namespace;
    int organismId;
    DataCache cache;
    KtK userKtK;
    KtT[] userKtT = new KtT[Constants.goBranches.length];
    NetworkIds networkIds;
    DatasetInfo info;
    ProgressReporter progress;
    boolean hasPrecomputedData;

    public UserDataPrecomputer(String namespace, int organismId, DataCache cache, ProgressReporter progress) {
        this.namespace = namespace;
        this.organismId = organismId;
        this.cache = cache;
        this.progress = progress;
    }

    protected void checkNetwork(long id) throws ApplicationException {
        if (id >= 0L) {
            throw new ApplicationException("not a valid id for a user network: " + id);
        }
        if (this.networkIds.containsId(id)) {
            throw new ApplicationException("a network with the id " + id + " already exists in the users data set");
        }
    }

    public void load() throws ApplicationException {
        try {
            this.info = this.cache.getDatasetInfo(this.organismId);
            this.networkIds = this.cache.getNetworkIds(this.namespace, this.organismId);
            this.hasPrecomputedData = this.loadPrecomputed();
        }
        catch (ApplicationException e) {
            this.loadInit();
        }
    }

    private boolean loadPrecomputed() {
        boolean exists = false;
        try {
            this.userKtK = this.cache.getKtK(this.namespace, this.organismId, Constants.DataFileNames.KtK_BASIC.getCode());
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                this.userKtT[branch] = this.cache.getKtT(this.namespace, this.organismId, Constants.goBranches[branch]);
            }
            exists = true;
        }
        catch (ApplicationException e) {
            logger.debug((Object)"precomputed data structures don't appear to exist");
        }
        return exists;
    }

    public void loadInit() throws ApplicationException {
        NetworkIds coreNetworkIds = this.cache.getNetworkIds("CORE", this.organismId);
        this.networkIds = coreNetworkIds.copy(this.namespace);
        this.hasPrecomputedData = this.loadInitPrecomputed();
    }

    public boolean loadInitPrecomputed() {
        boolean exists = false;
        try {
            KtK coreUserKtK = this.cache.getKtK("CORE", this.organismId, Constants.DataFileNames.KtK_BASIC.getCode());
            this.userKtK = coreUserKtK.copy(this.namespace);
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                KtT coreUserKtT = this.cache.getKtT("CORE", this.organismId, Constants.goBranches[branch]);
                this.userKtT[branch] = coreUserKtT.copy(this.namespace);
            }
            exists = true;
        }
        catch (ApplicationException e) {
            logger.debug((Object)"precomputed data structures don't appear to exist");
        }
        return exists;
    }

    public void save() throws ApplicationException {
        this.cache.putNetworkIds(this.networkIds);
        if (this.hasPrecomputedData) {
            this.cache.putKtK(this.userKtK);
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                this.cache.putKtT(this.userKtT[branch]);
            }
        }
    }

    public void addNetwork(long networkId, SymMatrix m) throws ApplicationException {
        this.progress.setStatus("updating data structures");
        this.progress.setProgress(2);
        logger.debug((Object)"loading precomputed data structures");
        this.load();
        this.checkNetwork(networkId);
        this.networkIds.addNetwork(networkId);
        if (!this.hasPrecomputedData) {
            logger.debug((Object)"skipping precomputation");
        } else {
            logger.debug((Object)"updating KtK");
            this.reallocKtK();
            this.updateKtK(networkId, m);
            logger.debug((Object)"updating KtT");
            this.reallocKtT();
            this.updateKtT(networkId, m);
            logger.debug((Object)"writing updated precomputed data structures");
        }
        this.save();
    }

    public void reallocKtK() throws ApplicationException {
        if (this.userKtK == null) {
            throw new ApplicationException("no precomputed user data available");
        }
        DenseMatrix newKtK = MatrixUtils.copyLarger((Matrix)this.userKtK.getData(), 1, 1);
        this.userKtK.setData(newKtK);
    }

    void updateKtK(long networkId, SymMatrix networkData) throws ApplicationException {
        int index = this.networkIds.getIndexForId(networkId) + 1;
        double networkSum = networkData.elementSum();
        DenseMatrix userKtKData = this.userKtK.getData();
        userKtKData.set(index, 0, networkSum);
        userKtKData.set(0, index, networkSum);
        for (int i = 0; i < this.networkIds.getNetworkIds().length; ++i) {
            long otherNetworkId = this.networkIds.getIdForIndex(i);
            int otherIndex = i + 1;
            if (this.progress.isCanceled()) {
                throw new CancellationException();
            }
            logger.debug((Object)("computing product of user network " + networkId + " with network " + otherNetworkId));
            SymMatrix otherNetworkData = this.cache.getNetwork(this.namespace, this.organismId, otherNetworkId).getData();
            double val = networkData.elementMultiplySum(otherNetworkData);
            userKtKData.set(index, otherIndex, val);
            userKtKData.set(otherIndex, index, val);
        }
    }

    public void reallocKtT() throws ApplicationException {
        if (this.userKtT == null) {
            throw new ApplicationException("no precomputed data available");
        }
        for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
            DenseMatrix userKtTData = this.userKtT[branch].getData();
            userKtTData = MatrixUtils.copyLarger((Matrix)userKtTData, 1, 0);
            this.userKtT[branch].setData(userKtTData);
        }
    }

    public void updateKtT(long networkId, SymMatrix network) throws ApplicationException {
        int index = this.networkIds.getIndexForId(networkId) + 1;
        for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
            if (this.progress.isCanceled()) {
                throw new CancellationException();
            }
            CoAnnotationSet annoSet = this.cache.getCoAnnotationSet(this.organismId, Constants.goBranches[branch]);
            DenseMatrix KtTData = this.userKtT[branch].getData();
            SymMatrix coAnnotationMatrix = annoSet.GetCoAnnotationMatrix();
            int numberOfGenes = annoSet.GetCoAnnotationMatrix().numRows();
            double val = BasicGramBuilder.computeKttElement(numberOfGenes, network, coAnnotationMatrix, annoSet.GetBHalf(), annoSet.GetConstant());
            KtTData.set(index, 0, val);
        }
    }

    public void removeNetwork(int networkId) throws ApplicationException {
        this.load();
        if (!this.networkIds.containsId(networkId)) {
            throw new ApplicationException("user does not have network: " + networkId);
        }
        int index = this.networkIds.getIndexForId(networkId);
        if (this.hasPrecomputedData) {
            for (int branch = 0; branch < Constants.goBranches.length; ++branch) {
                this.userKtT[branch].removeNetworkAtIndex(index + 1);
            }
            this.userKtK.removeNetworkAtIndex(index + 1);
        }
        this.networkIds.removeNetwork(networkId);
        this.save();
    }

    public void removeOrganism() throws ApplicationException {
        this.cache.removeOrganism(this.namespace, this.organismId);
    }
}

