/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import org.apache.log4j.Logger;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineResponseDto;
import org.genemania.engine.actions.support.UserNetworkProcessor;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.utils.Logging;
import org.genemania.engine.exception.CancellationException;
import org.genemania.exception.ApplicationException;

public class UploadNetwork {
    private static Logger logger = Logger.getLogger(UploadNetwork.class);
    private DataCache cache;
    UploadNetworkEngineRequestDto request;
    private long requestStartTimeMillis;
    private long requestEndTimeMillis;

    public UploadNetwork(DataCache cache, UploadNetworkEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public UploadNetworkEngineResponseDto process() throws ApplicationException {
        try {
            this.requestStartTimeMillis = System.currentTimeMillis();
            this.request.getProgressReporter().setMaximumProgress(3);
            this.request.getProgressReporter().setProgress(0);
            this.request.getProgressReporter().setStatus("starting");
            UserNetworkProcessor processor = new UserNetworkProcessor(this.cache, this.cache.getCacheDir());
            UploadNetworkEngineResponseDto response = processor.process(this.request);
            this.request.getProgressReporter().setProgress(3);
            this.request.getProgressReporter().setStatus("done");
            this.requestEndTimeMillis = System.currentTimeMillis();
            logger.info((Object)("completed processing uploadNetwork request, duration = " + Logging.duration(this.requestStartTimeMillis, this.requestEndTimeMillis)));
            return response;
        }
        catch (CancellationException e) {
            logger.info((Object)"upload network request was cancelled");
            return null;
        }
    }
}

