/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine.actions;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.genemania.dto.ListNetworksEngineRequestDto;
import org.genemania.dto.ListNetworksEngineResponseDto;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.exception.ApplicationException;

public class ListNetworks {
    private static Logger logger = Logger.getLogger(ListNetworks.class);
    DataCache cache;
    ListNetworksEngineRequestDto request;

    public ListNetworks(DataCache cache, ListNetworksEngineRequestDto request) {
        this.cache = cache;
        this.request = request;
    }

    public ListNetworksEngineResponseDto process() throws ApplicationException {
        if (this.request.getNamespace() == null) {
            throw new ApplicationException("no namespace given");
        }
        if (this.request.getOrganismId() == 0L) {
            throw new ApplicationException("no organism id specified, but don't know how to list all organisms. yet.");
        }
        NetworkIds networkIds = this.cache.getNetworkIds(this.request.getNamespace(), this.request.getOrganismId());
        ArrayList<Long> ids = new ArrayList<Long>();
        for (long id : networkIds.getNetworkIds()) {
            if (id >= 0L) continue;
            ids.add(id);
        }
        ListNetworksEngineResponseDto response = new ListNetworksEngineResponseDto();
        response.setNetworkIds(ids);
        return response;
    }
}

