/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine;

import org.apache.log4j.Logger;
import org.genemania.dto.AddAttributeGroupEngineRequestDto;
import org.genemania.dto.AddAttributeGroupEngineResponseDto;
import org.genemania.dto.AddEnrichmentAttributesEngineRequestDto;
import org.genemania.dto.AddEnrichmentAttributesEngineResponseDto;
import org.genemania.dto.AddOrganismEngineRequestDto;
import org.genemania.dto.AddOrganismEngineResponseDto;
import org.genemania.dto.EnrichmentEngineRequestDto;
import org.genemania.dto.EnrichmentEngineResponseDto;
import org.genemania.dto.ListAttributeGroupsEngineRequestDto;
import org.genemania.dto.ListAttributeGroupsEngineResponseDto;
import org.genemania.dto.ListNetworksEngineRequestDto;
import org.genemania.dto.ListNetworksEngineResponseDto;
import org.genemania.dto.NetworkCombinationRequestDto;
import org.genemania.dto.NetworkCombinationResponseDto;
import org.genemania.dto.RelatedGenesEngineRequestDto;
import org.genemania.dto.RelatedGenesEngineResponseDto;
import org.genemania.dto.RemoveAttributeGroupEngineRequestDto;
import org.genemania.dto.RemoveAttributeGroupEngineResponseDto;
import org.genemania.dto.RemoveNetworkEngineRequestDto;
import org.genemania.dto.RemoveNetworkEngineResponseDto;
import org.genemania.dto.UploadNetworkEngineRequestDto;
import org.genemania.dto.UploadNetworkEngineResponseDto;
import org.genemania.engine.IMania;
import org.genemania.engine.actions.AddAttributeGroup;
import org.genemania.engine.actions.AddEnrichmentAttributes;
import org.genemania.engine.actions.AddOrganism;
import org.genemania.engine.actions.CombineNetworks;
import org.genemania.engine.actions.ComputeEnrichment;
import org.genemania.engine.actions.FindRelated;
import org.genemania.engine.actions.ListAttributeGroups;
import org.genemania.engine.actions.ListNetworks;
import org.genemania.engine.actions.RemoveAttributeGroup;
import org.genemania.engine.actions.RemoveNetworks;
import org.genemania.engine.actions.UploadNetwork;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.config.Config;
import org.genemania.exception.ApplicationException;

public class Mania2
implements IMania {
    private static Logger logger = Logger.getLogger(Mania2.class);
    private DataCache cache;

    public Mania2(DataCache cache) {
        this.cache = cache;
    }

    @Override
    public RelatedGenesEngineResponseDto findRelated(RelatedGenesEngineRequestDto request) throws ApplicationException {
        FindRelated findRelated = new FindRelated(this.cache, request);
        return findRelated.process();
    }

    @Override
    public ListNetworksEngineResponseDto listNetworks(ListNetworksEngineRequestDto request) throws ApplicationException {
        ListNetworks listNetworks = new ListNetworks(this.cache, request);
        return listNetworks.process();
    }

    @Override
    public UploadNetworkEngineResponseDto uploadNetwork(UploadNetworkEngineRequestDto request) throws ApplicationException {
        UploadNetwork uploadNetwork = new UploadNetwork(this.cache, request);
        return uploadNetwork.process();
    }

    @Override
    public RemoveNetworkEngineResponseDto removeUserNetworks(RemoveNetworkEngineRequestDto request) throws ApplicationException {
        RemoveNetworks removeNetworks = new RemoveNetworks(this.cache, request);
        return removeNetworks.process();
    }

    @Override
    public void clearMemCache() {
        logger.warn((Object)"mem cache clearing not implemented");
    }

    @Override
    public String getVersion() {
        return Config.instance().getVersion();
    }

    @Override
    public EnrichmentEngineResponseDto computeEnrichment(EnrichmentEngineRequestDto request) throws ApplicationException {
        ComputeEnrichment computeEnrichment = new ComputeEnrichment(this.cache, request);
        return computeEnrichment.process();
    }

    @Override
    public AddOrganismEngineResponseDto addOrganism(AddOrganismEngineRequestDto request) throws ApplicationException {
        AddOrganism addOrganism = new AddOrganism(this.cache, request);
        return addOrganism.process();
    }

    @Override
    public AddAttributeGroupEngineResponseDto addAttributeGroup(AddAttributeGroupEngineRequestDto request) throws ApplicationException {
        AddAttributeGroup addAttributeGroup = new AddAttributeGroup(this.cache, request);
        return addAttributeGroup.process();
    }

    @Override
    public ListAttributeGroupsEngineResponseDto listAttributes(ListAttributeGroupsEngineRequestDto request) throws ApplicationException {
        ListAttributeGroups listAttributeGroups = new ListAttributeGroups(this.cache, request);
        return listAttributeGroups.process();
    }

    @Override
    public RemoveAttributeGroupEngineResponseDto removeAttributeGroup(RemoveAttributeGroupEngineRequestDto request) throws ApplicationException {
        RemoveAttributeGroup removeAttributeGroup = new RemoveAttributeGroup(this.cache, request);
        return removeAttributeGroup.process();
    }

    @Override
    public AddEnrichmentAttributesEngineResponseDto addOntology(AddEnrichmentAttributesEngineRequestDto request) throws ApplicationException {
        AddEnrichmentAttributes action = new AddEnrichmentAttributes(this.cache, request);
        return action.process();
    }

    @Override
    public NetworkCombinationResponseDto getCombinedNetwork(NetworkCombinationRequestDto request) throws ApplicationException {
        CombineNetworks action = new CombineNetworks(this.cache, request);
        return action.process();
    }
}

