/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.engine;

import org.genemania.exception.ApplicationException;

public class Constants {
    public static final String ENGINE_PROPERTY_FILE = "Engine.properties";
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final boolean DEFAULT_IS_REGULARIZATION_ENABLED = false;
    public static final double DEFAULT_REGULARIZATION_CONSTANT = 1.0;
    public static final boolean DEFAULT_NORMALIZE_NETWORK_WEIGHTS_ENABLED = true;
    public static final boolean DEFAULT_COMBINED_NETWORK_NORMALIZATION_ENABLED = false;
    public static final int DEFAULT_ATTRIBUTE_ENRICHMENT_MAX_SIZE = 100;
    public static final double DISCRIMINANT_THRESHOLD = 0.0;
    public static final int DEFAULT_AUTO_SELECT_MIN_GENE_THRESHOLD = 5;
    public static final double EXCLUDED_ROW_VALUE = -2.0;
    public static final String[] goBranches = new String[]{"BP", "CC", "MF"};
    public static final String ALL_ONTOLOGY = "ALL";
    public static final CombiningMethod[] combiningMethodForBranch = new CombiningMethod[]{CombiningMethod.BP, CombiningMethod.CC, CombiningMethod.MF};
    public static final int PROGRESS_START = 0;
    public static final String PROGRESS_START_MESSAGE = "starting";
    public static final int PROGRESS_WEIGHTING = 1;
    public static final String PROGRESS_WEIGHTING_MESSAGE = "computing network weights";
    public static final int PROGRESS_COMBINING = 2;
    public static final String PROGRESS_COMBINING_MESSAGE = "building combined network";
    public static final int PROGRESS_SCORING = 3;
    public static final String PROGRESS_SCORING_MESSAGE = "computing gene scores";
    public static final int PROGRESS_OUTPUTS = 4;
    public static final String PROGRESS_OUTPUTS_MESSAGE = "preparing outputs";
    public static final int PROGRESS_COMPLETE = 5;
    public static final String PROGRESS_COMPLETE_MESSAGE = "done";
    public static final int PROGRESS_UPLOAD_START = 0;
    public static final String PROGRESS_UPLOAD_START_MESSAGE = "starting";
    public static final int PROGRESS_UPLOAD_PROCESSING = 1;
    public static final String PROGRESS_UPLOAD_PROCESSING_MESSAGE = "processing network";
    public static final int PROGRESS_UPLOAD_PRECOMPUTING = 2;
    public static final String PROGRESS_UPLOAD_PRECOMPUTING_MESSAGE = "updating data structures";
    public static final int PROGRESS_UPLOAD_COMPLETE = 3;
    public static final String PROGRESS_UPLOAD_COMPLETE_MESSAGE = "done";

    public static int getIndexForGoBranch(String branch) throws ApplicationException {
        int index;
        if (branch.equalsIgnoreCase("BP")) {
            index = 0;
        } else if (branch.equalsIgnoreCase("CC")) {
            index = 1;
        } else if (branch.equals("MF")) {
            index = 2;
        } else {
            throw new ApplicationException("unexpected branch name: " + branch);
        }
        if (!goBranches[index].equalsIgnoreCase(branch)) {
            throw new ApplicationException("inconsistent branch numbering");
        }
        return index;
    }

    public static CombiningMethod getMethodForBranch(String branch) throws ApplicationException {
        int index = Constants.getIndexForGoBranch(branch);
        return combiningMethodForBranch[index];
    }

    public static CombiningMethod getCombiningMethod(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.equalsIgnoreCase("average") || methodName.equalsIgnoreCase("equal")) {
            return CombiningMethod.AVERAGE;
        }
        if (methodName.equalsIgnoreCase("automatic") || methodName.equalsIgnoreCase("auto") || methodName.equalsIgnoreCase("smart")) {
            return CombiningMethod.AUTOMATIC;
        }
        if (methodName.equalsIgnoreCase("automatic_relevance") || methodName.equalsIgnoreCase("Simutaneous_Weighting") || methodName.equalsIgnoreCase("automatic_relevant")) {
            return CombiningMethod.AUTOMATIC_RELEVANCE;
        }
        if (methodName.equalsIgnoreCase("average by categories") || methodName.equalsIgnoreCase("categories") || methodName.equalsIgnoreCase("average category") || methodName.equalsIgnoreCase("average_category")) {
            return CombiningMethod.AVERAGE_CATEGORY;
        }
        if (methodName.equalsIgnoreCase("BP") || methodName.equalsIgnoreCase("Biological_Processes")) {
            return CombiningMethod.BP;
        }
        if (methodName.equalsIgnoreCase("CC") || methodName.equalsIgnoreCase("Cellular_Components")) {
            return CombiningMethod.CC;
        }
        if (methodName.equalsIgnoreCase("MF") || methodName.equalsIgnoreCase("Molecular_Functions")) {
            return CombiningMethod.MF;
        }
        if (methodName.equalsIgnoreCase("automatic_fast")) {
            return CombiningMethod.AUTOMATIC_FAST;
        }
        return null;
    }

    public static CombiningMethod convertCombiningMethod(org.genemania.type.CombiningMethod combiningMethod, int size) throws ApplicationException {
        if (combiningMethod == org.genemania.type.CombiningMethod.AUTOMATIC) {
            return CombiningMethod.AUTOMATIC;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.AUTOMATIC_RELEVANCE) {
            return CombiningMethod.AUTOMATIC_RELEVANCE;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.AVERAGE) {
            return CombiningMethod.AVERAGE;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.AVERAGE_CATEGORY) {
            return CombiningMethod.AVERAGE_CATEGORY;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.BP) {
            return CombiningMethod.BP;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.CC) {
            return CombiningMethod.CC;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.MF) {
            return CombiningMethod.MF;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.AUTOMATIC_FAST) {
            return CombiningMethod.AUTOMATIC_FAST;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.AUTOMATIC_SELECT) {
            if (size <= 5) {
                return CombiningMethod.BP;
            }
            return CombiningMethod.AUTOMATIC;
        }
        if (combiningMethod == org.genemania.type.CombiningMethod.UNKNOWN) {
            throw new ApplicationException("unkown combining method");
        }
        throw new ApplicationException("unexpected combining method");
    }

    public static org.genemania.type.CombiningMethod convertCombiningMethod(CombiningMethod combiningMethod) throws ApplicationException {
        if (combiningMethod == CombiningMethod.AUTOMATIC) {
            return org.genemania.type.CombiningMethod.AUTOMATIC;
        }
        if (combiningMethod == CombiningMethod.AUTOMATIC_RELEVANCE) {
            return org.genemania.type.CombiningMethod.AUTOMATIC_RELEVANCE;
        }
        if (combiningMethod == CombiningMethod.AVERAGE) {
            return org.genemania.type.CombiningMethod.AVERAGE;
        }
        if (combiningMethod == CombiningMethod.AVERAGE_CATEGORY) {
            return org.genemania.type.CombiningMethod.AVERAGE_CATEGORY;
        }
        if (combiningMethod == CombiningMethod.BP) {
            return org.genemania.type.CombiningMethod.BP;
        }
        if (combiningMethod == CombiningMethod.CC) {
            return org.genemania.type.CombiningMethod.CC;
        }
        if (combiningMethod == CombiningMethod.MF) {
            return org.genemania.type.CombiningMethod.MF;
        }
        if (combiningMethod == CombiningMethod.AUTOMATIC_FAST) {
            return org.genemania.type.CombiningMethod.AUTOMATIC_FAST;
        }
        throw new ApplicationException("unexpected combining method");
    }

    public static ScoringMethod convertScoringMethod(org.genemania.type.ScoringMethod scoringMethod) throws ApplicationException {
        if (scoringMethod == org.genemania.type.ScoringMethod.DISCRIMINANT) {
            return ScoringMethod.DISCRIMINANT;
        }
        if (scoringMethod == org.genemania.type.ScoringMethod.CONTEXT) {
            return ScoringMethod.CONTEXT;
        }
        if (scoringMethod == org.genemania.type.ScoringMethod.ZSCORE) {
            return ScoringMethod.ZSCORE;
        }
        throw new ApplicationException("unexpected combining method");
    }

    public static enum DataFileNames {
        KtK("KtK"),
        KtK_BASIC("KtK_BASIC");

        private String code;

        private DataFileNames(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum FastWeightCache {

    }

    public static enum GOCache {
        Data_Matrix,
        GOIndexMap,
        combinedDataMatrix,
        childSiblingMap;

    }

    public static enum ScoringMethod {
        DISCRIMINANT,
        CONTEXT,
        ZSCORE;

    }

    public static enum CombiningMethod {
        AVERAGE(false),
        AUTOMATIC(true),
        AUTOMATIC_FAST(true),
        AVERAGE_CATEGORY(false),
        BP(false),
        CC(false),
        MF(false),
        AUTOMATIC_RELEVANCE(false);

        private final boolean querySpecific;

        private CombiningMethod(boolean querySpecific) {
            this.querySpecific = querySpecific;
        }

        public boolean isQuerySpecific() {
            return this.querySpecific;
        }
    }

    public static enum NetworkType {
        BIAS("BIAS"),
        SPARSE_MATRIX("SPARSE_MATRIX"),
        ATTRIBUTE_VECTOR("ATTRIBUTE_VECTOR");

        private String code;

        private NetworkType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

