/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Calculator
extends JPanel
implements ActionListener {
    private double _result;
    private StringBuffer _op1 = new StringBuffer();
    private StringBuffer _op2 = new StringBuffer();
    private int _operator = -1;
    private String _displayText;
    private boolean _overflow = false;
    private boolean _negationOp1 = true;
    private boolean _backspaceOp1 = false;
    private boolean _backspaceOp2 = false;
    private boolean _clearOperatorPending = false;
    private boolean _isFakedEqualPressed = false;
    private boolean _resultCalculated = false;
    public static final int OPERATOR_NONE = -1;
    public static final int OPERATOR_ADD = 0;
    public static final int OPERATOR_MINUS = 1;
    public static final int OPERATOR_MULTIPLY = 2;
    public static final int OPERATOR_DIVIDE = 3;
    private AbstractButton _addButton;
    private AbstractButton _minusButton;
    private AbstractButton _multiplyButton;
    private AbstractButton _divideButton;
    private AbstractButton _pointButton;
    private AbstractButton _equalButton;
    private AbstractButton _backspaceButton;
    private AbstractButton _clearButton;
    private AbstractButton _negativeButton;
    private AbstractButton[] _numberButtons;
    private char _actualCharPoint;
    private NumberFormat _displayFormat = NumberFormat.getNumberInstance();
    public static final char CHAR_CLEAR = 'c';
    public static final char CHAR_POINT = '.';
    public static final char CHAR_ADD = '+';
    public static final char CHAR_MINUS = '-';
    public static final char CHAR_MULTIPLY = '*';
    public static final char CHAR_DIVIDE = '/';
    public static final char CHAR_EQUAL = '=';
    public static final char CHAR_NEGATIVE = '!';
    public static final char CHAR_BACKSPACE = '<';
    public static final char CHAR_0 = '0';
    public static final char CHAR_1 = '1';
    public static final char CHAR_2 = '2';
    public static final char CHAR_3 = '3';
    public static final char CHAR_4 = '4';
    public static final char CHAR_5 = '5';
    public static final char CHAR_6 = '6';
    public static final char CHAR_7 = '7';
    public static final char CHAR_8 = '8';
    public static final char CHAR_9 = '9';
    public static final String PROPERTY_DISPLAY_TEXT = "displayText";
    public static final String PROPERTY_OPERATOR = "operator";
    private int _buttonWidth = 24;
    private int _buttonHeight = 24;
    private int _buttonGap = 2;

    public Calculator() {
        this.configureNumberFormat();
        this.initComponents();
        this.registerKeyboardActions(this, 1);
    }

    public void setLocale(Locale l) {
        this.unregisterKeyboardActions(this);
        super.setLocale(l);
        this._op1 = new StringBuffer();
        this._op2 = new StringBuffer();
        this._displayFormat = NumberFormat.getNumberInstance(this.getLocale());
        this.configureNumberFormat();
        this._actualCharPoint = this.getDisplayFormat().format(2.01).charAt(1);
        this._pointButton.setText("" + this._actualCharPoint);
        this.registerKeyboardActions(this, 1);
    }

    protected void configureNumberFormat() {
        this._displayFormat.setMaximumFractionDigits(20);
        this._displayFormat.setMinimumFractionDigits(0);
        this._displayFormat.setGroupingUsed(false);
    }

    public static boolean isValidKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return (keyEvent.getModifiers() & 0xFFFFFFFE) != 0 || Character.isDigit(c) || Calculator.isOperator(keyEvent) || Calculator.isEnterOrEqual(keyEvent) || c == '.' || c == ',' || c == 'c' || Character.toLowerCase(c) == 'c' || c == '\u001b' || c == '\b';
    }

    public static boolean isOperator(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    public static boolean isEnterOrEqual(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return c == '\n' || c == '=';
    }

    public void registerKeyboardActions(JComponent component, int condition) {
        boolean isCellEditor = this.isCellEditor();
        component.registerKeyboardAction(this, "+", KeyStroke.getKeyStroke('+'), condition);
        component.registerKeyboardAction(this, "-", KeyStroke.getKeyStroke('-'), condition);
        component.registerKeyboardAction(this, "*", KeyStroke.getKeyStroke('*'), condition);
        component.registerKeyboardAction(this, "/", KeyStroke.getKeyStroke('/'), condition);
        component.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke('='), condition);
        if (!isCellEditor) {
            component.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke(10, 0), condition);
        }
        component.registerKeyboardAction(this, "0", KeyStroke.getKeyStroke('0'), condition);
        component.registerKeyboardAction(this, "1", KeyStroke.getKeyStroke('1'), condition);
        component.registerKeyboardAction(this, "2", KeyStroke.getKeyStroke('2'), condition);
        component.registerKeyboardAction(this, "3", KeyStroke.getKeyStroke('3'), condition);
        component.registerKeyboardAction(this, "4", KeyStroke.getKeyStroke('4'), condition);
        component.registerKeyboardAction(this, "5", KeyStroke.getKeyStroke('5'), condition);
        component.registerKeyboardAction(this, "6", KeyStroke.getKeyStroke('6'), condition);
        component.registerKeyboardAction(this, "7", KeyStroke.getKeyStroke('7'), condition);
        component.registerKeyboardAction(this, "8", KeyStroke.getKeyStroke('8'), condition);
        component.registerKeyboardAction(this, "9", KeyStroke.getKeyStroke('9'), condition);
        component.registerKeyboardAction(this, "" + this._actualCharPoint, KeyStroke.getKeyStroke(this._actualCharPoint), condition);
        component.registerKeyboardAction(this, "<", KeyStroke.getKeyStroke(8, 0), condition);
        if (!isCellEditor) {
            component.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), condition);
        }
        if (!isCellEditor) {
            component.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), 1);
        }
        component.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toUpperCase('c')), condition);
        component.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toLowerCase('c')), condition);
    }

    public void unregisterKeyboardActions(JComponent component) {
        boolean isCellEditor = this.isCellEditor();
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('+'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('-'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('*'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('/'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('='));
        if (!isCellEditor) {
            component.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        }
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('0'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('1'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('2'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('3'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('4'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('5'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('6'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('7'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('8'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke('9'));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke(this._actualCharPoint));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        if (!isCellEditor) {
            component.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toUpperCase('c')));
        component.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toLowerCase('c')));
    }

    protected void initComponents() {
        this.setLayout(new CalculatorLayoutManager());
        this._addButton = this.createButton("+");
        this.add(this._addButton);
        this._minusButton = this.createButton("-");
        this.add(this._minusButton);
        this._multiplyButton = this.createButton("*");
        this.add(this._multiplyButton);
        this._divideButton = this.createButton("/");
        this.add(this._divideButton);
        this._numberButtons = new AbstractButton[10];
        for (int i = 0; i <= 9; ++i) {
            this._numberButtons[i] = this.createButton("" + i);
            this.add(this._numberButtons[i]);
        }
        this._actualCharPoint = this.getDisplayFormat().format(2.01).charAt(1);
        this._pointButton = this.createButton("" + this._actualCharPoint);
        this.add(this._pointButton);
        this._equalButton = this.createButton("=");
        this.add(this._equalButton);
        this._backspaceButton = this.createButton(null, new BackspaceIcon());
        this.add(this._backspaceButton);
        this._negativeButton = this.createButton(null, new ToggleNegativeIcon());
        this.add(this._negativeButton);
        this._clearButton = this.createButton("C");
        this.add(this._clearButton);
    }

    public boolean isResultCalculated() {
        return this._resultCalculated;
    }

    public void setResultCalculated(boolean resultCalculated) {
        this._resultCalculated = resultCalculated;
    }

    protected AbstractButton createButton(String text) {
        return this.createButton(text, null);
    }

    protected AbstractButton createButton(String text, Icon icon) {
        JideButton button = new JideButton(text, icon);
        button.setOpaque(true);
        button.setContentAreaFilled(true);
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        button.addActionListener(this);
        return button;
    }

    public boolean isOverflow() {
        return this._overflow;
    }

    public void setOverflow(boolean overflow) {
        this._overflow = overflow;
    }

    public void input(char c) {
        if ('c' == Character.toLowerCase(c) || 'c' == Character.toUpperCase(c)) {
            this.clear();
            return;
        }
        if (this._overflow) {
            this.beep();
            return;
        }
        if (Character.isDigit(c) || this._actualCharPoint == c) {
            if (this._clearOperatorPending) {
                this.setOperator(-1);
                this._op1.setLength(0);
                this._clearOperatorPending = false;
            }
            if (this.getOperator() == -1) {
                if (this._actualCharPoint != c || this._op1.indexOf("" + this._actualCharPoint) == -1) {
                    this._op1.append(c);
                    this._backspaceOp1 = true;
                    this._backspaceOp2 = false;
                    this.setDisplayText(this._op1.toString());
                } else {
                    this.beep();
                }
            } else if (this._actualCharPoint != c || this._op2.indexOf("" + this._actualCharPoint) == -1) {
                this._op2.append(c);
                this._backspaceOp2 = true;
                this._backspaceOp1 = false;
                this.setDisplayText(this._op2.toString());
            } else {
                this.beep();
            }
        } else {
            switch (c) {
                case '+': {
                    this.operatorPressed(0);
                    break;
                }
                case '-': {
                    this.operatorPressed(1);
                    break;
                }
                case '*': {
                    this.operatorPressed(2);
                    break;
                }
                case '/': {
                    this.operatorPressed(3);
                    break;
                }
                case '=': {
                    this.calculateResult(true);
                    this._clearOperatorPending = true;
                    break;
                }
                case '!': {
                    if (this._negationOp1) {
                        this.negativePressed(this._op1);
                        this.setDisplayText(this._op1.toString());
                        break;
                    }
                    this.negativePressed(this._op2);
                    this.setDisplayText(this._op2.toString());
                    break;
                }
                case '<': {
                    if (this._backspaceOp1) {
                        this.backspacePressed(this._op1);
                        this.setDisplayText(this._op1.toString());
                        break;
                    }
                    if (this._backspaceOp2) {
                        this.backspacePressed(this._op2);
                        this.setDisplayText(this._op2.toString());
                        break;
                    }
                    this.beep();
                }
            }
        }
    }

    private void operatorPressed(int operator) {
        if (this._op1.length() == 0) {
            this._op1.append("0");
        } else if (this.getOperator() == -1 || this._clearOperatorPending) {
            this._op2.setLength(0);
            this.calculateResult(false);
        } else {
            if (this._op2.length() == 0) {
                this.beep();
                return;
            }
            this._isFakedEqualPressed = false;
            this.calculateResult(true);
            this._op1.setLength(0);
            this._op1.append(this.getDisplayFormat().format((Object)this._result));
            this._op2.setLength(0);
        }
        this.setOperator(operator);
        this._negationOp1 = false;
        this._clearOperatorPending = false;
    }

    protected void beep() {
        PortingUtils.notifyUser();
    }

    private void negativePressed(StringBuffer buf) {
        if (buf.length() == 0) {
            return;
        }
        if (buf.charAt(0) == '-') {
            buf.deleteCharAt(0);
        } else {
            buf.insert(0, '-');
        }
    }

    private void backspacePressed(StringBuffer buf) {
        if (buf.length() == 0) {
            return;
        }
        buf.deleteCharAt(buf.length() - 1);
    }

    public void updateResult() {
        this._isFakedEqualPressed = false;
        this.calculateResult(true);
    }

    private void calculateResult(boolean equalPressed) {
        Double op2;
        Double op1;
        if (this.getOperator() == -1) {
            return;
        }
        if (this._op1.length() == 0) {
            this.beep();
            return;
        }
        if (equalPressed) {
            if (this._op2.length() == 0) {
                this._op2.append(this._op1);
            }
        } else if (this._op2.length() == 0) {
            return;
        }
        try {
            op1 = this.getDisplayFormat().parse(this._op1.toString()).doubleValue();
            op2 = this.getDisplayFormat().parse(this._op2.toString()).doubleValue();
        }
        catch (ParseException e) {
            op1 = 0.0;
            op2 = 0.0;
        }
        if (!this._isFakedEqualPressed) {
            try {
                switch (this.getOperator()) {
                    case 0: {
                        this._result = op1 + op2;
                        break;
                    }
                    case 1: {
                        this._result = op1 - op2;
                        break;
                    }
                    case 2: {
                        this._result = op1 * op2;
                        break;
                    }
                    case 3: {
                        if (op2 == 0.0) {
                            this._result = Double.NaN;
                            this._overflow = true;
                            break;
                        }
                        this._result = op1 / op2;
                    }
                }
            }
            catch (Exception e) {
                this._overflow = true;
            }
        }
        if (this._overflow) {
            this.setDisplayText("E");
        } else {
            this.setResultCalculated(true);
            this._op1.setLength(0);
            if (this._displayFormat != null) {
                String displayText = this._displayFormat.format(this._result);
                this.setDisplayText(displayText);
            } else {
                this.setDisplayText("" + this._result);
            }
            this._op1.append(this.getDisplayText());
            this._negationOp1 = true;
            this._backspaceOp1 = true;
            this._backspaceOp2 = false;
        }
    }

    private void clearOps() {
        this.setOperator(-1);
        this._op1.setLength(0);
        this._op2.setLength(0);
    }

    public void clear() {
        this.clearOps();
        this._overflow = false;
        this._clearOperatorPending = false;
        this.setDisplayText("0");
    }

    public double getResult() {
        return this._result;
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public void setDisplayText(String displayText) {
        String old = this._displayText;
        this._displayText = displayText;
        this.firePropertyChange(PROPERTY_DISPLAY_TEXT, old, this._displayText);
    }

    public int getOperator() {
        return this._operator;
    }

    public void setOperator(int operator) {
        int old = this._operator;
        if (old != operator) {
            this._operator = operator;
            this.firePropertyChange(PROPERTY_OPERATOR, new Integer(old), new Integer(operator));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._addButton == source) {
            this.input('+');
        } else if (this._minusButton == source) {
            this.input('-');
        } else if (this._multiplyButton == source) {
            this.input('*');
        } else if (this._divideButton == source) {
            this.input('/');
        } else if (this._equalButton == source) {
            this._isFakedEqualPressed = e.getActionCommand() != null && e.getActionCommand().equals("Faked");
            this.input('=');
        } else if (this._pointButton == source) {
            this.input(this._actualCharPoint);
        } else if (this._negativeButton == source) {
            this.input('!');
        } else if (this._backspaceButton == source) {
            this.input('<');
        } else if (this._clearButton == source) {
            this.input('c');
        } else {
            boolean found = false;
            for (int i = 0; i <= 9; ++i) {
                if (this._numberButtons[i] != source) continue;
                this.input(("" + i).charAt(0));
                found = true;
                break;
            }
            if (!found) {
                if (e.getActionCommand() != null && e.getActionCommand().length() > 0) {
                    this.fakePressButton(e.getActionCommand().charAt(0));
                } else {
                    this.fakePressButton('=');
                }
            }
        }
    }

    protected void fakePressButton(AbstractButton button) {
        this.actionPerformed(new ActionEvent(button, 0, null));
    }

    private void fakePressButton(char c) {
        if (c == this._actualCharPoint) {
            this.fakePressButton(this._pointButton);
            return;
        }
        switch (c) {
            case 'c': {
                this.fakePressButton(this._clearButton);
                break;
            }
            case '<': {
                this.fakePressButton(this._backspaceButton);
                break;
            }
            case '=': {
                this.fakePressButton(this._equalButton);
                break;
            }
            case '!': {
                this.fakePressButton(this._negativeButton);
                break;
            }
            case '+': {
                this.fakePressButton(this._addButton);
                break;
            }
            case '-': {
                this.fakePressButton(this._minusButton);
                break;
            }
            case '*': {
                this.fakePressButton(this._multiplyButton);
                break;
            }
            case '/': {
                this.fakePressButton(this._divideButton);
                break;
            }
            case '0': {
                this.fakePressButton(this._numberButtons[0]);
                break;
            }
            case '1': {
                this.fakePressButton(this._numberButtons[1]);
                break;
            }
            case '2': {
                this.fakePressButton(this._numberButtons[2]);
                break;
            }
            case '3': {
                this.fakePressButton(this._numberButtons[3]);
                break;
            }
            case '4': {
                this.fakePressButton(this._numberButtons[4]);
                break;
            }
            case '5': {
                this.fakePressButton(this._numberButtons[5]);
                break;
            }
            case '6': {
                this.fakePressButton(this._numberButtons[6]);
                break;
            }
            case '7': {
                this.fakePressButton(this._numberButtons[7]);
                break;
            }
            case '8': {
                this.fakePressButton(this._numberButtons[8]);
                break;
            }
            case '9': {
                this.fakePressButton(this._numberButtons[9]);
            }
        }
    }

    public NumberFormat getDisplayFormat() {
        return this._displayFormat;
    }

    public void setDisplayFormat(NumberFormat displayFormat) {
        this._displayFormat = displayFormat;
    }

    public void commit() {
        if (!this._clearOperatorPending) {
            this.actionPerformed(new ActionEvent(this._equalButton, 0, "Faked"));
        }
    }

    public int getButtonWidth() {
        return this._buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this._buttonWidth = buttonWidth;
    }

    public int getButtonHeight() {
        return this._buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this._buttonHeight = buttonHeight;
    }

    public int getButtonGap() {
        return this._buttonGap;
    }

    public void setButtonGap(int buttonGap) {
        this._buttonGap = buttonGap;
    }

    protected boolean isCellEditor() {
        return false;
    }

    public void setInitialValue(String value) {
        this._op1.setLength(0);
        this._op1.append(value);
        this._backspaceOp1 = true;
        this._backspaceOp2 = false;
        this.setDisplayText(this._op1.toString());
    }

    public static void main(String[] args) {
        Calculator calculator = new Calculator();
        calculator.input('1');
        calculator.input('0');
        calculator.input('*');
        calculator.input('2');
        calculator.input('4');
        calculator.input('=');
    }

    private class CalculatorLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(Calculator.this.getButtonWidth() * 4 + Calculator.this.getButtonGap() * 3, Calculator.this.getButtonHeight() * 5 + Calculator.this.getButtonGap() * 4);
        }

        public void layoutContainer(Container parent) {
            int x = 0;
            int y = 0;
            int w = Calculator.this.getButtonWidth();
            int h = Calculator.this.getButtonHeight();
            int gap = Calculator.this.getButtonGap();
            Calculator.this._numberButtons[7].setBounds(x, y, w, h);
            Calculator.this._numberButtons[8].setBounds(x += w + gap, y, w, h);
            Calculator.this._numberButtons[9].setBounds(x += w + gap, y, w, h);
            Calculator.this._divideButton.setBounds(x += w + gap, y, w, h);
            x = 0;
            Calculator.this._numberButtons[4].setBounds(x, y += h + gap, w, h);
            Calculator.this._numberButtons[5].setBounds(x += w + gap, y, w, h);
            Calculator.this._numberButtons[6].setBounds(x += w + gap, y, w, h);
            Calculator.this._multiplyButton.setBounds(x += w + gap, y, w, h);
            x = 0;
            Calculator.this._numberButtons[1].setBounds(x, y += h + gap, w, h);
            Calculator.this._numberButtons[2].setBounds(x += w + gap, y, w, h);
            Calculator.this._numberButtons[3].setBounds(x += w + gap, y, w, h);
            Calculator.this._minusButton.setBounds(x += w + gap, y, w, h);
            x = 0;
            Calculator.this._numberButtons[0].setBounds(x, y += h + gap, w, h);
            Calculator.this._pointButton.setBounds(x += w + gap, y, w, h);
            Calculator.this._negativeButton.setBounds(x += w + gap, y, w, h);
            Calculator.this._addButton.setBounds(x += w + gap, y, w, h);
            x = 0;
            Calculator.this._clearButton.setBounds(x, y += h + gap, w, h);
            Calculator.this._backspaceButton.setBounds(x += w + gap, y, w, h);
            Calculator.this._equalButton.setBounds(x += w + gap, y, w * 2 + gap, h);
        }
    }

    class ToggleNegativeIcon
    implements Icon {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color old = g.getColor();
            Object save = JideSwingUtilities.setupShapeAntialiasing(g);
            g.setColor(c.getForeground());
            g.drawLine(x, y + 2, x + 6, y + 2);
            g.drawLine(x, y + 7, x + 6, y + 7);
            g.drawLine(x + 3, y, x + 3, y + 5);
            g.setColor(old);
            JideSwingUtilities.restoreShapeAntialiasing(g, save);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    class BackspaceIcon
    implements Icon {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Object save = JideSwingUtilities.setupShapeAntialiasing(g);
            Color old = g.getColor();
            g.setColor(c.getForeground());
            g.drawLine(x, y + 3, x + 3, y);
            g.drawLine(x, y + 3, x + 3, y + 6);
            g.drawLine(x + 3, y + 3, x + 7, y + 3);
            g.setColor(old);
            JideSwingUtilities.restoreShapeAntialiasing(g, save);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }
}

