/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Random;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLock;

public class NativeFSLockFactory
extends FSLockFactory {
    private volatile boolean tested = false;

    private synchronized void acquireTestLock() {
        if (this.tested) {
            return;
        }
        this.tested = true;
        if (!this.lockDir.exists()) {
            if (!this.lockDir.mkdirs()) {
                throw new RuntimeException("Cannot create directory: " + this.lockDir.getAbsolutePath());
            }
        } else if (!this.lockDir.isDirectory()) {
            throw new RuntimeException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
        }
        String randomLockName = "lucene-" + ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^a..zA..Z0..9]+", "") + "-" + Long.toString(new Random().nextInt(), 36) + "-test.lock";
        Lock l = this.makeLock(randomLockName);
        try {
            l.obtain();
            l.release();
            File lockFile = new File(this.lockDir, randomLockName);
            if (lockFile.exists()) {
                lockFile.deleteOnExit();
            }
        }
        catch (IOException e) {
            RuntimeException e2 = new RuntimeException("Failed to acquire random test lock; please verify filesystem for lock directory '" + this.lockDir + "' supports locking");
            e2.initCause(e);
            throw e2;
        }
    }

    public NativeFSLockFactory() throws IOException {
        this((File)null);
    }

    public NativeFSLockFactory(String lockDirName) throws IOException {
        this(new File(lockDirName));
    }

    public NativeFSLockFactory(File lockDir) throws IOException {
        this.setLockDir(lockDir);
    }

    public synchronized Lock makeLock(String lockName) {
        this.acquireTestLock();
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        return new NativeFSLock(this.lockDir, lockName);
    }

    public void clearLock(String lockName) throws IOException {
        if (this.lockDir.exists()) {
            File lockFile;
            if (this.lockPrefix != null) {
                lockName = this.lockPrefix + "-" + lockName;
            }
            if ((lockFile = new File(this.lockDir, lockName)).exists() && !lockFile.delete()) {
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

