/*
 * Decompiled with CFR 0.152.
 */
package jannovar.exome;

import jannovar.annotation.Annotation;
import jannovar.annotation.AnnotationList;
import jannovar.common.Constants;
import jannovar.common.Genotype;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import jannovar.genotype.GenotypeCall;
import jannovar.reference.Chromosome;
import java.util.ArrayList;

public class Variant
implements Comparable<Variant>,
Constants {
    private byte chromosome;
    private int position;
    private String ref;
    private String alt;
    private GenotypeCall genotype = null;
    private float Phred;
    private AnnotationList annotList = null;

    public Variant(byte c, int p, String r, String alternate, GenotypeCall gtype, float qual) {
        this.chromosome = c;
        this.position = p;
        this.ref = r;
        this.alt = alternate;
        this.genotype = gtype;
        this.Phred = qual;
    }

    public void annotate(Chromosome c) throws AnnotationException {
        this.annotList = c.getAnnotationList(this.position, this.ref, this.alt);
    }

    public void setChromosome(byte chr) {
        this.chromosome = chr;
    }

    public void setPosition(int p) {
        this.position = p;
    }

    public void setRef(String s) {
        this.ref = s;
    }

    public void setGenotype(GenotypeCall gtype) {
        this.genotype = gtype;
    }

    public void setVar(String s) {
        this.alt = s;
    }

    public void setAnnotation(AnnotationList a) {
        this.annotList = a;
    }

    public boolean affectsMultipleGenes() {
        return this.annotList.hasMultipleGeneSymbols();
    }

    public int get_position() {
        return this.position;
    }

    public String get_ref() {
        return this.ref;
    }

    public String get_alt() {
        return this.alt;
    }

    public String getGeneSymbol() {
        if (this.annotList != null) {
            return this.annotList.getGeneSymbol();
        }
        return ".";
    }

    public int getEntrezGeneID() {
        return this.annotList.getEntrezGeneID();
    }

    public boolean is_missense_variant() {
        if (this.annotList == null) {
            return false;
        }
        return this.annotList.getVariantType() == VariantType.MISSENSE;
    }

    public boolean isSynonymousVariant() {
        if (this.annotList == null) {
            return false;
        }
        return this.annotList.getVariantType() == VariantType.SYNONYMOUS;
    }

    public boolean isTransition() {
        if (!this.is_single_nucleotide_variant()) {
            return false;
        }
        if (this.ref.equals("A") && this.alt.equals("G")) {
            return true;
        }
        if (this.ref.equals("G") && this.alt.equals("A")) {
            return true;
        }
        if (this.ref.equals("C") && this.alt.equals("T")) {
            return true;
        }
        return this.ref.equals("T") && this.alt.equals("C");
    }

    public boolean isTransversion() {
        if (!this.is_single_nucleotide_variant()) {
            return false;
        }
        if (this.ref.equals("A") && this.alt.equals("G")) {
            return false;
        }
        if (this.ref.equals("G") && this.alt.equals("A")) {
            return false;
        }
        if (this.ref.equals("C") && this.alt.equals("T")) {
            return false;
        }
        return !this.ref.equals("T") || !this.alt.equals("C");
    }

    public boolean is_single_nucleotide_variant() {
        return this.ref.length() == 1 && this.alt.length() == 1;
    }

    public int get_chromosome() {
        return this.chromosome;
    }

    public byte getChromosomeAsByte() {
        return this.chromosome;
    }

    public String get_chromosome_as_string() {
        if (this.chromosome == 23) {
            return "chrX";
        }
        if (this.chromosome == 24) {
            return "chrY";
        }
        if (this.chromosome == 25) {
            return "chrM";
        }
        return String.format("chr%d", this.chromosome);
    }

    public boolean is_X_chromosomal() {
        return this.chromosome == 23;
    }

    public boolean is_Y_chromosomal() {
        return this.chromosome == 24;
    }

    public boolean is_mitochondrial() {
        return this.chromosome == 25;
    }

    public float getVariantPhredScore() {
        return this.Phred;
    }

    public float getVariantGenotypeQualityIndividualN(int n) {
        return this.genotype.getQualityInIndividualN(n);
    }

    public int getVariantReadDepth() {
        return this.genotype.getReadDepthInIndividualN(0);
    }

    public int getVariantReadDepthIndividualN(int n) {
        return this.genotype.getReadDepthInIndividualN(n);
    }

    public boolean isHomozygousAlt() {
        return this.genotype.isHomozygousAltInIndividualN(0);
    }

    public boolean isHomozygousAltInIndividualN(int n) {
        return this.genotype.isHomozygousAltInIndividualN(n);
    }

    public boolean isHeterozygous() {
        return this.genotype.isHeterozygousInIndividualN(0);
    }

    public boolean isHeterozygousInIndividualN(int n) {
        return this.genotype.isHeterozygousInIndividualN(n);
    }

    public boolean isOffExomeTarget() {
        VariantType vt = this.getVariantTypeConstant();
        switch (vt) {
            case INTRONIC: 
            case ncRNA_INTRONIC: 
            case UPSTREAM: 
            case DOWNSTREAM: 
            case INTERGENIC: {
                return true;
            }
        }
        return false;
    }

    public boolean isMissingInIndividualN(int n) {
        return this.genotype.isMissingInIndividualN(n);
    }

    public GenotypeCall getGenotype() {
        return this.genotype;
    }

    public Genotype getGenotypeInIndividualN(int n) {
        return this.genotype.getGenotypeInIndividualN(n);
    }

    public String getGenotypeAsString() {
        return this.genotype.get_genotype_as_string();
    }

    public ArrayList<String> getGenotypeList() {
        return this.genotype.getGenotypeList();
    }

    public String get_position_as_string() {
        return Integer.toString(this.position);
    }

    public String get_chromosomal_variant() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.get_chromosome_as_string());
        sb.append(":g.");
        sb.append(this.position + this.ref + ">" + this.alt);
        return sb.toString();
    }

    public String getAnnotation() {
        try {
            if (this.annotList != null) {
                return this.annotList.getVariantAnnotation();
            }
            return ".";
        }
        catch (AnnotationException e) {
            return "error retrieving annotation";
        }
    }

    public String getRepresentativeAnnotation() {
        try {
            return this.annotList.getSingleTranscriptAnnotation();
        }
        catch (AnnotationException e) {
            return "error retrieving annotation";
        }
    }

    public ArrayList<String> getAnnotationList() {
        ArrayList<String> A = new ArrayList<String>();
        if (this.annotList == null) {
            A.add(".");
            return A;
        }
        ArrayList<Annotation> alist = this.annotList.getAnnotationList();
        for (Annotation ann : alist) {
            String s = ann.getVariantAnnotation();
            A.add(s);
        }
        return A;
    }

    public ArrayList<Annotation> getAnnotationObjectList() {
        return this.annotList.getAnnotationList();
    }

    public ArrayList<String> getAnnotationListWithGeneSymbol() {
        if (this.annotList == null) {
            ArrayList<String> A = new ArrayList<String>();
            A.add(".");
            return A;
        }
        ArrayList<Annotation> alist = this.annotList.getAnnotationList();
        ArrayList<String> A = new ArrayList<String>();
        for (Annotation ann : alist) {
            String s = ann.getVariantAnnotation();
            String sym = ann.getGeneSymbol();
            A.add(String.format("%s (%s)", s, sym));
        }
        return A;
    }

    public ArrayList<String> getAnnotationListWithAnnotationClass() {
        if (this.annotList == null) {
            ArrayList<String> A = new ArrayList<String>();
            A.add(".");
            return A;
        }
        ArrayList<Annotation> alist = this.annotList.getAnnotationList();
        ArrayList<String> A = new ArrayList<String>();
        for (Annotation ann : alist) {
            String s = ann.getVariantAnnotation();
            String typ = ann.getVariantTypeAsString();
            A.add(String.format("%s|%s", typ, s));
        }
        return A;
    }

    private String combineWithoutID(String[] s) {
        int k = s.length;
        if (k == 0) {
            return null;
        }
        if (k == 1) {
            return s[0];
        }
        StringBuilder out = new StringBuilder();
        out.append(s[1]);
        for (int x = 2; x < k; ++x) {
            out.append(":").append(s[x]);
        }
        return out.toString();
    }

    public ArrayList<String> getTranscriptAnnotations() {
        ArrayList<String> A = new ArrayList<String>();
        if (this.annotList == null) {
            A.add(".|.");
            return A;
        }
        boolean mult = this.affectsMultipleGenes();
        ArrayList<Annotation> alist = this.annotList.getAnnotationList();
        for (Annotation ann : alist) {
            String s = ann.getVariantAnnotation();
            String[] F = s.split(":");
            String id = F[0];
            s = this.combineWithoutID(F);
            if (ann.getVariantType() == VariantType.INTRONIC) {
                s = String.format("%s:intronic", s);
            }
            s = String.format("%s|%s", id, s);
            if (mult) {
                s = String.format("%s|%s", s, ann.getGeneSymbol());
            }
            A.add(s);
        }
        return A;
    }

    public Annotation getMostPathogenicAnnotation() throws AnnotationException {
        if (this.annotList.isEmpty()) {
            String e = String.format("[AnnotationList] Error: No Annotations found", new Object[0]);
            throw new AnnotationException(e);
        }
        return this.annotList.getAnnotationList().get(0);
    }

    public String getVariantType() {
        if (this.annotList != null) {
            return this.annotList.getVariantType().toString();
        }
        return "?";
    }

    public VariantType getVariantTypeConstant() {
        if (this.annotList != null) {
            return this.annotList.getVariantType();
        }
        return VariantType.ERROR;
    }

    public String getChromosomalVariant() {
        return String.format("%s:c.%d%s>%s", this.get_chromosome_as_string(), this.position, this.ref, this.alt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String chr = this.getChromosomalVariant();
        sb.append("\t" + chr);
        if (this.annotList != null) {
            sb.append("\t: " + this.getAnnotation() + "\n");
        } else {
            sb.append("\tcds mutation not initialized\n");
        }
        sb.append("\tGenotype: " + this.genotype.get_genotype_as_string() + "\n");
        sb.append("\tType: " + this.get_variant_type_as_string());
        return sb.toString();
    }

    public String get_variant_type_as_string() {
        if (this.annotList == null) {
            return "uninitialized";
        }
        return this.annotList.getVariantType().toString();
    }

    public int getDistanceFromExon() {
        return this.annotList.getDistanceFromExon();
    }

    @Override
    public int compareTo(Variant other) {
        if (other.chromosome > this.chromosome) {
            return -1;
        }
        if (other.chromosome < this.chromosome) {
            return 1;
        }
        if (other.position > this.position) {
            return -1;
        }
        if (other.position < this.position) {
            return 1;
        }
        if (!other.ref.equals(this.ref)) {
            return other.ref.compareTo(this.ref);
        }
        if (!other.alt.equals(this.alt)) {
            return other.alt.compareTo(this.alt);
        }
        return 0;
    }
}

