/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.reference.TranscriptModel;

public class UTRAnnotation {
    public static Annotation createUTR3Annotation(TranscriptModel trmdl, int rvarstart, String ref, String alt) {
        Annotation ann = Annotation.createEmptyAnnotation();
        ann.setVarType(VariantType.UTR3);
        ann.setGeneSymbol(trmdl.getGeneSymbol());
        int distance = rvarstart - trmdl.getRefCDSEnd();
        if (alt.equals("-")) {
            if (ref.length() == 1) {
                String annotation = String.format("%s:c.*%ddel%s", trmdl.getName(), distance, ref);
                ann.setVariantAnnotation(annotation);
            } else {
                int d2 = distance + ref.length() - 1;
                String annotation = String.format("%s:c.*%d_%ddel%s", trmdl.getName(), distance, d2, ref);
                ann.setVariantAnnotation(annotation);
            }
        } else if (ref.equals("-")) {
            int d2 = distance + 1;
            String annotation = String.format("%s:c.*%d_%dins%s", trmdl.getName(), distance, d2, alt);
            ann.setVariantAnnotation(annotation);
        } else {
            String annotation = String.format("%s:c.*%d%s>%s", trmdl.getName(), distance, ref, alt);
            ann.setVariantAnnotation(annotation);
        }
        ann.setGeneID(trmdl.getGeneID());
        return ann;
    }

    public static Annotation createUTR5Annotation(TranscriptModel trmdl, int rvarstart, String ref, String alt) {
        Annotation ann = Annotation.createEmptyAnnotation();
        ann.setVarType(VariantType.UTR5);
        ann.setGeneSymbol(trmdl.getGeneSymbol());
        int distance = trmdl.getRefCDSStart() - rvarstart;
        if (alt.equals("-")) {
            if (ref.length() == 1) {
                String annotation = String.format("%s:c.-%ddel%s", trmdl.getName(), distance, ref);
                ann.setVariantAnnotation(annotation);
            } else {
                int d2 = distance - ref.length() + 1;
                String annotation = String.format("%s:c.-%d_-%ddel%s", trmdl.getName(), distance, d2, ref);
                ann.setVariantAnnotation(annotation);
            }
        } else if (ref.equals("-")) {
            int d2 = distance - 1;
            String annotation = String.format("%s:c.-%d_-%dins%s", trmdl.getName(), distance, d2, alt);
            ann.setVariantAnnotation(annotation);
        } else {
            String annotation = String.format("%s:c.-%d%s>%s", trmdl.getName(), distance, ref, alt);
            ann.setVariantAnnotation(annotation);
        }
        ann.setGeneID(trmdl.getGeneID());
        return ann;
    }
}

