/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.selection.SelectionEvent;
import org.genemania.plugin.selection.SelectionListener;
import org.genemania.plugin.view.components.BaseDetailPanel;
import org.genemania.plugin.view.util.UiUtils;

public abstract class BaseInfoPanel<U, T extends BaseDetailPanel<U>>
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = 1L;
    public static final Color selectedBackground;
    public static final Color defaultBackground;
    protected static final Pattern sortPattern;
    protected List<T> dataModel;
    protected List<T> displayModel;
    protected List<SelectionListener<U>> selectionListeners;
    protected boolean isDescending;
    private GridBagLayout layout;
    protected final UiUtils uiUtils;

    public BaseInfoPanel(UiUtils uiUtils) {
        this.uiUtils = uiUtils;
        this.setOpaque(false);
        this.selectionListeners = new ArrayList<SelectionListener<U>>();
        this.dataModel = new ArrayList<T>();
        this.displayModel = new ArrayList<T>();
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.isDescending = true;
    }

    public void clearSelection() {
        HashSet deselected = new HashSet();
        for (BaseDetailPanel panel : this.dataModel) {
            if (!panel.getSelected()) continue;
            panel.setSelected(false);
            deselected.add(panel.getSubject());
        }
        SelectionEvent event = new SelectionEvent(deselected, false);
        this.notifyListeners(event);
    }

    protected void notifyListeners(SelectionEvent<U> event) {
        for (SelectionListener<U> listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return (int)visibleRect.getWidth();
        }
        return (int)visibleRect.getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 4;
    }

    int getFirstVisiblePanelIndex() {
        for (int i = 0; i < this.displayModel.size(); ++i) {
            BaseDetailPanel panel = (BaseDetailPanel)this.displayModel.get(i);
            Rectangle rectangle = panel.getVisibleRect();
            if (rectangle.height <= 0) continue;
            return i;
        }
        return -1;
    }

    public void addSelectionListener(SelectionListener<U> listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener<U> listener) {
        this.selectionListeners.remove(listener);
    }

    protected void ensureVisible(T panel) {
        SwingUtilities.invokeLater(new Runnable((BaseDetailPanel)panel){
            final /* synthetic */ BaseDetailPanel val$panel;
            {
                this.val$panel = baseDetailPanel;
            }

            @Override
            public void run() {
                Rectangle bounds = this.val$panel.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                this.val$panel.scrollRectToVisible(bounds);
            }
        });
    }

    public void showDetails(boolean show, int depth) {
        for (BaseDetailPanel panel : this.dataModel) {
            panel.showDetails(show, depth);
        }
    }

    public abstract void updateSelection(ViewState var1);

    public abstract void applyOptions(ViewState var1);

    protected abstract void addDetailPanel(T var1, int var2);

    protected abstract void setAllEnabled(boolean var1);

    public JPanel createExpanderPanel(String contents) {
        JPanel panel = this.uiUtils.createJPanel();
        panel.setLayout(new GridBagLayout());
        JEditorPane expanders = this.uiUtils.createEditorPane(contents);
        expanders.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String reference = e.getDescription();
                if ("#ex-all".equals(reference)) {
                    BaseInfoPanel.this.showDetails(true, -1);
                } else if ("#ex-top".equals(reference)) {
                    BaseInfoPanel.this.showDetails(false, -1);
                    BaseInfoPanel.this.showDetails(true, 0);
                } else if ("#ex-none".equals(reference)) {
                    BaseInfoPanel.this.showDetails(false, -1);
                } else if ("#en-all".equals(reference)) {
                    BaseInfoPanel.this.setAllEnabled(true);
                } else if ("#en-none".equals(reference)) {
                    BaseInfoPanel.this.setAllEnabled(false);
                } else {
                    Matcher matcher = sortPattern.matcher(reference);
                    if (!matcher.matches()) {
                        return;
                    }
                    int column = Integer.parseInt(matcher.group(1));
                    String direction = matcher.group(2);
                    Boolean descending = direction == null ? null : (direction.equals("-") ? Boolean.valueOf(true) : Boolean.valueOf(false));
                    BaseInfoPanel.this.sort(column, descending);
                }
            }
        });
        panel.add((Component)expanders, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void removeAll() {
        this.selectionListeners.clear();
        super.removeAll();
        this.dataModel.clear();
        this.displayModel.clear();
    }

    public void sort(int column, Boolean descending) {
        Comparator<T> comparator = this.getComparator(column, descending);
        Collections.sort(this.displayModel, comparator);
        int index = 0;
        for (BaseDetailPanel panel : this.displayModel) {
            this.setDisplayIndex(panel, index);
            ++index;
        }
        this.validate();
    }

    protected void setDisplayIndex(T panel, int displayIndex) {
        GridBagConstraints constraints = this.layout.getConstraints((Component)panel);
        constraints.gridy = displayIndex;
        this.layout.setConstraints((Component)panel, constraints);
        this.invalidate();
    }

    protected abstract Comparator<T> getComparator(int var1, Boolean var2);

    static {
        sortPattern = Pattern.compile("#sort-(\\d+)([+-])?");
        selectedBackground = new Color(255, 204, 51);
        defaultBackground = SystemColor.text;
    }
}

