/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.view.components.ToggleDetailPanel;
import org.genemania.plugin.view.util.UiUtils;

public class NetworkDetailPanel
extends ToggleDetailPanel<Network<?>> {
    private static final long serialVersionUID = 1L;
    private final Network<?> network;
    private final JEditorPane descriptionLabel;
    private final JToggleButton expander;
    private final NetworkUtils networkUtils;
    private final DataSet data;
    private Group<?, ?> group;
    private int barXOffset = -1;
    private int barYOffset = -1;
    private JLabel nameLabel;

    public NetworkDetailPanel(Network<?> network, Group<?, ?> group, NetworkUtils networkUtils, UiUtils uiUtils, DataSet data) {
        super(uiUtils);
        Color textColor;
        this.networkUtils = networkUtils;
        this.network = network;
        this.group = group;
        this.data = data;
        if (network.hasInteractions()) {
            textColor = Color.black;
        } else {
            this.setEnabled(false);
            textColor = Color.gray;
        }
        this.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.white));
        this.setBackground(SystemColor.text);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        this.nameLabel = new JLabel(network.getName());
        this.nameLabel.setForeground(textColor);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        JLabel scoreLabel = new JLabel(String.format(Strings.networkScore_label, this.getWeight()));
        scoreLabel.setForeground(textColor);
        this.expander = this.createToggleButton();
        this.add((Component)this.expander, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.nameLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)scoreLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        String description = String.format(Strings.networkDetailPanelDescription_label, networkUtils.buildDescriptionHtml(network, group));
        this.descriptionLabel = uiUtils.createLinkEnabledEditorPane(this, description);
        this.descriptionLabel.setFont(scoreLabel.getFont());
        this.descriptionLabel.setVisible(false);
        this.descriptionLabel.setForeground(textColor);
        this.add((Component)this.descriptionLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.computeBarPosition();
        Color color = this.networkUtils.getNetworkColor(this.data, this.group);
        g.setColor(color);
        int width = (int)((double)(this.getWidth() - this.barXOffset) * this.getWeight() / 100.0);
        for (int y = 0; y < 2; ++y) {
            int yOffset = this.barYOffset - y - 1;
            g.drawLine(this.barXOffset, yOffset, width + this.barXOffset, yOffset);
        }
    }

    private void computeBarPosition() {
        if (this.barXOffset == -1) {
            this.barXOffset = this.nameLabel.getX();
            this.barYOffset = this.getHeight();
        }
    }

    @Override
    public Network<?> getSubject() {
        return this.network;
    }

    @Override
    protected void doShowDetails(boolean show, int depth) {
        if (depth == 0) {
            this.invalidate();
            return;
        }
        this.expander.setSelected(show);
        this.descriptionLabel.setVisible(show);
        this.invalidate();
    }

    public double getWeight() {
        return this.network.getWeight() * 100.0;
    }

    public void setHighlighted(boolean networkHighlighted) {
        super.setSelected(networkHighlighted);
    }
}

