/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.controllers.DownloadController;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.view.util.UiUtils;

public class DownloadDialog
extends JDialog {
    private JTable table;
    private String dataSetId;
    private DownloadController controller;
    private JButton downloadButton;
    private JButton selectButton;
    private Action action;
    private DynamicTableModel<DownloadController.ModelElement> model;
    private ButtonGroup optionGroup;
    private Map<String, JRadioButton> optionMap;
    private JRadioButton noSelectionButton;
    private final UiUtils uiUtils;
    private final DataSetManager dataSetManager;
    private final FileUtils fileUtils;

    public DownloadDialog(Dialog parent, String title, boolean modal, String preamble, DataSetManager dataSetManager, UiUtils uiUtils, FileUtils fileUtils) throws ApplicationException {
        super(parent, title, modal);
        this.uiUtils = uiUtils;
        this.dataSetManager = dataSetManager;
        this.fileUtils = fileUtils;
        this.initialize(preamble);
    }

    void initialize(String preamble) throws ApplicationException {
        List<DownloadController.ModelElement> items;
        this.controller = new DownloadController(this.dataSetManager, this.fileUtils);
        JRootPane pane = this.getRootPane();
        pane.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel label = new JLabel(preamble);
        int row = 0;
        panel.add((Component)label, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 16, 0), 0, 0));
        ++row;
        try {
            items = this.controller.createModel();
        }
        catch (IOException e) {
            throw new ApplicationException(Strings.checkForUpdates_error);
        }
        this.model = new DynamicTableModel<DownloadController.ModelElement>(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Strings.downloadDialogInstalledColumn_label;
                    }
                    case 1: {
                        return Strings.downloadDialogNameColumn_label;
                    }
                    case 2: {
                        return Strings.downloadDialogDescriptionColumn_label;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                DownloadController.ModelElement element = (DownloadController.ModelElement)this.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return element.isInstalled();
                    }
                    case 1: {
                        if (element.isActive()) {
                            return String.format(Strings.downloadControllerModelElementActive_label, element.getName());
                        }
                        return String.format(Strings.downloadControllerModelElement_label, element.getName());
                    }
                    case 2: {
                        return element.getDescription();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        };
        for (DownloadController.ModelElement item : items) {
            this.model.add(item);
        }
        this.table = new JTable(this.model){

            @Override
            public void addNotify() {
                super.addNotify();
                DownloadDialog.this.uiUtils.packColumns(this);
            }
        };
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadDialog.this.updateOptions();
                DownloadDialog.this.validateState();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        panel.add((Component)scrollPane, new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 19, 1, insets, 0, 0));
        JPanel optionPanel = this.createOptionPanel();
        panel.add((Component)optionPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 19, 2, insets, 0, 0));
        JPanel buttonPanel = this.createButtonPanel();
        panel.add((Component)buttonPanel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 19, 0, insets, 0, 0));
        ++row;
        pane.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 19, 1, new Insets(16, 16, 16, 16), 0, 0));
        this.setMinimumSize(new Dimension(this.uiUtils.computeTextSizeHint(label.getFontMetrics(label.getFont()), 60, 25)));
        this.setLocationByPlatform(true);
        this.updateOptions();
        this.validateState();
        this.pack();
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        this.downloadButton = new JButton(Strings.downloadDialogDownloadButton_label);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadDialog.this.handleDownloadButton();
            }
        });
        this.selectButton = new JButton(Strings.downloadDialogSelectButton_label);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadDialog.this.handleSelectButton();
            }
        });
        JButton cancelButton = new JButton(Strings.downloadDialogCancelButton_label);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadDialog.this.handleCancelButton();
            }
        });
        buttonPanel.add(this.selectButton);
        buttonPanel.add(this.downloadButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel createOptionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Strings.downloadDialogOptionPanel_label));
        JRadioButton coreButton = new JRadioButton();
        JRadioButton allButton = new JRadioButton();
        JRadioButton openLicenseButton = new JRadioButton();
        this.optionMap = new HashMap<String, JRadioButton>();
        this.optionMap.put("-core", coreButton);
        this.optionMap.put("", allButton);
        this.optionMap.put("-open_license", openLicenseButton);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DownloadDialog.this.validateState();
            }
        };
        for (Map.Entry<String, JRadioButton> entry : this.optionMap.entrySet()) {
            JRadioButton button = entry.getValue();
            button.addActionListener(listener);
            button.setActionCommand(entry.getKey());
        }
        this.optionGroup = new ButtonGroup();
        this.optionGroup.add(coreButton);
        this.optionGroup.add(allButton);
        this.optionGroup.add(openLicenseButton);
        this.noSelectionButton = new JRadioButton();
        this.noSelectionButton.addActionListener(listener);
        this.noSelectionButton.setActionCommand("none");
        this.optionGroup.add(this.noSelectionButton);
        panel.add((Component)allButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)coreButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)openLicenseButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    void deselectAllOptions() {
        this.noSelectionButton.setSelected(true);
    }

    void updateOptions() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            this.disableOptions();
            return;
        }
        DownloadController.ModelElement root = this.model.get(row);
        DownloadController.ModelElement[] children = root.getChildren();
        this.enableOptions(root, children);
    }

    String getLabel(String option, boolean isActive, boolean isInstalled, double megabytes) {
        String description = isActive ? Strings.downloadDialogOptionPanelActive_label : (isInstalled ? Strings.downloadDialogOptionPanelInstalled_label : (megabytes == 0.0 ? "" : String.format(Strings.downloadDialogOptionSize_label, megabytes)));
        String template = Strings.get(String.format("downloadDialogOption%s", option));
        return String.format(template, description);
    }

    private void disableOptions() {
        for (Map.Entry<String, JRadioButton> entry : this.optionMap.entrySet()) {
            JRadioButton button = entry.getValue();
            String key = entry.getKey();
            button.setText(this.getLabel(key, false, false, 0.0));
            button.setEnabled(false);
            button.invalidate();
        }
        this.deselectAllOptions();
        this.invalidate();
        this.pack();
    }

    private void enableOptions(DownloadController.ModelElement parent, DownloadController.ModelElement[] children) {
        this.deselectAllOptions();
        if (children.length == 0) {
            for (Map.Entry<String, JRadioButton> entry : this.optionMap.entrySet()) {
                double size;
                JRadioButton button = entry.getValue();
                String key = entry.getKey();
                if ("".equals(key)) {
                    size = "".equals(key) ? this.computeSize(parent.getSize()) : 0.0;
                    button.setEnabled(true);
                    button.setSelected(true);
                } else {
                    button.setEnabled(false);
                    size = 0.0;
                }
                button.setText(this.getLabel(key, false, false, size));
                button.invalidate();
            }
            this.invalidate();
            this.pack();
            return;
        }
        for (Map.Entry<String, JRadioButton> entry : this.optionMap.entrySet()) {
            JRadioButton button = entry.getValue();
            String key = entry.getKey();
            button.setText(this.getLabel(key, false, false, 0.0));
            button.setEnabled(false);
            button.invalidate();
        }
        for (DownloadController.ModelElement child : children) {
            for (Map.Entry<String, JRadioButton> entry : this.optionMap.entrySet()) {
                String key = entry.getKey();
                if (!child.getName().endsWith(key)) continue;
                JRadioButton button = entry.getValue();
                button.setText(this.getLabel(key, child.isActive(), child.isInstalled(), this.computeSize(child.getSize())));
                button.setEnabled(true);
                button.setSelected(child.isInstalled());
                button.invalidate();
            }
        }
        this.invalidate();
        this.pack();
    }

    private double computeSize(long size) {
        return (double)size / 1024.0;
    }

    void validateState() {
        boolean download = false;
        DownloadController.ModelElement element = this.getSelection();
        if (element != null) {
            download = !element.isInstalled();
        }
        this.downloadButton.setEnabled(download);
        this.selectButton.setEnabled(element != null && !download);
    }

    void handleCancelButton() {
        this.action = Action.cancel;
        this.setVisible(false);
    }

    void handleAction(Action action) {
        this.action = action;
        DownloadController.ModelElement element = this.getSelection();
        if (element != null) {
            this.dataSetId = element.getName();
        }
        this.setVisible(false);
    }

    private DownloadController.ModelElement getSelection() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        DownloadController.ModelElement root = this.model.get(row);
        DownloadController.ModelElement[] children = root.getChildren();
        if (children.length == 0) {
            return root;
        }
        ButtonModel selection = this.optionGroup.getSelection();
        if (selection == null) {
            return null;
        }
        String selected = selection.getActionCommand();
        for (DownloadController.ModelElement child : children) {
            Matcher matcher = DownloadController.optionPattern.matcher(child.getName());
            if (!matcher.matches()) continue;
            String action = matcher.group(2);
            if (action == null) {
                action = "";
            }
            if (!action.equals(selected)) continue;
            return child;
        }
        return null;
    }

    void handleDownloadButton() {
        this.handleAction(Action.download);
    }

    void handleSelectButton() {
        this.handleAction(Action.select);
    }

    public String getSelectedDataSetId() {
        return this.dataSetId;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        download,
        select,
        cancel;

    }
}

