/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.AttributesController;
import org.genemania.plugin.model.AttributeEntry;

public class AttributesDialog
extends JDialog {
    private List<AttributeEntry> entries;
    private List<JCheckBox> checkBoxes;
    private List<String> selectedAttributes;

    public AttributesDialog(Frame parent, boolean modality, AttributesController controller) {
        super(parent, Strings.attributesDialog_title, modality);
        this.entries = controller.createModel();
        JRootPane root = this.getRootPane();
        root.setLayout(new GridBagLayout());
        JPanel canvas = new JPanel();
        canvas.setLayout(new GridBagLayout());
        int row = 0;
        Insets insets = new Insets(0, 0, 0, 0);
        JTextArea label = new JTextArea(Strings.attributesDialog_description);
        label.setEditable(false);
        label.setOpaque(false);
        label.setWrapStyleWord(true);
        label.setLineWrap(true);
        label.setColumns(40);
        label.setRows(4);
        canvas.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        canvas.add(this.createSelectPanel(), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 19, 0, insets, 0, 0));
        ++row;
        this.checkBoxes = new ArrayList<JCheckBox>();
        for (final AttributeEntry entry : this.entries) {
            final JCheckBox checkBox = new JCheckBox(entry.getDisplayName());
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    entry.setSelected(checkBox.isSelected());
                }
            });
            canvas.add((Component)checkBox, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            this.checkBoxes.add(checkBox);
            ++row;
        }
        canvas.add(this.createControlPanel(), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 19, 0, insets, 0, 0));
        canvas.add((Component)new JPanel(), new GridBagConstraints(0, ++row, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        ++row;
        root.add((Component)canvas, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(16, 16, 16, 16), 0, 0));
    }

    private Component createControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton addAttributesButton = new JButton(Strings.attributesDialogAddButton_label);
        addAttributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesDialog.this.handleAddAttributesButton();
            }
        });
        panel.add(addAttributesButton);
        JButton cancelButton = new JButton(Strings.attributesDialogCancelButton_label);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesDialog.this.handleCancelButton();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    private void handleCancelButton() {
        this.selectedAttributes = Collections.emptyList();
        this.setVisible(false);
    }

    private void handleAddAttributesButton() {
        this.selectedAttributes = new ArrayList<String>();
        for (AttributeEntry entry : this.entries) {
            if (!entry.isSelected()) continue;
            this.selectedAttributes.add(entry.getAttributeName());
        }
        this.setVisible(false);
    }

    public List<String> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    private Component createSelectPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton selectAllButton = new JButton(Strings.attributesDialogSelectAllButton_label);
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesDialog.this.handleSelectAllButton();
            }
        });
        panel.add(selectAllButton);
        JButton selectNoneButton = new JButton(Strings.attributesDialogSelectNoneButton_label);
        selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesDialog.this.handleSelectNoneButton();
            }
        });
        panel.add(selectNoneButton);
        return panel;
    }

    private void handleSelectNoneButton() {
        this.setSelected(false);
    }

    private void handleSelectAllButton() {
        this.setSelected(true);
    }

    private void setSelected(boolean selected) {
        for (JCheckBox checkBox : this.checkBoxes) {
            checkBox.setSelected(selected);
        }
        for (AttributeEntry entry : this.entries) {
            entry.setSelected(true);
        }
    }
}

