/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.report;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.NetworkMetadata;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.plugin.Metadata;
import org.genemania.plugin.Strings;
import org.genemania.plugin.controllers.IGeneProvider;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResult;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.report.AbstractXMLReader;
import org.genemania.plugin.report.ManiaReport;
import org.genemania.type.CombiningMethod;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ManiaReportXMLReader
extends AbstractXMLReader {
    private final ManiaReport report;
    private final IGeneProvider provider;
    private Map<Long, Gene> geneCache;

    public ManiaReportXMLReader(ManiaReport report, IGeneProvider provider) {
        this.report = report;
        this.provider = provider;
        this.geneCache = new HashMap<Long, Gene>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.startDocument();
        try {
            Metadata metadata = new Metadata();
            String version = metadata.getCytoscapeVersion();
            String buildId = metadata.getBuildId();
            if (version == null) {
                version = "development";
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "xsd:string", version);
            if (buildId != null) {
                attributes.addAttribute("", "buildId", "buildId", "xsd:string", buildId);
            }
            attributes.addAttribute("", "date", "date", "xsd:string", new Date().toString());
            attributes.addAttribute("", "data", "data", "xsd:string", this.report.getDataVersion());
            this.startElement("prediction", attributes);
            try {
                this.startElement("results");
                try {
                    this.exportGenes();
                    this.exportNetworks();
                    this.exportInteractions();
                }
                finally {
                    this.endElement("results");
                }
                this.exportParameters();
            }
            finally {
                this.endElement("prediction");
            }
        }
        finally {
            this.endDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportParameters() throws SAXException {
        this.startElement("query");
        try {
            ViewState viewState = this.report.getViewState();
            SearchResult result = viewState.getSearchResult();
            AttributesImpl attributes = new AttributesImpl();
            Organism organism = result.getOrganism();
            attributes.addAttribute("", "name", "name", "xsd:string", organism.getName());
            attributes.addAttribute("", "taxid", "taxid", "xsd:number", String.valueOf(organism.getTaxonomyId()));
            this.simpleElement("organism", attributes);
            attributes.clear();
            attributes.addAttribute("", "method", "method", "xsd:string", this.formatCombiningMethod(result.getCombiningMethod()));
            this.simpleElement("network-weighting", attributes);
            attributes.clear();
            attributes.addAttribute("", "limit", "limit", "xsd:string", String.valueOf(result.getGeneSearchLimit()));
            this.simpleElement("related-genes", attributes);
            attributes.clear();
            attributes.addAttribute("", "limit", "limit", "xsd:string", String.valueOf(result.getAttributeSearchLimit()));
            this.simpleElement("related-attributes", attributes);
            this.startElement("genes");
            try {
                for (Gene gene : result.getQueryGenes().values()) {
                    attributes.clear();
                    attributes.addAttribute("", "symbol", "symbol", "xsd:string", gene.getSymbol());
                    this.simpleElement("gene", attributes);
                }
            }
            finally {
                this.endElement("genes");
            }
            this.startElement("networks");
            try {
                for (Network network : this.report.getNetworks()) {
                    attributes.clear();
                    attributes.addAttribute("", "name", "name", "xsd:string", network.getName());
                    Group<?, ?> group = viewState.getGroup(network);
                    attributes.addAttribute("", "group", "group", "xsd:string", group.getCode());
                    this.simpleElement("network", attributes);
                }
            }
            finally {
                this.endElement("networks");
            }
        }
        finally {
            this.endElement("query");
        }
    }

    private String formatCombiningMethod(CombiningMethod combiningMethod) {
        switch (combiningMethod) {
            case AUTOMATIC: {
                return Strings.automatic;
            }
            case AVERAGE: {
                return Strings.average;
            }
            case AVERAGE_CATEGORY: {
                return Strings.average_category;
            }
            case BP: {
                return Strings.bp;
            }
            case MF: {
                return Strings.mf;
            }
            case CC: {
                return Strings.cc;
            }
        }
        return Strings.default_combining_method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportNetworks() throws SAXException {
        this.startElement("networks");
        try {
            ViewState viewState = this.report.getViewState();
            AttributesImpl attributes = new AttributesImpl();
            for (Network<?> entry : this.report.getNetworks()) {
                InteractionNetwork network = entry.adapt(InteractionNetwork.class);
                if (network == null) continue;
                Group<?, ?> group = viewState.getGroup(entry);
                NetworkMetadata metadata = network.getMetadata();
                attributes.clear();
                attributes.addAttribute("", "name", "name", "xsd:string", network.getName());
                attributes.addAttribute("", "group", "group", "xsd:string", group.getCode());
                attributes.addAttribute("", "weight", "weight", "xsd:number", String.format("%.2f", entry.getWeight() * 100.0));
                attributes.addAttribute("", "interactions", "interactions", "xsd:number", String.valueOf(metadata.getInteractionCount()));
                this.startElement("network", attributes);
                try {
                    attributes.clear();
                    attributes.addAttribute("", "title", "title", "xsd:string", metadata.getTitle());
                    attributes.addAttribute("", "authors", "authors", "xsd:string", metadata.getAuthors());
                    attributes.addAttribute("", "year", "year", "xsd:string", metadata.getYearPublished());
                    attributes.addAttribute("", "publication", "publication", "xsd:string", metadata.getPublicationName());
                    attributes.addAttribute("", "pmid", "pmid", "xsd:string", metadata.getPubmedId());
                    attributes.addAttribute("", "url", "url", "xsd:string", metadata.getUrl());
                    this.simpleElement("reference", attributes);
                    attributes.clear();
                    attributes.addAttribute("", "name", "name", "xsd:string", metadata.getSource());
                    attributes.addAttribute("", "url", "url", "xsd:string", metadata.getSourceUrl());
                    attributes.addAttribute("", "processing-method", "processing-method", "xsd:string", metadata.getProcessingDescription());
                    this.simpleElement("source", attributes);
                    this.simpleElement("comment", metadata.getComment());
                }
                finally {
                    this.endElement("network");
                }
            }
        }
        finally {
            this.endElement("networks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportGenes() throws SAXException {
        SearchResult options = this.report.getViewState().getSearchResult();
        this.startElement("genes");
        try {
            AttributesImpl attributes = new AttributesImpl();
            for (ManiaReport.GeneEntry entry : this.report.getGenes()) {
                attributes.clear();
                Gene gene = this.findGene(entry.getGene().getNode(), options);
                attributes.addAttribute("", "symbol", "symbol", "xsd:string", gene.getSymbol());
                if (entry.getScore() != Double.MAX_VALUE) {
                    attributes.addAttribute("", "score", "score", "xsd:number", String.format("%.2f", entry.getScore()));
                }
                attributes.addAttribute("", "description", "description", "xsd:string", gene.getNode().getGeneData().getDescription());
                this.simpleElement("gene", attributes);
            }
        }
        finally {
            this.endElement("genes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportInteractions() throws SAXException {
        SearchResult options = this.report.getViewState().getSearchResult();
        this.startElement("interactions");
        try {
            AttributesImpl attributes = new AttributesImpl();
            Map<InteractionNetwork, Double> networkWeights = options.getNetworkWeights();
            Map<Long, Double> weights = this.remapWeights(networkWeights);
            for (Map.Entry<Long, Collection<Attribute>> entry : options.getAttributesByNodeId().entrySet()) {
                Gene gene = options.getGene(entry.getKey());
                for (Attribute attribute : entry.getValue()) {
                    AttributeGroup group = options.getAttributeGroup(attribute.getId());
                    attributes.clear();
                    attributes.addAttribute("", "from", "from", "xsd:string", attribute.getName());
                    attributes.addAttribute("", "to", "to", "xsd:string", gene.getSymbol());
                    attributes.addAttribute("", "weight", "weight", "xsd:number", String.valueOf(0));
                    attributes.addAttribute("", "type", "type", "xsd:string", group.getName());
                    this.startElement("interaction", attributes);
                    this.endElement("interaction");
                }
            }
            for (InteractionNetwork network : networkWeights.keySet()) {
                for (Interaction interaction : network.getInteractions()) {
                    InteractionNetworkGroup group = options.getInteractionNetworkGroup(network.getId());
                    attributes.clear();
                    attributes.addAttribute("", "from", "from", "xsd:string", this.findGene(interaction.getFromNode(), options).getSymbol());
                    attributes.addAttribute("", "to", "to", "xsd:string", this.findGene(interaction.getToNode(), options).getSymbol());
                    attributes.addAttribute("", "weight", "weight", "xsd:number", String.valueOf((double)interaction.getWeight() * weights.get(network.getId()) * 100.0));
                    attributes.addAttribute("", "type", "type", "xsd:string", group.getName());
                    attributes.addAttribute("", "source", "source", "xsd:string", network.getName());
                    this.startElement("interaction", attributes);
                    this.endElement("interaction");
                }
            }
        }
        finally {
            this.endElement("interactions");
        }
    }

    private Map<Long, Double> remapWeights(Map<InteractionNetwork, Double> weights) {
        HashMap<Long, Double> result = new HashMap<Long, Double>();
        for (Map.Entry<InteractionNetwork, Double> entry : weights.entrySet()) {
            result.put(entry.getKey().getId(), entry.getValue());
        }
        return result;
    }

    private Gene findGene(Node node, SearchResult options) {
        long nodeId = node.getId();
        if (options.isQueryNode(nodeId)) {
            return options.getGene(node.getId());
        }
        Gene gene = this.geneCache.get(node.getId());
        if (gene == null) {
            gene = this.provider.getGene(node);
            this.geneCache.put(node.getId(), gene);
        }
        return gene;
    }
}

