/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.formatters;

import java.io.PrintWriter;
import org.genemania.domain.Gene;
import org.genemania.plugin.controllers.IGeneProvider;
import org.genemania.plugin.formatters.GeneListOutputFormatter;
import org.genemania.plugin.model.SearchResult;

public class GeneScoresOutputFormatter
extends GeneListOutputFormatter {
    public GeneScoresOutputFormatter(IGeneProvider geneProvider) {
        super(geneProvider);
    }

    @Override
    protected void formatGene(PrintWriter writer, SearchResult result, Gene gene, Double score) {
        Gene preferredGene = this.provider.getGene(gene.getNode());
        if (result.isQueryNode(gene.getNode().getId())) {
            writer.printf("%s\t\n", preferredGene.getSymbol());
        } else {
            writer.printf("%s\t%f\n", preferredGene.getSymbol(), score * 100.0);
        }
    }

    @Override
    public String getExtension() {
        return "scores.txt";
    }
}

