/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.genemania.exception.ApplicationException;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicListModel;
import org.genemania.plugin.data.DataDescriptor;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.ProgressReporter;

public class NetManiaPanel<NETWORK, NODE, EDGE>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DynamicListModel<DataDescriptor> installedModel;
    private DynamicListModel<DataDescriptor> availableModel;
    private JList installedList;
    private JList availableList;
    private JButton deleteButton;
    private JButton installButton;
    private final DataSetManager dataSetManager;
    private final UiUtils uiUtils;
    private final TaskDispatcher taskDispatcher;

    public NetManiaPanel(DataSetManager dataSetManager, UiUtils uiUtils, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.uiUtils = uiUtils;
        this.taskDispatcher = taskDispatcher;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        ListSelectionListener listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NetManiaPanel.this.validateSettings();
            }
        };
        JPanel installed = uiUtils.createJPanel();
        installed.setBorder(BorderFactory.createTitledBorder(Strings.netmaniaInstalledDataList_title));
        installed.setLayout(new GridBagLayout());
        this.installedList = new JList();
        this.installedList.setName(Strings.netmaniaInstalledDataList_title);
        this.installedList.setBorder(BorderFactory.createEtchedBorder());
        this.installedList.addListSelectionListener(listener);
        installed.add((Component)new JScrollPane(this.installedList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel installedButtons = uiUtils.createJPanel();
        installedButtons.setLayout(new GridBagLayout());
        installed.add((Component)installedButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.deleteButton = new JButton(Strings.deleteDataButton_label);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NetManiaPanel.this.doDelete();
            }
        });
        installedButtons.add((Component)this.deleteButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel available = uiUtils.createJPanel();
        available.setBorder(BorderFactory.createTitledBorder(Strings.netmaniaAvailableDataList_title));
        available.setLayout(new GridBagLayout());
        this.availableList = new JList();
        this.availableList.setName(Strings.netmaniaAvailableDataList_title);
        this.availableList.setBorder(BorderFactory.createEtchedBorder());
        this.availableList.addListSelectionListener(listener);
        available.add((Component)new JScrollPane(this.availableList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel availableButtons = uiUtils.createJPanel();
        availableButtons.setLayout(new GridBagLayout());
        available.add((Component)availableButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.installButton = new JButton(Strings.installDataButton_label);
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NetManiaPanel.this.doInstall();
            }
        });
        availableButtons.add((Component)this.installButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        JEditorPane descriptionPane = uiUtils.createLinkEnabledEditorPane(this, Strings.luceneConfigNetManiaTab_label);
        this.add((Component)descriptionPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)available, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)installed, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        LuceneDataSet data = (LuceneDataSet)dataSetManager.getDataSet();
        this.populate(data);
        this.validateSettings();
    }

    public void doDelete() {
        int[] selection;
        LuceneDataSet data = (LuceneDataSet)this.dataSetManager.getDataSet();
        for (int i : selection = this.installedList.getSelectedIndices()) {
            DataDescriptor descriptor = (DataDescriptor)this.installedModel.getElementAt(i);
            try {
                data.deleteIndex(descriptor.getId());
            }
            catch (ApplicationException e) {
                data.log(e);
            }
        }
        this.validateSettings();
        GeneManiaTask task = new GeneManiaTask(Strings.deleteData_status){

            @Override
            protected void runTask() throws Throwable {
                NetManiaPanel.this.dataSetManager.reloadDataSet(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(this), true, true);
        LogUtils.log(this.getClass(), task.getLastError());
        this.populate(data);
    }

    public void doInstall() {
        GeneManiaTask task = new GeneManiaTask(Strings.installData_status){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runTask() {
                int[] selection = NetManiaPanel.this.availableList.getSelectedIndices();
                ArrayList<Integer> installed = new ArrayList<Integer>();
                this.progress.setMaximumProgress(selection.length);
                LuceneDataSet data = (LuceneDataSet)NetManiaPanel.this.dataSetManager.getDataSet();
                for (int index : selection) {
                    if (this.progress.isCanceled()) break;
                    DataDescriptor descriptor = (DataDescriptor)NetManiaPanel.this.availableModel.getElementAt(index);
                    String name = descriptor.getId();
                    ChildProgressReporter childProgress = new ChildProgressReporter(this.progress);
                    try {
                        data.installIndex(name, descriptor.getDescription(), (ProgressReporter)childProgress);
                        if (childProgress.isCanceled()) {
                            data.deleteIndex(name);
                            break;
                        }
                        DataDescriptor installedDescriptor = NetManiaPanel.this.getInstalledDataDescriptor(descriptor.getId());
                        if (installedDescriptor != null) {
                            NetManiaPanel.this.installedModel.add(installedDescriptor);
                        } else {
                            NetManiaPanel.this.installedModel.add(descriptor);
                        }
                        installed.add(index);
                    }
                    catch (ApplicationException e) {
                        data.log(e);
                        try {
                            data.deleteIndex(name);
                        }
                        catch (ApplicationException e1) {
                            // empty catch block
                        }
                    }
                    finally {
                        childProgress.close();
                    }
                }
                Collections.sort(installed);
                for (int i = installed.size() - 1; i >= 0; --i) {
                    NetManiaPanel.this.availableModel.remove((Integer)installed.get(i));
                }
                NetManiaPanel.this.installedModel.sort();
                NetManiaPanel.this.validateSettings();
                NetManiaPanel.this.dataSetManager.reloadDataSet(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, this.uiUtils.getFrame(this), true, true);
        LogUtils.log(this.getClass(), task.getLastError());
    }

    private void validateSettings() {
        this.installButton.setEnabled(this.availableModel.getSize() > 0 && this.availableList.getSelectedIndex() != -1);
        this.deleteButton.setEnabled(this.installedModel.getSize() > 0 && this.installedList.getSelectedIndex() != -1);
    }

    private DataDescriptor getInstalledDataDescriptor(String id) {
        LuceneDataSet data = (LuceneDataSet)this.dataSetManager.getDataSet();
        List<DataDescriptor> installed = data.getInstalledDataDescriptors();
        for (DataDescriptor descriptor : installed) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    private void populate(LuceneDataSet<NETWORK, NODE, EDGE> data) {
        List<DataDescriptor> installed = data.getInstalledDataDescriptors();
        Collections.sort(installed);
        this.installedModel = new DynamicListModel<DataDescriptor>(installed);
        this.installedList.setModel(this.installedModel);
        List<DataDescriptor> availableDescriptors = data.getAvailableDataDescriptors();
        ArrayList<DataDescriptor> result = new ArrayList<DataDescriptor>();
        for (DataDescriptor descriptor : availableDescriptors) {
            if (installed.contains(descriptor)) continue;
            result.add(descriptor);
        }
        Collections.sort(result);
        this.availableModel = new DynamicListModel(result);
        this.availableList.setModel(this.availableModel);
    }
}

