/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.plugin.Strings;
import org.genemania.plugin.data.lucene.view.AbstractEditDialog;
import org.genemania.plugin.view.components.NetworkGroupComboBox;
import org.genemania.plugin.view.util.UiUtils;

public class EditNetworkDialog
extends AbstractEditDialog {
    private final NetworkGroupComboBox groupCombo;
    private final JTextField nameField;
    private final JTextArea descriptionField;
    private final JTextField groupNameField;

    public EditNetworkDialog(Frame owner, boolean modality, UiUtils uiUtils) {
        super(owner, Strings.editNetwork_title, modality);
        JPanel contents = uiUtils.createJPanel();
        contents.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        contents.setLayout(new GridBagLayout());
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditNetworkDialog.this.validateSettings();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditNetworkDialog.this.validateSettings();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditNetworkDialog.this.validateSettings();
            }
        };
        this.groupCombo = new NetworkGroupComboBox();
        this.groupCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditNetworkDialog.this.validateSettings();
            }
        });
        this.nameField = new JTextField(30);
        this.nameField.getDocument().addDocumentListener(listener);
        this.descriptionField = new JTextArea();
        this.descriptionField.setRows(3);
        this.descriptionField.getDocument().addDocumentListener(listener);
        JPanel buttonPanel = this.createButtonPanel(uiUtils);
        JScrollPane scrollPane = new JScrollPane(this.descriptionField);
        JPanel groupPanel = uiUtils.createJPanel();
        groupPanel.setLayout(new GridBagLayout());
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                EditNetworkDialog.this.validateSettings();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.groupNameField = new JTextField(30);
        this.groupNameField.getDocument().addDocumentListener(listener);
        this.groupNameField.addFocusListener(focusListener);
        groupPanel.add((Component)this.groupCombo, new GridBagConstraints(0, 0, 1, 1, Double.MIN_VALUE, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        groupPanel.add((Component)this.groupNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        int row = 0;
        contents.add((Component)new JLabel(Strings.importNetworkGroup_label), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)groupPanel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)new JLabel(Strings.importNetworkName_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)this.nameField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)new JLabel(Strings.importNetworkDescription_label), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)scrollPane, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        contents.add((Component)buttonPanel, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ++row;
        this.setLayout(new GridBagLayout());
        this.add((Component)contents, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected boolean isValidForm() {
        int groupIndex = this.groupCombo.getSelectedIndex();
        this.groupNameField.setVisible(groupIndex == 0);
        this.validate();
        boolean valid = this.nameField.getText().trim().length() > 0;
        valid &= this.descriptionField.getText().trim().length() > 0;
        valid &= groupIndex != -1;
        String groupName = this.groupNameField.getText().trim();
        return valid &= groupIndex != 0 || groupName.length() > 0 && !this.groupCombo.containsGroup(groupName);
    }

    public void setOrganism(Organism organism) {
        this.groupCombo.updateNetworkGroups(organism.getInteractionNetworkGroups());
    }

    public void setGroup(InteractionNetworkGroup group) {
        this.groupCombo.setGroup(group);
    }

    public void setNetworkName(String name) {
        this.nameField.setText(name);
    }

    public void setDescription(String description) {
        this.descriptionField.setText(description);
    }

    public InteractionNetworkGroup getGroup() {
        return this.groupCombo.getGroup();
    }

    public String getNetworkName() {
        return this.nameField.getText().trim();
    }

    public String getDescription() {
        return this.descriptionField.getText().trim();
    }

    public String getColor() {
        return null;
    }

    public String getGroupName() {
        return this.groupNameField.getText().trim();
    }
}

