/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene.controllers;

import java.awt.Frame;
import java.io.Reader;
import java.util.Collection;
import java.util.Set;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.dto.AddOrganismEngineRequestDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.cache.SynchronizedObjectCache;
import org.genemania.plugin.LogUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.completion.DynamicTableModel;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.data.lucene.LuceneDataSet;
import org.genemania.plugin.parsers.IdFileParser;
import org.genemania.plugin.task.GeneManiaTask;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.ProgressReporter;

public class ImportOrganismController {
    private final DataSetManager dataSetManager;
    private final TaskDispatcher taskDispatcher;

    public ImportOrganismController(DataSetManager dataSetManager, TaskDispatcher taskDispatcher) {
        this.dataSetManager = dataSetManager;
        this.taskDispatcher = taskDispatcher;
    }

    public DynamicTableModel<Organism> createModel(DataSet data) {
        return new DynamicTableModel<Organism>(){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Strings.importOrganismNameColumn_name;
                    }
                    case 1: {
                        return Strings.importOrganismDescriptionColumn_name;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int row, int column) {
                Organism organism = (Organism)this.get(row);
                switch (column) {
                    case 0: {
                        return organism.getName();
                    }
                    case 1: {
                        return organism.getDescription();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
            }
        };
    }

    public void deleteOrganisms(Frame parent, final LuceneDataSet data, final DynamicTableModel<Organism> installedModel, final int[] selection) {
        GeneManiaTask task = new GeneManiaTask(Strings.importOrganismDelete_title){

            @Override
            protected void runTask() throws Throwable {
                for (int index : selection) {
                    Organism organism = (Organism)installedModel.get(index);
                    data.deleteOrganism(organism);
                }
                ImportOrganismController.this.dataSetManager.reloadDataSet(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, parent, true, true);
        LogUtils.log(this.getClass(), task.getLastError());
    }

    public void updateOrganism(Frame parent, final DataSet data, final Organism organism) {
        GeneManiaTask task = new GeneManiaTask(Strings.importOrganismUpdate_title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runTask() throws Throwable {
                IModelWriter writer = data.createModelWriter();
                try {
                    writer.deleteOrganism(organism);
                    writer.addOrganism(organism);
                }
                finally {
                    writer.close();
                }
                ImportOrganismController.this.dataSetManager.reloadDataSet(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, parent, true, true);
        LogUtils.log(this.getClass(), task.getLastError());
    }

    public void importOrganism(Frame parent, final DataSet data, final Reader reader, final Organism organism) {
        GeneManiaTask task = new GeneManiaTask(Strings.importOrganismImport_title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runTask() throws Throwable {
                Set<Node> nodes;
                IdFileParser parser;
                this.progress.setMaximumProgress(2);
                this.progress.setStatus(Strings.importOrganismImport_status);
                this.progress.setProgress(0);
                ChildProgressReporter childProgress = new ChildProgressReporter(this.progress);
                try {
                    parser = new IdFileParser(data, Namespace.USER);
                    nodes = parser.parseNodes(reader, organism, (ProgressReporter)childProgress);
                    IModelWriter writer = data.createModelWriter();
                    try {
                        writer.addOrganism(organism);
                        for (Node node : nodes) {
                            writer.addNode(node, organism);
                        }
                    }
                    finally {
                        writer.close();
                    }
                }
                finally {
                    childProgress.close();
                }
                childProgress = new ChildProgressReporter(this.progress);
                try {
                    AddOrganismEngineRequestDto request = new AddOrganismEngineRequestDto();
                    request.setProgressReporter((ProgressReporter)childProgress);
                    request.setOrganismId(organism.getId());
                    Collection<Long> nodeIds = parser.extractNodeIds(nodes);
                    request.setNodeIds(nodeIds);
                    DataCache cache = new DataCache((IObjectCache)new SynchronizedObjectCache((IObjectCache)new MemObjectCache(data.getObjectCache(this.progress, false))));
                    Mania2 mania = new Mania2(cache);
                    mania.addOrganism(request);
                }
                finally {
                    childProgress.close();
                }
                ImportOrganismController.this.dataSetManager.reloadDataSet(this.progress);
            }
        };
        this.taskDispatcher.executeTask(task, parent, true, true);
        LogUtils.log(this.getClass(), task.getLastError());
    }
}

