/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.genemania.domain.InteractionNetwork;
import org.genemania.exception.ApplicationException;
import org.genemania.mediator.NetworkMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.plugin.LogUtils;

public class Queries {
    public long getNextAvailableUserId(final Searcher searcher, String type, final String field) throws ApplicationException {
        final long[] minId = new long[]{-1L};
        TermQuery query = new TermQuery(new Term("type", type));
        try {
            searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = searcher.doc(doc);
                        long id = Long.parseLong(document.get(field));
                        minId[0] = Math.min(minId[0], id);
                    }
                    catch (IOException e) {
                        LogUtils.log(((Object)((Object)this)).getClass(), e);
                    }
                }
            });
            return minId[0] - 1L;
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public long getNextAvailableCoreId(final Searcher searcher, String type, final String field) throws ApplicationException {
        final long[] maxId = new long[]{0L};
        TermQuery query = new TermQuery(new Term("type", type));
        try {
            searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = searcher.doc(doc);
                        long id = Long.parseLong(document.get(field));
                        maxId[0] = Math.max(maxId[0], id);
                    }
                    catch (IOException e) {
                        LogUtils.log(((Object)((Object)this)).getClass(), e);
                    }
                }
            });
            return maxId[0] + 1L;
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public long getOrganismIdFromGroup(Searcher searcher, long groupId) throws ApplicationException {
        String term = this.getUniqueTerm(searcher, "group_id", String.valueOf(groupId), "group_organism_id");
        if (term == null) {
            throw new ApplicationException();
        }
        return Long.parseLong(term);
    }

    public long getGroupIdFromNetwork(Searcher searcher, long networkId) throws ApplicationException {
        String term = this.getUniqueTerm(searcher, "network_id", String.valueOf(networkId), "network_group_id");
        if (term == null) {
            throw new ApplicationException();
        }
        return Long.parseLong(term);
    }

    public Collection<InteractionNetwork> getUserDefinedNetworks(final Searcher searcher, final NetworkMediator mediator) throws ApplicationException {
        final ArrayList<InteractionNetwork> networks = new ArrayList<InteractionNetwork>();
        TermQuery query = new TermQuery(new Term("type", "network"));
        try {
            searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = searcher.doc(doc);
                        long id = Long.parseLong(document.get("network_id"));
                        if (id < -1L) {
                            networks.add(mediator.getNetwork(id));
                        }
                    }
                    catch (IOException e) {
                        LogUtils.log(((Object)((Object)this)).getClass(), e);
                    }
                }
            });
            return networks;
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public String getUniqueTerm(final Searcher searcher, String lookupField, String lookupValue, final String targetField) throws ApplicationException {
        final String[] term = new String[1];
        TermQuery query = new TermQuery(new Term(lookupField, lookupValue));
        try {
            searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = searcher.doc(doc);
                        term[0] = document.get(targetField);
                    }
                    catch (IOException e) {
                        LogUtils.log(((Object)((Object)this)).getClass(), e);
                    }
                }
            });
            return term[0];
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }
}

