/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.lucene;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.genemania.data.classification.IGeneClassifier;
import org.genemania.data.classification.lucene.LuceneGeneClassifier;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.GeneNamingSource;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Organism;
import org.genemania.dto.RemoveNetworkEngineRequestDto;
import org.genemania.engine.Mania2;
import org.genemania.engine.cache.DataCache;
import org.genemania.engine.cache.IObjectCache;
import org.genemania.engine.cache.MemObjectCache;
import org.genemania.engine.core.data.NetworkIds;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.GeneMediator;
import org.genemania.mediator.NetworkMediator;
import org.genemania.mediator.NodeMediator;
import org.genemania.mediator.OntologyMediator;
import org.genemania.mediator.OrganismMediator;
import org.genemania.mediator.StatsMediator;
import org.genemania.mediator.lucene.AbstractCollector;
import org.genemania.mediator.lucene.LuceneAttributeMediator;
import org.genemania.mediator.lucene.LuceneGeneMediator;
import org.genemania.mediator.lucene.LuceneMediator;
import org.genemania.mediator.lucene.LuceneNamingSourceMediator;
import org.genemania.mediator.lucene.LuceneNetworkMediator;
import org.genemania.mediator.lucene.LuceneNodeMediator;
import org.genemania.mediator.lucene.LuceneOntologyMediator;
import org.genemania.mediator.lucene.LuceneOrganismMediator;
import org.genemania.mediator.lucene.LuceneStatsMediator;
import org.genemania.plugin.FileUtils;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.Colour;
import org.genemania.plugin.data.Configuration;
import org.genemania.plugin.data.DataDescriptor;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.data.DataSetManager;
import org.genemania.plugin.data.DefaultConfirmationHandler;
import org.genemania.plugin.data.IConfiguration;
import org.genemania.plugin.data.IConfirmationHandler;
import org.genemania.plugin.data.IMediatorProvider;
import org.genemania.plugin.data.IModelManager;
import org.genemania.plugin.data.IModelWriter;
import org.genemania.plugin.data.Namespace;
import org.genemania.plugin.data.lucene.LuceneConfiguration;
import org.genemania.plugin.data.lucene.LuceneConfirmationHandler;
import org.genemania.plugin.data.lucene.LuceneModelManager;
import org.genemania.plugin.data.lucene.LuceneModelWriter;
import org.genemania.plugin.data.lucene.Queries;
import org.genemania.plugin.data.lucene.Schema;
import org.genemania.plugin.task.TaskDispatcher;
import org.genemania.plugin.view.util.UiUtils;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.NullProgressReporter;
import org.genemania.util.ProgressReporter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LuceneDataSet<NETWORK, NODE, EDGE>
extends DataSet {
    private static final String METADATA_SHORT_NAME = "short_name";
    private static final String METADATA_COMMON_NAME = "common_name";
    private static final Colour DEFAULT_COLOUR = new Colour(0xD0D0D0);
    private Searcher searcher;
    private final Analyzer analyzer;
    private final Queries queries;
    private final DataSetManager dataSetManager;
    private final UiUtils uiUtils;
    private final FileUtils fileUtils;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final TaskDispatcher taskDispatcher;

    public LuceneDataSet(File path, Node root, DataSetManager dataSetManager, UiUtils uiUtils, FileUtils fileUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, TaskDispatcher taskDispatcher) throws SAXException {
        super(path, root);
        this.setHeadless(uiUtils == null);
        this.dataSetManager = dataSetManager;
        this.uiUtils = uiUtils;
        this.fileUtils = fileUtils;
        this.cytoscapeUtils = cytoscapeUtils;
        this.taskDispatcher = taskDispatcher;
        this.queries = new Queries();
        this.analyzer = LuceneMediator.createDefaultAnalyzer();
        try {
            this.reload(NullProgressReporter.instance());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public LuceneDataSet(File path, Node root, FileUtils fileUtils, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils, TaskDispatcher taskDispatcher) throws SAXException {
        this(path, root, null, null, fileUtils, cytoscapeUtils, taskDispatcher);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    private Searcher createSearcher(String indexPath) throws IOException {
        ArrayList<IndexSearcher> searchers = new ArrayList<IndexSearcher>();
        File indices = new File(indexPath);
        for (File file : indices.listFiles()) {
            try {
                if (!LuceneMediator.indexExists((File)file)) continue;
                FSDirectory directory = FSDirectory.open((File)file);
                searchers.add(new IndexSearcher((Directory)directory));
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        if (searchers.size() == 0) {
            Directory directory = this.createEmptyIndex();
            searchers.add(new IndexSearcher(directory));
        }
        return new MultiSearcher(searchers.toArray(new Searchable[searchers.size()]));
    }

    private Directory createEmptyIndex() {
        RAMDirectory directory = new RAMDirectory();
        try {
            IndexWriter writer = new IndexWriter((Directory)directory, (Analyzer)new StandardAnalyzer(Version.LUCENE_29), true, IndexWriter.MaxFieldLength.UNLIMITED);
            writer.commit();
            writer.close();
        }
        catch (CorruptIndexException e) {
        }
        catch (LockObtainFailedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return directory;
    }

    @Override
    public IMediatorProvider getMediatorProvider() {
        return new LuceneMediatorProvider();
    }

    @Override
    public IConfiguration getConfiguration() {
        if (this.isHeadless()) {
            return new Configuration(this);
        }
        return new LuceneConfiguration<NETWORK, NODE, EDGE>(this, this.dataSetManager, this.uiUtils, this.fileUtils, this.cytoscapeUtils, this.taskDispatcher);
    }

    @Override
    public List<DataDescriptor> getInstalledDataDescriptors() {
        ArrayList<DataDescriptor> descriptors = new ArrayList<DataDescriptor>();
        String indexPath = this.getBasePath();
        File indices = new File(indexPath);
        for (File file : indices.listFiles()) {
            String name;
            if (!file.isDirectory() || (name = file.getName()).equalsIgnoreCase("base") || name.equalsIgnoreCase("user")) continue;
            try {
                if (!LuceneMediator.indexExists((File)file)) continue;
                String id = name;
                String description = null;
                File metadataFile = new File(String.format("%s%smetadata.xml", file.getPath(), File.separator));
                Properties metadata = this.loadMetadata(metadataFile);
                if (metadata != null) {
                    String shortName = metadata.getProperty(METADATA_SHORT_NAME);
                    String commonName = metadata.getProperty(METADATA_COMMON_NAME);
                    description = String.format("%s (%s)", shortName, commonName);
                }
                if (id == null) continue;
                if (description == null) {
                    description = id;
                }
                descriptors.add(new DataDescriptor(id, description));
            }
            catch (IOException e) {
                this.log(e);
            }
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadMetadata(File file) throws IOException {
        if (!file.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        FileInputStream stream = new FileInputStream(file);
        try {
            properties.loadFromXML(stream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getOrganismsForIndex(String name) throws IOException {
        final HashSet<Long> organisms = new HashSet<Long>();
        String path = String.format("%s%s%s", this.getBasePath(), File.separator, name);
        FSDirectory directory = FSDirectory.open((File)new File(path));
        final IndexSearcher searcher = new IndexSearcher((Directory)directory);
        try {
            TermQuery query = new TermQuery(new Term("type", "organism"));
            searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = searcher.doc(doc);
                        long id = Long.parseLong(document.get("organism_id"));
                        organisms.add(id);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            HashSet<Long> hashSet = organisms;
            return hashSet;
        }
        finally {
            searcher.close();
        }
    }

    @Override
    public IModelWriter createModelWriter() throws ApplicationException {
        return new LuceneModelWriter(this.createIndexWriter());
    }

    @Override
    public IModelManager createModelManager(Namespace namespace) throws ApplicationException {
        return new LuceneModelManager(this, this.createConfirmationHandler(), this.createModelWriter(), namespace, this.fileUtils);
    }

    private IConfirmationHandler createConfirmationHandler() {
        if (this.isHeadless()) {
            return DefaultConfirmationHandler.instance();
        }
        return new LuceneConfirmationHandler(this.uiUtils, this.taskDispatcher);
    }

    private IndexWriter createIndexWriter() throws ApplicationException {
        Analyzer analyzer = LuceneMediator.createDefaultAnalyzer();
        String userIndexPath = this.getFullPath("user");
        try {
            FSDirectory directory = FSDirectory.open((File)new File(userIndexPath));
            boolean create = !IndexReader.indexExists((Directory)directory);
            return new IndexWriter((Directory)directory, analyzer, create, IndexWriter.MaxFieldLength.UNLIMITED);
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataDescriptor> getAvailableDataDescriptors() {
        ArrayList<DataDescriptor> result = new ArrayList<DataDescriptor>();
        try {
            String baseUrl = this.fileUtils.findDataSetBaseUrl("http://www.genemania.org/plugin", this.getVersion().toString());
            URL url = new URL(String.format("%s.xml", baseUrl));
            URLConnection connection = url.openConnection(this.fileUtils.getProxy());
            InputStream stream = connection.getInputStream();
            try {
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream).getDocumentElement();
                XPath xpath = XPathFactory.newInstance().newXPath();
                NodeList nodes = (NodeList)xpath.evaluate("data", root, XPathConstants.NODESET);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element node = (Element)nodes.item(i);
                    String id = node.getAttribute("path");
                    String name = (String)xpath.evaluate("name", node, XPathConstants.STRING);
                    String description = (String)xpath.evaluate("description", node, XPathConstants.STRING);
                    result.add(new DataDescriptor(id, String.format("%s %s", name, description)));
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        catch (SAXException e) {
            this.log(e);
        }
        catch (ParserConfigurationException e) {
            this.log(e);
        }
        catch (XPathExpressionException e) {
            this.log(e);
        }
        return result;
    }

    public void deleteIndex(String name) throws ApplicationException {
        try {
            Set<Long> organisms = this.getOrganismsForIndex(name);
            File cache = new File(this.getFullPath("cache"));
            this.deleteCache2(cache, organisms);
            for (long organismId : organisms) {
                String indexPath = this.getFullPath(String.valueOf(organismId));
                FSDirectory directory = FSDirectory.open((File)new File(indexPath));
                if (!IndexReader.indexExists((Directory)directory)) continue;
                this.fileUtils.delete(new File(indexPath));
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        catch (DataStoreException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private void deleteCache2(File root, Set<Long> organisms) throws ApplicationException, DataStoreException {
        Mania2 mania = new Mania2(new DataCache((IObjectCache)new MemObjectCache(this.getObjectCache(NullProgressReporter.instance(), false))));
        try {
            for (Long organismId : organisms) {
                RemoveNetworkEngineRequestDto request = new RemoveNetworkEngineRequestDto();
                request.setOrganismId(organismId.longValue());
                request.setNamespace("CORE");
                mania.removeUserNetworks(request);
            }
        }
        catch (ApplicationException e) {
            this.log(e);
        }
    }

    @Override
    public void reload(ProgressReporter progress) throws IOException {
        this.searcher = this.createSearcher(this.getBasePath());
        if (!this.validateUserNetworks()) {
            this.searcher = this.createSearcher(this.getBasePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateUserNetworks() {
        boolean requiresReload = false;
        try {
            DataCache cache = new DataCache((IObjectCache)new MemObjectCache(this.getObjectCache(NullProgressReporter.instance(), false)));
            IModelWriter writer = this.createModelWriter();
            try {
                for (InteractionNetwork network : this.getUserNetworks()) {
                    boolean purge = false;
                    InteractionNetworkGroup group = this.getNetworkGroup(network.getId());
                    if (group == null) {
                        purge = true;
                    } else {
                        Organism organism = this.getOrganism(group.getId());
                        if (organism == null) {
                            purge = true;
                        }
                        try {
                            cache.getNetwork("user", organism.getId(), network.getId());
                        }
                        catch (ApplicationException e) {
                            purge = true;
                        }
                    }
                    if (!purge) continue;
                    writer.deleteNetwork(network);
                    requiresReload = true;
                }
            }
            finally {
                writer.close();
            }
            Mania2 mania = new Mania2(cache);
            for (Organism organism : this.getMediatorProvider().getOrganismMediator().getAllOrganisms()) {
                NetworkIds networkIds;
                try {
                    networkIds = cache.getNetworkIds("user", organism.getId());
                }
                catch (ApplicationException e) {
                    break;
                }
                for (long networkId : networkIds.getNetworkIds()) {
                    try {
                        InteractionNetworkGroup group = this.getNetworkGroup(networkId);
                        if (group != null) continue;
                        RemoveNetworkEngineRequestDto request = new RemoveNetworkEngineRequestDto();
                        request.setNamespace("user");
                        request.setNetworkId(networkId);
                        request.setOrganismId(organism.getId());
                        mania.removeUserNetworks(request);
                    }
                    catch (ApplicationException e) {
                        this.log(e);
                    }
                }
            }
        }
        catch (ApplicationException e) {
            this.log(e);
        }
        catch (DataStoreException e) {
            this.log(e);
        }
        return !requiresReload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installIndex(String name, String description, ProgressReporter progress) throws ApplicationException {
        progress.setMaximumProgress(4);
        progress.setStatus(String.format(Strings.installIndex_status, description));
        try {
            String baseUrl = this.fileUtils.findDataSetBaseUrl("http://www.genemania.org/plugin", this.getVersion().toString());
            URL indexUrl = new URL(String.format("%s/%s.zip", baseUrl, URLEncoder.encode(name, "utf-8")));
            URL cacheUrl = new URL(String.format("%s/%s.cache.zip", baseUrl, URLEncoder.encode(name, "utf-8")));
            File indexDestination = new File(this.getBasePath());
            File cacheDestination = new File(this.getFullPath("cache"));
            if (progress.isCanceled()) {
                return;
            }
            ChildProgressReporter childProgress = new ChildProgressReporter(progress);
            File indexZip = this.fileUtils.download(indexUrl, indexDestination, (ProgressReporter)childProgress);
            childProgress.close();
            if (indexZip == null) {
                return;
            }
            try {
                if (progress.isCanceled()) {
                    return;
                }
                childProgress = new ChildProgressReporter(progress);
                this.fileUtils.unzip(indexZip, indexDestination, (ProgressReporter)childProgress);
                childProgress.close();
            }
            finally {
                indexZip.delete();
            }
            if (progress.isCanceled()) {
                return;
            }
            childProgress = new ChildProgressReporter(progress);
            File cacheZip = this.fileUtils.download(cacheUrl, indexDestination, (ProgressReporter)childProgress);
            childProgress.close();
            if (cacheZip == null) {
                return;
            }
            try {
                if (progress.isCanceled()) {
                    return;
                }
                childProgress = new ChildProgressReporter(progress);
                this.fileUtils.unzip(cacheZip, cacheDestination, (ProgressReporter)childProgress);
                childProgress.close();
            }
            finally {
                cacheZip.delete();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    @Override
    public GeneCompletionProvider2 getCompletionProvider(Organism organism) {
        return new GeneCompletionProvider2(this.searcher, this.analyzer, organism);
    }

    @Override
    public Colour getColor(String code) {
        String color = this.getFieldByValue("group_code", code, "group_colour");
        if (color != null) {
            return new Colour(Integer.parseInt(color, 16));
        }
        return DEFAULT_COLOUR;
    }

    @Override
    public InteractionNetworkGroup getNetworkGroup(long networkId) {
        LuceneMediator mediator = new LuceneMediator(this.searcher, LuceneMediator.createDefaultAnalyzer());
        String value = this.getFieldById("network_id", networkId, "network_group_id");
        if (value == null) {
            return null;
        }
        long groupId = Long.parseLong(value);
        Document document = this.getDocumentById("group_id", groupId);
        if (document == null) {
            return null;
        }
        return mediator.createNetworkGroup(document);
    }

    @Override
    public Organism getOrganism(long networkGroupId) {
        String value = this.getFieldById("group_id", networkGroupId, "group_organism_id");
        if (value == null) {
            return null;
        }
        long organismId = Long.parseLong(value);
        OrganismMediator mediator = this.getMediatorProvider().getOrganismMediator();
        try {
            return mediator.getOrganism(organismId);
        }
        catch (DataStoreException e) {
            this.log(e);
            return null;
        }
    }

    protected Document getDocumentById(String sourceField, long id) {
        return this.getDocumentByValue(sourceField, String.valueOf(id));
    }

    protected Document getDocumentByValue(String sourceField, String value) {
        TermQuery query = new TermQuery(new Term(sourceField, value));
        try {
            TopDocs docs = this.searcher.search((Query)query, 1);
            if (docs.totalHits > 0) {
                ScoreDoc scoreDoc = docs.scoreDocs[0];
                Document document = this.searcher.doc(scoreDoc.doc);
                return document;
            }
        }
        catch (IOException e) {
            this.log(e);
        }
        return null;
    }

    protected String getFieldById(String sourceField, long id, String targetField) {
        Document document = this.getDocumentById(sourceField, id);
        if (document == null) {
            return null;
        }
        return document.get(targetField);
    }

    protected String getFieldByValue(String sourceField, String value, String targetField) {
        Document document = this.getDocumentByValue(sourceField, value);
        if (document == null) {
            return null;
        }
        return document.get(targetField);
    }

    @Override
    public List<Long> getNodeIds(long organismId) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        TermQuery query = new TermQuery(new Term("node_organism_id", String.valueOf(organismId)));
        try {
            this.searcher.search((Query)query, (Collector)new AbstractCollector(){

                public void handleHit(int doc) {
                    try {
                        Document document = LuceneDataSet.this.searcher.doc(doc);
                        ids.add(Long.parseLong(document.get("node_id")));
                    }
                    catch (IOException e) {
                        LuceneDataSet.this.log(e);
                    }
                }
            });
        }
        catch (IOException e) {
            this.log(e);
        }
        return ids;
    }

    @Override
    public List<GeneNamingSource> getAllNamingSources() {
        LuceneNamingSourceMediator mediator = new LuceneNamingSourceMediator(this.searcher, this.analyzer);
        return mediator.getAllNamingSources();
    }

    @Override
    public IGeneClassifier getGeneClassifier() {
        return new LuceneGeneClassifier(this.searcher, this.analyzer);
    }

    @Override
    public <T> Long getNextAvailableId(Class<T> modelClass, Namespace namespace) {
        String attribute = Schema.getTypeField(modelClass);
        String id = Schema.getIdField(modelClass);
        if (attribute == null || id == null) {
            return null;
        }
        try {
            if (namespace == Namespace.CORE) {
                return this.queries.getNextAvailableCoreId(this.searcher, attribute, id);
            }
            return this.queries.getNextAvailableUserId(this.searcher, attribute, id);
        }
        catch (ApplicationException e) {
            this.log(e);
            return null;
        }
    }

    @Override
    public Collection<InteractionNetwork> getUserNetworks() throws ApplicationException {
        return this.queries.getUserDefinedNetworks(this.getSearcher(), this.getMediatorProvider().getNetworkMediator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrganism(Organism organism) throws ApplicationException, DataStoreException {
        HashSet<Long> organisms = new HashSet<Long>();
        organisms.add(organism.getId());
        File cache = new File(this.getFullPath("cache"));
        this.deleteCache2(cache, organisms);
        IModelWriter writer = this.createModelWriter();
        try {
            writer.deleteOrganismNodesAndGenes(organism);
        }
        finally {
            writer.close();
        }
    }

    class LuceneMediatorProvider
    implements IMediatorProvider {
        private GeneMediator geneMediator;
        private NetworkMediator networkMediator;
        private NodeMediator nodeMediator;
        private StatsMediator statsMediator;
        private OntologyMediator ontologyMediator;
        private AttributeMediator attributeMediator;

        LuceneMediatorProvider() {
        }

        @Override
        public OrganismMediator getOrganismMediator() {
            return new LuceneOrganismMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GeneMediator getGeneMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.geneMediator == null) {
                    this.geneMediator = new LuceneGeneMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.geneMediator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetworkMediator getNetworkMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.networkMediator == null) {
                    this.networkMediator = new LuceneNetworkMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.networkMediator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NodeMediator getNodeMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.nodeMediator == null) {
                    this.nodeMediator = new LuceneNodeMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.nodeMediator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatsMediator getStatsMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.statsMediator == null) {
                    this.statsMediator = new LuceneStatsMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.statsMediator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OntologyMediator getOntologyMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.ontologyMediator == null) {
                    this.ontologyMediator = new LuceneOntologyMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.ontologyMediator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AttributeMediator getAttributeMediator() {
            LuceneMediatorProvider luceneMediatorProvider = this;
            synchronized (luceneMediatorProvider) {
                if (this.attributeMediator == null) {
                    this.attributeMediator = new LuceneAttributeMediator(LuceneDataSet.this.searcher, LuceneDataSet.this.analyzer);
                }
            }
            return this.attributeMediator;
        }
    }
}

