/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.data.compatibility;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import no.uib.cipr.matrix.DenseMatrix;
import org.genemania.plugin.data.compatibility.Adapter;
import org.genemania.plugin.data.compatibility.AdapterStrategy;

public class AdapterStrategy1450
implements AdapterStrategy {
    private static final Map<String, Adapter<?, ?>> adapters = new HashMap();
    private ClassLoader classLoader;

    public AdapterStrategy1450(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Adapter<?, ?> getAdapter(String className) {
        return adapters.get(className);
    }

    @Override
    public boolean shouldAdapt(String className) {
        if (!className.startsWith("no.uib.cipr")) {
            return false;
        }
        try {
            Class<?> type = Class.forName(className, false, this.classLoader);
            return !type.isInterface();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean createdThis(Object object) {
        return object.getClass().getClassLoader() == this.classLoader;
    }

    @Override
    public Class<?> resolveClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, this.classLoader);
    }

    static {
        adapters.put("no.uib.cipr.matrix.DenseMatrix", new Adapter<MatrixProxy, DenseMatrix>(){

            @Override
            public Class<MatrixProxy> getInterface() {
                return MatrixProxy.class;
            }

            @Override
            public DenseMatrix adapt(MatrixProxy object) {
                int rows = object.numRows();
                int columns = object.numColumns();
                DenseMatrix result = new DenseMatrix(rows, columns);
                double[] data = object.getData();
                try {
                    Class<?> type = Class.forName("no.uib.cipr.matrix.AbstractDenseMatrix");
                    Field field = type.getDeclaredField("data");
                    field.setAccessible(true);
                    field.set(result, data);
                }
                catch (SecurityException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        });
    }

    static interface MatrixProxy {
        public int numRows();

        public int numColumns();

        public double[] getData();
    }
}

