/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.cytoscape;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.Attribute;
import org.genemania.domain.AttributeGroup;
import org.genemania.domain.Gene;
import org.genemania.domain.Interaction;
import org.genemania.domain.InteractionNetwork;
import org.genemania.domain.InteractionNetworkGroup;
import org.genemania.domain.Node;
import org.genemania.domain.Organism;
import org.genemania.exception.DataStoreException;
import org.genemania.mediator.AttributeMediator;
import org.genemania.mediator.OrganismMediator;
import org.genemania.plugin.GeneMania;
import org.genemania.plugin.OneUseIterable;
import org.genemania.plugin.Strings;
import org.genemania.plugin.cytoscape.CytoscapeUtils;
import org.genemania.plugin.data.DataSet;
import org.genemania.plugin.model.AnnotationEntry;
import org.genemania.plugin.model.Group;
import org.genemania.plugin.model.Network;
import org.genemania.plugin.model.SearchResultBuilder;
import org.genemania.plugin.model.ViewState;
import org.genemania.plugin.model.ViewStateBuilder;
import org.genemania.plugin.model.impl.SearchResultImpl;
import org.genemania.plugin.model.impl.ViewStateImpl;
import org.genemania.plugin.proxies.EdgeProxy;
import org.genemania.plugin.proxies.NetworkProxy;
import org.genemania.plugin.proxies.NodeProxy;
import org.genemania.plugin.selection.NetworkSelectionManager;
import org.genemania.type.CombiningMethod;
import org.genemania.util.ChildProgressReporter;
import org.genemania.util.ProgressReporter;

public class ResultReconstructor<NETWORK, NODE, EDGE> {
    private final DataSet data;
    private final Set<String> unrecognizedNodes;
    private final Set<String> unrecognizedAnnotations;
    private final CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils;
    private final GeneMania<NETWORK, NODE, EDGE> plugin;
    private String version;
    private final Map<Node, String> nodeIds;
    private final Set<InteractionNetworkGroup> enabledGroups;
    private final Map<String, Set<Object>> sourceNetworksByEdgeId;
    private final Map<String, Set<Object>> sourceNetworksByNodeId;
    private final Map<String, Set<String>> edgeIdsByGroup;
    private final Map<String, Node> nodeCache;

    public ResultReconstructor(DataSet data, GeneMania<NETWORK, NODE, EDGE> plugin, CytoscapeUtils<NETWORK, NODE, EDGE> cytoscapeUtils) {
        this.data = data;
        this.plugin = plugin;
        this.cytoscapeUtils = cytoscapeUtils;
        this.unrecognizedNodes = new HashSet<String>();
        this.unrecognizedAnnotations = new HashSet<String>();
        this.nodeIds = new HashMap<Node, String>();
        this.enabledGroups = new HashSet<InteractionNetworkGroup>();
        this.sourceNetworksByEdgeId = new HashMap<String, Set<Object>>();
        this.sourceNetworksByNodeId = new HashMap<String, Set<Object>>();
        this.edgeIdsByGroup = new HashMap<String, Set<String>>();
        this.nodeCache = new HashMap<String, Node>();
    }

    public Set<String> getUnrecognizedNodes() {
        return Collections.unmodifiableSet(this.unrecognizedNodes);
    }

    public String getVersion() {
        return this.version;
    }

    void addEdgeIdForGroup(String name, String edgeId) {
        Set<String> edgeIds = this.edgeIdsByGroup.get(name);
        if (edgeIds == null) {
            edgeIds = new HashSet<String>();
            this.edgeIdsByGroup.put(name, edgeIds);
        }
        edgeIds.add(edgeId);
    }

    void addSourceNetworkForNode(String nodeId, Object network) {
        Set<Object> networks = this.sourceNetworksByNodeId.get(nodeId);
        if (networks == null) {
            networks = new HashSet<Object>();
            this.sourceNetworksByNodeId.put(nodeId, networks);
        }
        networks.add(network);
    }

    void addSourceNetworkForEdge(String edgeId, Object network) {
        Set<Object> networks = this.sourceNetworksByEdgeId.get(edgeId);
        if (networks == null) {
            networks = new HashSet<Object>();
            this.sourceNetworksByEdgeId.put(edgeId, networks);
        }
        networks.add(network);
    }

    Organism reconstructOrganism(NETWORK network) throws DataStoreException {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(network);
        String organismName = proxy.getAttribute("organism", String.class);
        if (organismName == null) {
            return null;
        }
        OrganismMediator mediator = this.data.getMediatorProvider().getOrganismMediator();
        for (Organism organism : mediator.getAllOrganisms()) {
            if (!organismName.equals(organism.getName())) continue;
            return organism;
        }
        return null;
    }

    public ViewState reconstructCache(NETWORK cyNetwork, ProgressReporter progress) throws DataStoreException, IOException {
        progress.setStatus(Strings.resultReconstructor_status);
        int currentProgress = 0;
        progress.setMaximumProgress(6);
        progress.setProgress(currentProgress);
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        String dataVersion = proxy.getAttribute("data version", String.class);
        if (dataVersion == null) {
            return null;
        }
        this.version = dataVersion;
        if (!dataVersion.equals(this.data.getVersion().toString())) {
            return null;
        }
        Organism targetOrganism = this.reconstructOrganism(cyNetwork);
        if (targetOrganism == null) {
            return null;
        }
        SearchResultImpl builder = new SearchResultImpl();
        builder.setOrganism(targetOrganism);
        builder.setCombiningMethod(this.reconstructCombiningMethod(cyNetwork));
        builder.setGeneSearchLimit(this.reconstructGeneSearchLimit(cyNetwork));
        builder.setAttributeSearchLimit(this.reconstructAttributeSearchLimit(cyNetwork));
        progress.setProgress(++currentProgress);
        ChildProgressReporter childProgress = new ChildProgressReporter(progress);
        this.reconstructNodeCache(builder, cyNetwork, targetOrganism, (ProgressReporter)childProgress);
        childProgress.close();
        childProgress = new ChildProgressReporter(progress);
        this.reconstructNetworkCache(builder, cyNetwork, targetOrganism, (ProgressReporter)childProgress);
        childProgress.close();
        childProgress = new ChildProgressReporter(progress);
        this.reconstructEnrichmentCache(builder, cyNetwork, targetOrganism, (ProgressReporter)childProgress);
        childProgress.close();
        childProgress = new ChildProgressReporter(progress);
        this.reconstructAttributeCache(builder, cyNetwork, targetOrganism, (ProgressReporter)childProgress);
        childProgress.close();
        ViewStateImpl viewStateBuilder = new ViewStateImpl(builder);
        childProgress = new ChildProgressReporter(progress);
        this.reconstructViewState(viewStateBuilder, (ProgressReporter)childProgress);
        childProgress.close();
        NetworkSelectionManager<NETWORK, NODE, EDGE> manager = this.plugin.getNetworkSelectionManager();
        this.cytoscapeUtils.registerSelectionListener(cyNetwork, manager, this.plugin);
        return viewStateBuilder.build();
    }

    private void reconstructViewState(ViewStateBuilder builder, ProgressReporter progress) {
        Network network;
        progress.setDescription(Strings.resultReconstructorViewState_description);
        int maximum = 0;
        maximum += this.nodeIds.size();
        maximum += this.enabledGroups.size();
        maximum += builder.getAllGroups().size();
        maximum += this.sourceNetworksByEdgeId.size();
        maximum += this.sourceNetworksByNodeId.size();
        progress.setMaximumProgress(maximum += this.edgeIdsByGroup.size());
        int count = 0;
        for (Map.Entry<Node, String> entry : this.nodeIds.entrySet()) {
            builder.addNode(entry.getKey(), entry.getValue());
            progress.setProgress(++count);
        }
        for (InteractionNetworkGroup group : this.enabledGroups) {
            Group<?, ?> group2 = builder.getGroup(group.getName());
            builder.setEnabled(group2, true);
            progress.setProgress(++count);
        }
        HashMap networksByModel = new HashMap();
        for (Group<?, ?> group : builder.getAllGroups()) {
            for (Network<?> network2 : group.getNetworks()) {
                networksByModel.put(network2.getModel(), network2);
            }
            progress.setProgress(++count);
        }
        for (Map.Entry entry : this.sourceNetworksByEdgeId.entrySet()) {
            for (Network<Object> model : (Set)entry.getValue()) {
                network = (Network)networksByModel.get(model);
                builder.addSourceNetworkForEdge((String)entry.getKey(), network);
            }
            progress.setProgress(++count);
        }
        for (Map.Entry entry : this.sourceNetworksByNodeId.entrySet()) {
            for (Network<Object> model : (Set)entry.getValue()) {
                network = (Network)networksByModel.get(model);
                builder.addSourceNetworkForNode((String)entry.getKey(), network);
            }
            progress.setProgress(++count);
        }
        for (Map.Entry entry : this.edgeIdsByGroup.entrySet()) {
            Group<?, ?> group = builder.getGroup((String)entry.getKey());
            for (String edgeId : (Set)entry.getValue()) {
                builder.addEdge(group, edgeId);
            }
            progress.setProgress(++count);
        }
    }

    private void reconstructEnrichmentCache(SearchResultBuilder builder, NETWORK cyNetwork, Organism targetOrganism, ProgressReporter progress) throws IOException {
        progress.setDescription(Strings.resultReconstructorEnrichmentCache_description);
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        String rawAnnotations = networkProxy.getAttribute("annotations", String.class);
        if (rawAnnotations == null) {
            return;
        }
        HashMap<Long, Collection<AnnotationEntry>> annotationsByNode = new HashMap<Long, Collection<AnnotationEntry>>();
        HashMap<String, AnnotationEntry> annotationsByCategory = new HashMap<String, AnnotationEntry>();
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createJsonParser(rawAnnotations);
        JsonNode root = parser.readValueAsTree();
        for (JsonNode node : new OneUseIterable(root.getElements())) {
            AnnotationEntry entry = new AnnotationEntry(node);
            annotationsByCategory.put(entry.getName(), entry);
        }
        GeneCompletionProvider2 completionProvider = this.data.getCompletionProvider(targetOrganism);
        for (NODE node : networkProxy.getNodes()) {
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(node, cyNetwork);
            String symbol = nodeProxy.getAttribute("gene name", String.class);
            if (symbol == null) continue;
            Gene gene = completionProvider.getGene(symbol);
            if (gene == null) {
                this.unrecognizedNodes.add(symbol);
                continue;
            }
            long nodeId = gene.getNode().getId();
            List annotations = nodeProxy.getAttribute("annotations", List.class);
            if (annotations == null) continue;
            for (String annotation : annotations) {
                AnnotationEntry entry = (AnnotationEntry)annotationsByCategory.get(annotation);
                if (entry == null) {
                    this.unrecognizedAnnotations.add(annotation);
                    continue;
                }
                HashSet<AnnotationEntry> entries = (HashSet<AnnotationEntry>)annotationsByNode.get(nodeId);
                if (entries == null) {
                    entries = new HashSet<AnnotationEntry>();
                    annotationsByNode.put(nodeId, entries);
                }
                entries.add(entry);
            }
        }
        builder.setEnrichment(annotationsByNode);
    }

    private void reconstructNetworkCache(SearchResultBuilder builder, NETWORK cyNetwork, Organism organism, ProgressReporter progress) throws IOException {
        progress.setDescription(Strings.resultReconstructorNetworkCache_description);
        HashMap<Long, InteractionNetworkGroup> allGroupsByNetwork = new HashMap<Long, InteractionNetworkGroup>();
        HashMap<String, InteractionNetworkGroup> allGroupsByName = new HashMap<String, InteractionNetworkGroup>();
        HashMap<String, InteractionNetwork> allNetworksByName = new HashMap<String, InteractionNetwork>();
        Collection groups = organism.getInteractionNetworkGroups();
        for (InteractionNetworkGroup group : groups) {
            for (InteractionNetwork network2 : group.getInteractionNetworks()) {
                allNetworksByName.put(String.format("%s|%s", group.getName(), network2.getName()), network2);
                allGroupsByNetwork.put(network2.getId(), group);
            }
            group.setInteractionNetworks(new HashSet());
            allGroupsByName.put(group.getName(), group);
        }
        Map<InteractionNetwork, Double> networkWeights = this.reconstructNetworkWeights(cyNetwork, allNetworksByName);
        Map<InteractionNetwork, Collection<Interaction>> allInteractions = this.reconstructSourceNetworks(builder, organism, cyNetwork, allNetworksByName, allGroupsByName, progress);
        HashMap<Long, InteractionNetworkGroup> groupsByNetwork = new HashMap<Long, InteractionNetworkGroup>();
        for (InteractionNetwork network : networkWeights.keySet()) {
            Collection<Interaction> interactions = allInteractions.get(network);
            if (interactions == null) {
                interactions = Collections.emptySet();
                allInteractions.put(network, interactions);
            }
            network.setInteractions(interactions);
            long networkId = network.getId();
            InteractionNetworkGroup group = (InteractionNetworkGroup)allGroupsByNetwork.get(networkId);
            groupsByNetwork.put(networkId, group);
            group.getInteractionNetworks().add(network);
        }
        builder.setGroups(groupsByNetwork);
        builder.setNetworkWeights(networkWeights);
    }

    private Map<InteractionNetwork, Collection<Interaction>> reconstructSourceNetworks(SearchResultBuilder builder, Organism organism, NETWORK cyNetwork, Map<String, InteractionNetwork> allNetworksByName, Map<String, InteractionNetworkGroup> allGroupsByName, ProgressReporter progress) {
        progress.setDescription(Strings.resultReconstructorSourceNetworks_description);
        HashMap<InteractionNetwork, Collection<Interaction>> allInteractions = new HashMap<InteractionNetwork, Collection<Interaction>>();
        HashMap<Long, Node> allNodes = new HashMap<Long, Node>();
        GeneCompletionProvider2 completionProvider = this.data.getCompletionProvider(organism);
        NetworkProxy<NETWORK, NODE, EDGE> networkProxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        Collection<EDGE> edges = networkProxy.getEdges();
        progress.setMaximumProgress(edges.size());
        int count = 0;
        for (EDGE cyEdge : edges) {
            progress.setProgress(++count);
            EdgeProxy<EDGE, NODE> edgeProxy = this.cytoscapeUtils.getEdgeProxy(cyEdge, cyNetwork);
            String groupName = edgeProxy.getAttribute("data type", String.class);
            InteractionNetworkGroup group = allGroupsByName.get(groupName);
            if (group == null) continue;
            this.enabledGroups.add(group);
            List sourceNetworks = edgeProxy.getAttribute("networks", List.class);
            List networkWeights = edgeProxy.getAttribute("raw weights", List.class);
            if (sourceNetworks == null || networkWeights == null) continue;
            String edgeId = edgeProxy.getIdentifier();
            for (int i = 0; i < sourceNetworks.size(); ++i) {
                String name = (String)sourceNetworks.get(i);
                double weight = (Double)networkWeights.get(i);
                InteractionNetwork key = allNetworksByName.get(String.format("%s|%s", groupName, name));
                if (key == null) continue;
                Interaction interaction = new Interaction();
                Node fromNode = this.getNode(cyNetwork, allNodes, edgeProxy.getSource(), completionProvider);
                Node toNode = this.getNode(cyNetwork, allNodes, edgeProxy.getTarget(), completionProvider);
                if (fromNode == null || toNode == null) continue;
                interaction.setFromNode(fromNode);
                interaction.setToNode(toNode);
                interaction.setWeight((float)weight);
                HashSet<Interaction> interactions = (HashSet<Interaction>)allInteractions.get(key);
                if (interactions == null) {
                    interactions = new HashSet<Interaction>();
                    allInteractions.put(key, interactions);
                }
                interactions.add(interaction);
                this.addSourceNetworkForEdge(edgeId, key);
            }
            this.addEdgeIdForGroup(group.getName(), edgeId);
        }
        return allInteractions;
    }

    private Map<InteractionNetwork, Double> reconstructNetworkWeights(NETWORK cyNetwork, Map<String, InteractionNetwork> allNetworksByName) throws IOException {
        HashMap<InteractionNetwork, Double> weights = new HashMap<InteractionNetwork, Double>();
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        String rawNetworks = proxy.getAttribute("source-networks", String.class);
        MappingJsonFactory factory = new MappingJsonFactory();
        JsonParser parser = factory.createJsonParser(rawNetworks);
        JsonNode root = parser.readValueAsTree();
        for (JsonNode node : new OneUseIterable(root.getElements())) {
            String groupName = node.get("group").getTextValue();
            String name = node.get("name").getTextValue();
            double weight = node.get("weight").getDoubleValue();
            InteractionNetwork network = allNetworksByName.get(String.format("%s|%s", groupName, name));
            if (network == null) continue;
            weights.put(network, weight);
        }
        return weights;
    }

    private void reconstructAttributeCache(SearchResultBuilder builder, NETWORK cyNetwork, Organism organism, ProgressReporter progress) {
        progress.setDescription(Strings.resultReconstructorAttributeCache_description);
        HashMap<String, Attribute> attributesByName = new HashMap<String, Attribute>();
        HashMap<Long, AttributeGroup> groupsByAttribute = new HashMap<Long, AttributeGroup>();
        AttributeMediator mediator = this.data.getMediatorProvider().getAttributeMediator();
        for (AttributeGroup group : mediator.findAttributeGroupsByOrganism(organism.getId())) {
            for (Attribute attribute : mediator.findAttributesByGroup(organism.getId(), group.getId())) {
                attributesByName.put(attribute.getName(), attribute);
                long id = attribute.getId();
                groupsByAttribute.put(id, group);
            }
        }
        builder.setGroupsByAttribute(groupsByAttribute);
        HashMap<Long, Collection<Attribute>> attributesByNode = new HashMap<Long, Collection<Attribute>>();
        HashMap<Attribute, Double> weights = new HashMap<Attribute, Double>();
        GeneCompletionProvider2 completionProvider = this.data.getCompletionProvider(organism);
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        for (NODE cyNode : proxy.getNodes()) {
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(cyNode, cyNetwork);
            String type = nodeProxy.getAttribute("node type", String.class);
            if (!"attribute".equals(type)) continue;
            String name = nodeProxy.getAttribute("gene name", String.class);
            Double weight = nodeProxy.getAttribute("score", Double.class);
            Attribute attribute = (Attribute)attributesByName.get(name);
            if (attribute == null) continue;
            weights.put(attribute, weight);
            for (NODE cyNode2 : proxy.getNeighbours(cyNode)) {
                Gene gene;
                NodeProxy<NODE> nodeProxy2 = this.cytoscapeUtils.getNodeProxy(cyNode2, cyNetwork);
                String symbol = nodeProxy2.getAttribute("gene name", String.class);
                if (symbol == null || (gene = completionProvider.getGene(symbol)) == null) continue;
                long nodeId = gene.getNode().getId();
                HashSet<Attribute> attributes = (HashSet<Attribute>)attributesByNode.get(nodeId);
                if (attributes == null) {
                    attributes = new HashSet<Attribute>();
                    attributesByNode.put(nodeId, attributes);
                }
                attributes.add(attribute);
            }
            this.addSourceNetworkForNode(nodeProxy.getIdentifier(), attribute);
        }
        for (Object cyEdge : proxy.getEdges()) {
            EdgeProxy<Object, NODE> edgeProxy = this.cytoscapeUtils.getEdgeProxy(cyEdge, cyNetwork);
            String name = edgeProxy.getAttribute("attribute name", String.class);
            Attribute attribute = (Attribute)attributesByName.get(name);
            if (attribute == null) continue;
            String edgeId = edgeProxy.getIdentifier();
            AttributeGroup group = builder.getAttributeGroup(attribute.getId());
            this.addSourceNetworkForEdge(edgeId, attribute);
            this.addEdgeIdForGroup(group.getName(), edgeId);
        }
        builder.setAttributes(attributesByNode);
        builder.setAttributeWeights(weights);
    }

    private void reconstructNodeCache(SearchResultBuilder resultBuilder, NETWORK cyNetwork, Organism organism, ProgressReporter progress) {
        progress.setDescription(Strings.resultReconstructorNodeCache_description);
        HashMap<Gene, Double> geneScores = new HashMap<Gene, Double>();
        HashMap<Long, Gene> queryGenes = new HashMap<Long, Gene>();
        GeneCompletionProvider2 completionProvider = this.data.getCompletionProvider(organism);
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        Collection<NODE> nodes = proxy.getNodes();
        progress.setMaximumProgress(nodes.size());
        int count = 0;
        for (NODE cyNode : nodes) {
            progress.setProgress(++count);
            NodeProxy<NODE> nodeProxy = this.cytoscapeUtils.getNodeProxy(cyNode, cyNetwork);
            String symbol = nodeProxy.getAttribute("gene name", String.class);
            if (symbol == null) continue;
            Gene gene = completionProvider.getGene(symbol);
            if (gene == null) {
                this.unrecognizedNodes.add(symbol);
                continue;
            }
            Double score = nodeProxy.getAttribute("score", Double.class);
            if (score == null) {
                this.unrecognizedNodes.add(symbol);
                continue;
            }
            geneScores.put(gene, score);
            String type = nodeProxy.getAttribute("node type", String.class);
            Node node = gene.getNode();
            if (type == null) {
                this.unrecognizedNodes.add(symbol);
                continue;
            }
            if ("query".equals(type)) {
                queryGenes.put(node.getId(), gene);
            }
            this.nodeIds.put(node, nodeProxy.getIdentifier());
        }
        resultBuilder.setGeneScores(geneScores);
        resultBuilder.setSearchQuery(queryGenes);
    }

    private CombiningMethod reconstructCombiningMethod(NETWORK cyNetwork) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        String combiningMethod = proxy.getAttribute("combining method", String.class);
        if (combiningMethod == null) {
            return null;
        }
        return CombiningMethod.fromCode((String)combiningMethod);
    }

    private int reconstructGeneSearchLimit(NETWORK cyNetwork) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        return proxy.getAttribute("search limit", Integer.class);
    }

    private int reconstructAttributeSearchLimit(NETWORK cyNetwork) {
        NetworkProxy<NETWORK, NODE, EDGE> proxy = this.cytoscapeUtils.getNetworkProxy(cyNetwork);
        return proxy.getAttribute("attribute search limit", Integer.class);
    }

    Node getNode(NETWORK network, Map<Long, Node> allNodes, NODE source, GeneCompletionProvider2 completionProvider) {
        NodeProxy<NODE> proxy = this.cytoscapeUtils.getNodeProxy(source, network);
        String symbol = proxy.getAttribute("gene name", String.class);
        if (symbol == null) {
            return null;
        }
        Node node = this.nodeCache.get(symbol);
        if (node != null) {
            return node;
        }
        Long nodeId = completionProvider.getNodeId(symbol);
        if (nodeId == null) {
            return null;
        }
        node = allNodes.get(nodeId);
        if (node != null) {
            this.nodeCache.put(symbol, node);
            return node;
        }
        Gene gene = completionProvider.getGene(symbol);
        if (gene == null) {
            return null;
        }
        node = gene.getNode();
        this.nodeCache.put(symbol, node);
        return node;
    }
}

