/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.genemania.plugin.apps.CrossValidator;
import org.genemania.plugin.apps.DataAdmin;
import org.genemania.plugin.apps.GeneSanitizer;
import org.genemania.plugin.apps.IdImporter;
import org.genemania.plugin.apps.NetworkAssessor;
import org.genemania.plugin.apps.NetworkImporter;
import org.genemania.plugin.apps.QueryRunner;
import org.genemania.plugin.apps.ValidationSetMaker;

public class Main {
    public static void main(String[] args) throws Exception {
        LinkedHashMap<String, AppDescriptor> apps = new LinkedHashMap<String, AppDescriptor>();
        Main.addApp(apps, new AppDescriptor(CrossValidator.class));
        Main.addApp(apps, new AppDescriptor(DataAdmin.class));
        Main.addApp(apps, new AppDescriptor(GeneSanitizer.class));
        Main.addApp(apps, new AppDescriptor(IdImporter.class));
        Main.addApp(apps, new AppDescriptor(NetworkAssessor.class));
        Main.addApp(apps, new AppDescriptor(NetworkImporter.class));
        Main.addApp(apps, new AppDescriptor(QueryRunner.class));
        Main.addApp(apps, new AppDescriptor(ValidationSetMaker.class));
        if (args.length == 0) {
            Main.printUsage(apps);
            return;
        }
        String appName = args[0];
        AppDescriptor descriptor = (AppDescriptor)apps.get(appName);
        if (descriptor == null) {
            Main.printUsage(apps);
            return;
        }
        String[] tail = Arrays.copyOfRange(args, 1, args.length);
        descriptor.run(tail);
    }

    private static void printUsage(Map<String, AppDescriptor> apps) {
        System.err.println("Usage: java -jar genemania.jar  app-name\n\n...where app-name is one of:");
        for (AppDescriptor descriptor : apps.values()) {
            System.err.printf("    %s\n", descriptor.type.getSimpleName());
        }
    }

    private static void addApp(Map<String, AppDescriptor> apps, AppDescriptor appDescriptor) {
        apps.put(appDescriptor.type.getSimpleName(), appDescriptor);
    }

    static class AppDescriptor {
        public Class<?> type;

        public AppDescriptor(Class<?> type) {
            this.type = type;
        }

        String getName() {
            return this.type.getSimpleName();
        }

        void run(String[] args) throws Exception {
            Method method = this.type.getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{args});
        }
    }
}

