/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.plugin.apps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import org.genemania.data.normalizer.GeneCompletionProvider2;
import org.genemania.domain.Gene;
import org.genemania.domain.Organism;
import org.genemania.exception.ApplicationException;
import org.genemania.exception.DataStoreException;
import org.genemania.plugin.NetworkUtils;
import org.genemania.plugin.apps.AbstractPluginDataApp;
import org.genemania.plugin.data.DataSetManager;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class GeneSanitizer
extends AbstractPluginDataApp {
    @Option(name="--organism", usage="name of organism", required=true)
    private String fOrganismName;
    private NetworkUtils networkUtils;

    void initialize() throws ApplicationException {
        try {
            this.networkUtils = new NetworkUtils();
            DataSetManager manager = GeneSanitizer.createDataSetManager();
            this.fData = manager.open(new File(this.fDataPath));
        }
        catch (SAXException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sanitize() throws IOException, DataStoreException, ApplicationException {
        BufferedReader reader;
        List<String> arguments = this.getArguments();
        Organism organism = this.parseOrganism(this.fData, this.fOrganismName);
        if (organism == null) {
            System.err.println(String.format("Unrecognized organism: %s", this.fOrganismName));
            return;
        }
        if (arguments.size() > 0) {
            String path = arguments.get(0);
            this.checkFile(path);
            reader = new BufferedReader(new FileReader(path));
        } else {
            reader = new BufferedReader(new InputStreamReader(System.in));
        }
        GeneCompletionProvider2 provider = this.fData.getCompletionProvider(organism);
        String line = reader.readLine();
        HashSet<Long> nodeIds = new HashSet<Long>();
        while (line != null) {
            try {
                Gene gene = provider.getGene(line);
                if (gene == null) {
                    System.out.println(String.format("%s\t", line));
                    continue;
                }
                Long id = gene.getNode().getId();
                if (nodeIds.contains(id)) {
                    System.out.println(String.format("%s\t", line));
                    continue;
                }
                nodeIds.add(id);
                Gene preferredGene = this.networkUtils.getPreferredGene(gene.getNode());
                System.out.println(String.format("%s\t%s", line, preferredGene.getSymbol()));
            }
            finally {
                line = reader.readLine();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        GeneSanitizer sanitizer = new GeneSanitizer();
        CmdLineParser parser = new CmdLineParser((Object)sanitizer);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println(String.format("\nUsage: %s options gene-list-file\n", GeneSanitizer.class.getSimpleName()));
            parser.printUsage((OutputStream)System.err);
            return;
        }
        sanitizer.initialize();
        sanitizer.sanitize();
    }
}

