/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 3835017332487313880L;
    private Map<Object, Integer> _indexCache;
    private boolean _lazyCaching = false;
    private boolean _isDirty = false;

    public CachedArrayList() {
    }

    public CachedArrayList(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedArrayList(int n) {
        super(n);
    }

    @Override
    public int indexOf(Object object) {
        Integer n;
        if (this._indexCache == null || this._isDirty) {
            this.cacheAll();
        }
        if ((n = this._indexCache.get(object)) != null) {
            return n;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    @Deprecated
    protected synchronized void adjustCache(int n, int n2) {
        if (this._indexCache != null) {
            Map<Object, Integer> map = this.createCache();
            Set<Object> set = this._indexCache.keySet();
            for (Object object : set) {
                int n3 = this._indexCache.get(object);
                if (n3 >= n) {
                    map.put(object, n3 + n2);
                    continue;
                }
                map.put(object, n3);
            }
            this._indexCache = map;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public void cacheIt(Object object, int n) {
        if (this._indexCache != null) {
            Integer n2 = this._indexCache.put(object, n);
            if (n2 != null && n2 < n) {
                this._indexCache.put(object, n2);
            }
            this.markDirtyIfNecessary(n);
            if (!this._isDirty && !this.isLazyCaching()) {
                for (int i = this.size() - 1; i > n; --i) {
                    Integer n3 = this._indexCache.put(this.get(i), i);
                    if (n3 == null || n3 >= n) continue;
                    this._indexCache.put(this.get(i), n3);
                }
            }
        }
    }

    protected void markDirtyIfNecessary(int n) {
        if (n < this.size() / 2) {
            this._isDirty = true;
        }
    }

    public void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    @Override
    public boolean add(E e) {
        boolean bl = super.add(e);
        if (!this.isLazyCaching() && this._indexCache != null && bl) {
            this.cacheIt(e, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n, E e) {
        if (n == this.size()) {
            this.add(e);
            return;
        }
        super.add(n, e);
        if (!this.isLazyCaching()) {
            this.cacheIt(e, n);
        } else if (this._indexCache != null) {
            this.cacheIt(e, n);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        if (e != null) {
            this.uncacheAll();
        }
        return e;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheAll();
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n = this.size();
        boolean bl = super.addAll(collection);
        if (bl && this._indexCache != null) {
            for (E e : collection) {
                this.cacheIt(e, n++);
            }
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (n == this.size()) {
            return this.addAll(collection);
        }
        boolean bl = super.addAll(n, collection);
        if (bl) {
            this.uncacheAll();
        }
        return bl;
    }

    @Override
    public E set(int n, E e) {
        if (!this.isLazyCaching()) {
            this.uncacheAll();
            return super.set(n, e);
        }
        return super.set(n, e);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public void cacheAll() {
        this._indexCache = this.createCache();
        for (int i = this.size() - 1; i >= 0; --i) {
            this._indexCache.put(this.get(i), i);
        }
        this._isDirty = false;
    }

    public boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    @Override
    protected void removeRange(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else {
            super.removeRange(n, n2);
            this.uncacheAll();
        }
    }
}

