/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.utils.ReflectionUtils;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
implements ObjectConverter {
    private String _name;
    private Object _default;
    private Class<?> _type;
    private Object[] _objects;
    private String[] _strings;
    private boolean _strict = true;
    private transient ConverterContext _context;

    public EnumConverter(Class<? extends Enum> clazz) {
        if (clazz == null || !clazz.isEnum()) {
            throw new IllegalArgumentException("To use this constructor, the type has to be an enum type.");
        }
        String string = clazz.getName();
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Empty enum type name.");
        }
        int n = string.lastIndexOf("$");
        this._name = n >= 0 ? string.substring(n + 1) : string;
        this._type = clazz;
        try {
            Object object = ReflectionUtils.callStatic(clazz, "values", null, null);
            if (!object.getClass().isArray()) {
                throw new IllegalArgumentException("Illegal enum type.");
            }
            int n2 = Array.getLength(object);
            this._objects = new Object[n2];
            this._strings = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this._objects[i] = Array.get(object, i);
                this._strings[i] = "" + this._objects[i];
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Illegal enum type.");
        }
    }

    public EnumConverter(String string, Object[] objectArray, String[] stringArray) {
        this(string, objectArray[0] == null ? (objectArray.length > 1 ? objectArray[1].getClass() : Object.class) : objectArray[0].getClass(), objectArray, stringArray);
    }

    public EnumConverter(String string, Class<?> clazz, Object[] objectArray, String[] stringArray) {
        this(string, clazz, objectArray, stringArray, null);
    }

    public EnumConverter(String string, Class<?> clazz, Object[] objectArray, String[] stringArray, Object object) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this._name = string;
        if (objectArray == null) {
            throw new IllegalArgumentException("The \"objects\" parameter cannot be null.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("The \"objects\" and \"strings\" parameters should have the same length.");
        }
        this._type = clazz;
        this._objects = objectArray;
        this._strings = stringArray;
        this._default = object;
    }

    public ConverterContext getContext() {
        if (this._context == null) {
            this._context = new ConverterContext(this._name);
        }
        return this._context;
    }

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        for (int i = 0; i < this._objects.length; ++i) {
            if ((this._objects[i] != null || object != null) && (this._objects[i] == null || !this._objects[i].equals(object)) || i >= this._strings.length) continue;
            return this._strings[i];
        }
        return this.isStrict() ? null : "" + object;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        for (int i = 0; i < this._strings.length; ++i) {
            if (!this._strings[i].equals(string) || i >= this._objects.length) continue;
            return this._objects[i];
        }
        return this.isStrict() ? this._default : string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getDefault() {
        return this._default;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public String[] getStrings() {
        return this._strings;
    }

    public static String[] toStrings(Object[] objectArray) {
        return EnumConverter.toStrings(objectArray, null);
    }

    public static String[] toStrings(Object[] objectArray, ConverterContext converterContext) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ObjectConverterManager.toString(objectArray[i], objectArray[i].getClass(), converterContext);
        }
        return stringArray;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean bl) {
        this._strict = bl;
    }
}

