/*
 * Decompiled with CFR 0.152.
 */
package pgx.localDB;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pgx.localDB.PGXDB;

public class PGXDBTests {
    public static void main(String[] args) {
        try {
            PGXDB.initialize();
        }
        catch (SQLException se) {
            PGXDBTests.stderr("Error loading the pharmacogenomics database.");
            se.printStackTrace();
        }
        PGXDBTests.getAllAlleles();
        PGXDBTests.getAllGenes();
        PGXDBTests.getMarkerPositionsForGene("CYP2C19");
        PGXDBTests.getMetabolizer();
        PGXDBTests.getPubmedIDs();
    }

    private static void getAllAlleles() {
        String test1 = "Testing retrieving CYP2C19*2 alleles with incomplete rsID/marker information";
        PGXDBTests.stdout(test1);
        String sql = "SELECT H.gene, H.haplotype_symbol FROM haplotype_markers H WHERE gene = 'CYP2C19' \tAND marker_info LIKE '%rs4244285=A%' ";
        PGXDBTests.printSQLResults(sql, test1);
        String test2 = "Testing retrieving anything with the following alleles rs4917623=C;rs3758581=G;rs17885098=T";
        PGXDBTests.stdout(test2);
        sql = "SELECT H.gene, H.haplotype_symbol FROM haplotype_markers H WHERE gene = 'CYP2C19' \tAND marker_info LIKE '%rs4917623=c%' \tAND marker_info LIKE '%rs3758581=g%' \tAND marker_info LIKE '%rs17885098=T%' ";
        PGXDBTests.printSQLResults(sql, test2);
        String test3 = "Testing retrieving the *1;*1A alleles which should have no markers (all ref calls)";
        PGXDBTests.stdout(test3);
        sql = "SELECT H.gene, H.haplotype_symbol FROM haplotype_markers H WHERE gene = 'CYP2C19' \tAND marker_info LIKE '' ";
        PGXDBTests.printSQLResults(sql, test3);
        String test4 = "Testing retrieving all alleles with NULL marker_info fields. The *1;*1A alleles which have no markers (all ref calls), store an empty string ''.";
        PGXDBTests.stdout(test4);
        sql = "SELECT H.gene, H.haplotype_symbol FROM haplotype_markers H WHERE gene = 'CYP2C19' \tAND marker_info IS NULL ";
        PGXDBTests.printSQLResults(sql, test4);
        String test5 = "Testing getting * nomenclature for this haplotype from GS000035328-ASM.";
        PGXDBTests.stdout(test5);
        sql = "SELECT H.gene, H.haplotype_symbol FROM haplotype_markers H WHERE gene = 'CYP2C19' \tAND marker_info LIKE '%rs7902257=g%' ";
        PGXDBTests.printSQLResults(sql, test5);
    }

    private static void getAllGenes() {
        String test1 = "Testing retrieving all PGx genes";
        PGXDBTests.stdout(test1);
        String sql = "SELECT G.gene FROM gene_marker_list G ";
        PGXDBTests.printSQLResults(sql, test1);
    }

    private static void getMarkerPositionsForGene(String gene) {
        String test1 = "Testing retrieving all markers for gene " + gene;
        PGXDBTests.stdout(test1);
        String sql = "SELECT marker_list FROM gene_marker_list WHERE gene = '" + gene + "' ";
        List<Object> markerList = new ArrayList();
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            if (rs.next()) {
                markerList = Arrays.asList(((String)PGXDB.getRowAsList(rs).get(0)).split(";"));
            }
        }
        catch (SQLException se) {
            PGXDBTests.stderr(test1);
            se.printStackTrace();
        }
        for (String marker : markerList) {
            sql = "SELECT M.chromosome, M.position, M.ref, M.alt FROM marker_coordinates M WHERE M.marker = '" + marker + "' ";
            PGXDBTests.printSQLResults(sql, test1 + " for marker " + marker);
        }
    }

    private static void getMetabolizer() {
        String test1 = "Testing the activity scores of CYP2D6 extensive metabolizer at score 0.8";
        PGXDBTests.stdout(test1);
        double totalActivity = 0.8;
        String sql = "SELECT total_activity_score_minimum, metabolizer_class FROM activity_to_metabolizer WHERE total_activity_score_minimum = (SELECT MAX(total_activity_score_minimum) \t\t\t\t\t\t\t\t\t\tFROM activity_to_metabolizer \t\t\t\t\t\t\t\t\t\tWHERE total_activity_score_minimum <= " + totalActivity + ")";
        PGXDBTests.printSQLResults(sql, test1);
        String test2 = "Testing the activity scores of CYP2D6 extensive metabolizer at score 2.0. Should be classified as extensive. >2.0 is Ultrarapid.";
        PGXDBTests.stdout(test2);
        totalActivity = 2.0;
        sql = "SELECT total_activity_score_minimum, metabolizer_class FROM activity_to_metabolizer WHERE total_activity_score_minimum = (SELECT MAX(total_activity_score_minimum) \t\t\t\t\t\t\t\t\t\tFROM activity_to_metabolizer \t\t\t\t\t\t\t\t\t\tWHERE total_activity_score_minimum <= " + totalActivity + ")";
        PGXDBTests.printSQLResults(sql, test2);
        String test3 = "Getting the total activity score for CYP2D6 *1/*1, should be 2.0.";
        PGXDBTests.stdout(test3);
        String hap1 = "*1";
        String hap2 = "*1";
        sql = "SELECT SUM(activity_score) FROM (SELECT * \t\tFROM haplotype_activity \t\tWHERE gene = 'cyp2d6' \t\t\tAND haplotype = '" + hap1 + "' " + "\t\tUNION ALL " + "\t\tSELECT * " + "\t\tFROM haplotype_activity " + "\t\tWHERE gene = 'cyp2d6' " + "\t\t\tAND haplotype = '" + hap2 + "') ";
        PGXDBTests.printSQLResults(sql, test3);
        hap1 = "*3";
        hap2 = "*6";
        String test4 = "Testing the metabolizer class of CYP2D6 " + hap1 + "/" + hap2;
        PGXDBTests.stdout(test4);
        sql = "SELECT total_activity_score_minimum, metabolizer_class FROM activity_to_metabolizer WHERE total_activity_score_minimum = \t(SELECT MAX(total_activity_score_minimum) \tFROM activity_to_metabolizer \tWHERE total_activity_score_minimum <= \t\t(SELECT SUM(activity_score) \t\tFROM (SELECT * \t\t\tFROM haplotype_activity \t\t\tWHERE gene = 'cyp2d6' \t\t\t\tAND haplotype = '" + hap1 + "' " + "\t\t\tUNION ALL " + "\t\t\tSELECT * " + "\t\t\tFROM haplotype_activity " + "\t\t\tWHERE gene = 'cyp2d6' " + "\t\t\t\tAND haplotype = '" + hap2 + "')) " + "\t)";
        PGXDBTests.printSQLResults(sql, test4);
    }

    private static void getPubmedIDs() {
        String gene = "cyp2d6";
        String test1 = "Testing retrieving the pubmed IDs for " + gene + ".";
        PGXDBTests.stdout(test1);
        String sql = "SELECT DISTINCT(pubmed_id) FROM haplotype_activity WHERE gene = '" + gene + "' ";
        PGXDBTests.printSQLResults(sql, test1);
        String test2 = "Testing retrieving the pubmed IDs for all genes.";
        PGXDBTests.stdout(test2);
        sql = "SELECT DISTINCT(pubmed_id) FROM haplotype_activity ";
        PGXDBTests.printSQLResults(sql, test2);
    }

    private static void printSQLResults(String sql, String errorMessage) {
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                PGXDBTests.stdout(PGXDB.getRowAsList(rs).toString());
            }
        }
        catch (SQLException se) {
            PGXDBTests.stderr(errorMessage);
            se.printStackTrace();
        }
    }

    private static void stderr(String message) {
        System.err.println("[" + PGXDBTests.class.getSimpleName() + "]: ERROR - " + message);
    }

    private static void stdout(String message) {
        System.out.println("[" + PGXDBTests.class.getSimpleName() + "]:" + message);
    }
}

