/*
 * Decompiled with CFR 0.152.
 */
package pgx.localDB;

import NaturalSorting.NaturalOrderComparator;
import Sublists.Sublists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.ut.biolab.medsavant.shared.appdevapi.Variant;
import pgx.PGXException;
import pgx.PGXGene;
import pgx.PGXGenotype;
import pgx.localDB.PGXDB;

public class PGXDBFunctions {
    public static final int SIMILAR_HAPLOTYPE_DEPTH = 3;
    public static final String UNKNOWN_HAPLOTYPE = "UNKNOWN";
    public static final String PIPE = "\\|";
    public static final String GT_SEPARATOR = "[\\|/]";

    public static List<String> getGenes() throws SQLException {
        LinkedList<String> genes = new LinkedList<String>();
        String sql = "SELECT G.gene FROM gene_marker_list G ";
        ResultSet rs = PGXDB.executeQuery(sql);
        int rowCount = 0;
        while (rs.next()) {
            List<Object> rowTemp = PGXDB.getRowAsList(rs);
            genes.add((String)rowTemp.get(0));
            ++rowCount;
        }
        return genes;
    }

    public static List<String> getMarkers(String geneSymbol) throws PGXException, SQLException {
        String sql = "SELECT G.marker_list FROM gene_marker_list G WHERE G.gene = '" + geneSymbol + "' ";
        ResultSet rs = PGXDB.executeQuery(sql);
        int rowCount = 0;
        String markerString = null;
        while (rs.next()) {
            if (rowCount > 1) {
                throw new PGXException(">1 row found for query: " + sql);
            }
            List<Object> rowTemp = PGXDB.getRowAsList(rs);
            markerString = (String)rowTemp.get(0);
            ++rowCount;
        }
        List<Object> markers = markerString != null ? Arrays.asList(markerString.split(";")) : new LinkedList();
        return markers;
    }

    public static void assignParentalGenotypes(PGXGene pg) throws SQLException {
        HashMap<String, PGXGenotype> maternalGenotypes = new HashMap<String, PGXGenotype>();
        HashMap<String, PGXGenotype> paternalGenotypes = new HashMap<String, PGXGenotype>();
        HashMap<String, String[]> variantMap = new HashMap<String, String[]>();
        for (Variant v : pg.getVariants()) {
            String key = v.getChromosome() + "_" + v.getStart();
            if (!variantMap.containsKey(key)) {
                variantMap.put(key, new String[100]);
            }
            String[] refAndAlts = (String[])variantMap.get(key);
            refAndAlts[0] = v.getReference();
            refAndAlts[v.getAlternateNumber()] = v.getAlternate();
            Matcher m = Pattern.compile(PIPE).matcher(v.getGT());
            if (m.find() || v.getGT().length() <= 1) continue;
            pg.setUnphased();
        }
        for (Variant v : pg.getVariants()) {
            String[] gt = v.getGT().split(GT_SEPARATOR);
            try {
                int maternalGT = Integer.parseInt(gt[0]);
                int paternalGT = Integer.parseInt(gt[1]);
                String key = v.getChromosome() + "_" + v.getStart();
                String[] refAndAlts = (String[])variantMap.get(key);
                String currentRsID = PGXDBFunctions.getMarkerID(v);
                int totalDepthOfCoverage = v.getReferenceDepth() + v.getAlternateDepth();
                maternalGenotypes.put(currentRsID, new PGXGenotype(refAndAlts[maternalGT], false, totalDepthOfCoverage));
                paternalGenotypes.put(currentRsID, new PGXGenotype(refAndAlts[paternalGT], false, totalDepthOfCoverage));
            }
            catch (NumberFormatException nfe) {}
        }
        pg.setMaternalGenotypes(maternalGenotypes);
        pg.setPaternalGenotypes(paternalGenotypes);
        PGXDBFunctions.finalPhaseCheck(pg);
    }

    public static String getDiplotype(PGXGene pg) throws PGXException, SQLException {
        String diplotype = UNKNOWN_HAPLOTYPE;
        PGXDBFunctions.assignParentalGenotypes(pg);
        Map<String, PGXGenotype> maternalGenotypes = pg.getMaternalGenotypes();
        Map<String, PGXGenotype> paternalGenotypes = pg.getPaternalGenotypes();
        if (pg.isPhased()) {
            List<String> paternalSimilar;
            List<String> maternalSimilar;
            pg.setMaternalHaplotype(PGXDBFunctions.getHaplotype(pg.getGene(), maternalGenotypes));
            String maternalHaplotype = new String(pg.getMaternalHaplotype());
            if (maternalHaplotype.equals(UNKNOWN_HAPLOTYPE) && (maternalSimilar = PGXDBFunctions.getSimilarHaplotypes(pg.getGene(), maternalGenotypes, 3)).size() > 0) {
                maternalHaplotype = maternalHaplotype + " (similar to " + StringUtils.join(maternalSimilar, (char)',') + ")";
            }
            pg.setPaternalHaplotype(PGXDBFunctions.getHaplotype(pg.getGene(), paternalGenotypes));
            String paternalHaplotype = new String(pg.getPaternalHaplotype());
            if (paternalHaplotype.equals(UNKNOWN_HAPLOTYPE) && (paternalSimilar = PGXDBFunctions.getSimilarHaplotypes(pg.getGene(), paternalGenotypes, 3)).size() > 0) {
                paternalHaplotype = paternalHaplotype + " (similar to " + StringUtils.join(paternalSimilar, (char)',') + ")";
            }
            ArrayList<String> haplotypes = new ArrayList<String>();
            haplotypes.add(maternalHaplotype);
            haplotypes.add(paternalHaplotype);
            Collections.sort(haplotypes, new NaturalOrderComparator());
            diplotype = (String)haplotypes.get(0) + "/" + (String)haplotypes.get(1);
        }
        return diplotype;
    }

    private static String getHaplotype(String gene, Map<String, PGXGenotype> markerGenotypePairs) throws PGXException, SQLException {
        Map<String, String> markerRef = PGXDBFunctions.getMarkerRefMap(gene);
        String sql = "SELECT H.haplotype_symbol FROM haplotype_markers H WHERE gene = '" + gene + "' ";
        for (String marker : PGXDBFunctions.getMarkers(gene)) {
            if (!markerGenotypePairs.containsKey(marker)) continue;
            sql = sql + "\tAND marker_info LIKE '%" + marker + "=" + markerGenotypePairs.get(marker).getGenotype() + "%' ";
        }
        ArrayList<String> allPossibleAlleles = new ArrayList<String>();
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                allPossibleAlleles.add((String)PGXDB.getRowAsList(rs).get(0));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        Collections.sort(allPossibleAlleles, new NaturalOrderComparator());
        String haplotype = StringUtils.join(allPossibleAlleles, (char)',');
        if (haplotype.equals("")) {
            haplotype = UNKNOWN_HAPLOTYPE;
        }
        return haplotype;
    }

    private static String getHaplotypeWithAssumption(String gene, Map<String, PGXGenotype> markerGenotypePairs, boolean assumeRef) throws PGXException, SQLException {
        Map<String, String> markerRef = PGXDBFunctions.getMarkerRefMap(gene);
        String sql = "SELECT H.haplotype_symbol FROM haplotype_markers H WHERE gene = '" + gene + "' ";
        for (String marker : PGXDBFunctions.getMarkers(gene)) {
            if (markerGenotypePairs.containsKey(marker)) {
                sql = sql + "\tAND marker_info LIKE '%" + marker + "=" + markerGenotypePairs.get(marker).getGenotype() + "%' ";
                continue;
            }
            if (!assumeRef || !markerRef.containsKey(marker)) continue;
            sql = sql + "\tAND marker_info LIKE '%" + marker + "=" + markerRef.get(marker) + "%' ";
            markerGenotypePairs.put(marker, new PGXGenotype(markerRef.get(marker), true, 0));
        }
        ArrayList<String> allPossibleAlleles = new ArrayList<String>();
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                allPossibleAlleles.add((String)PGXDB.getRowAsList(rs).get(0));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        Collections.sort(allPossibleAlleles, new NaturalOrderComparator());
        String haplotype = StringUtils.join(allPossibleAlleles, (char)',');
        if (haplotype.equals("")) {
            haplotype = UNKNOWN_HAPLOTYPE;
        }
        return haplotype;
    }

    private static void assignReferenceGenotypes(String gene, Map<String, PGXGenotype> markerGenotypePairs) throws PGXException, SQLException {
        Map<String, String> markerRef = PGXDBFunctions.getMarkerRefMap(gene);
        for (String marker : PGXDBFunctions.getMarkers(gene)) {
            if (markerGenotypePairs.containsKey(marker) || !markerRef.containsKey(marker)) continue;
            markerGenotypePairs.put(marker, new PGXGenotype(markerRef.get(marker), true, 0));
        }
    }

    private static Map<String, String> getMarkerRefMap(String gene) throws PGXException, SQLException {
        HashMap<String, String> output = new HashMap<String, String>();
        List<String> markerList = PGXDBFunctions.getMarkers(gene);
        for (String marker : markerList) {
            String sql = "SELECT M.ref FROM marker_coordinates M WHERE M.marker = '" + marker + "' ";
            ResultSet rs = PGXDB.executeQuery(sql);
            if (!rs.next()) continue;
            output.put(marker, (String)PGXDB.getRowAsList(rs).get(0));
        }
        return output;
    }

    private static List<String> getSimilarHaplotypes(String gene, Map<String, PGXGenotype> markerGenotypePairs, int remove) throws PGXException, SQLException {
        HashSet<String> similarAlleles = new HashSet<String>();
        Map<String, String> markerRef = PGXDBFunctions.getMarkerRefMap(gene);
        ArrayList<Pair> originalMarkers = new ArrayList<Pair>();
        for (String marker : markerGenotypePairs.keySet()) {
            originalMarkers.add(new Pair(marker, markerGenotypePairs.get(marker).getGenotype()));
        }
        boolean found = false;
        for (int depth = 0; depth <= remove && !found; ++depth) {
            Set similarMarkers = Sublists.sublists(originalMarkers, depth);
            for (List lop : similarMarkers) {
                String sql = "SELECT H.haplotype_symbol FROM haplotype_markers H WHERE gene = '" + gene + "' ";
                Map<String, String> sublistMap = PGXDBFunctions.convertListOfPairsToMap(lop);
                for (String marker : PGXDBFunctions.getMarkers(gene)) {
                    if (!sublistMap.containsKey(marker)) continue;
                    sql = sql + "\tAND marker_info LIKE '%" + marker + "=" + sublistMap.get(marker) + "%' ";
                }
                try {
                    ResultSet rs = PGXDB.executeQuery(sql);
                    while (rs.next()) {
                        similarAlleles.add((String)PGXDB.getRowAsList(rs).get(0));
                    }
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
            if (similarAlleles.size() <= 1) continue;
            found = true;
            System.out.println("Similar haplotype found at depth = " + depth);
        }
        ArrayList<String> output = new ArrayList<String>();
        output.addAll(similarAlleles);
        Collections.sort(output, new NaturalOrderComparator());
        return output;
    }

    public static String getActivities(String gene, String haplotype) {
        String activity = null;
        String sql = "SELECT activity_phenotype FROM haplotype_activity WHERE gene = '" + gene + "' " + "\tAND haplotype = '" + haplotype + "' ";
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                activity = (String)PGXDB.getRowAsList(rs).get(0);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return activity;
    }

    public static String getMetabolizerClass(String hap1Activity, String hap2Activity) {
        String metabolizer = "unknown";
        String sql = "SELECT metabolizer_class FROM phenotype_to_metabolizer WHERE (haplotype_1_activity = '" + hap1Activity + "' " + "\tAND haplotype_2_activity = '" + hap2Activity + "') " + "\tOR (haplotype_1_activity = '" + hap2Activity + "' " + "\tAND haplotype_2_activity = '" + hap1Activity + "') ";
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                metabolizer = (String)PGXDB.getRowAsList(rs).get(0);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return metabolizer;
    }

    public static void finalPhaseCheck(PGXGene pg) {
        Set<String> markers = pg.getMaternalGenotypes().keySet();
        int numberOfDifferentGenotypes = 0;
        for (String m : markers) {
            String genotype2;
            String genotype1 = pg.getMaternalGenotypes().get(m).getGenotype();
            if (!genotype1.equals(genotype2 = pg.getPaternalGenotypes().get(m).getGenotype())) {
                ++numberOfDifferentGenotypes;
            }
            if (numberOfDifferentGenotypes <= 1) continue;
            break;
        }
        if (numberOfDifferentGenotypes <= 1) {
            pg.setPhased();
        }
    }

    private static Map<String, String> convertListOfPairsToMap(List<Pair> lop) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Pair p : lop) {
            map.put(p.marker, p.genotype);
        }
        return map;
    }

    private static List<String> getOmitted(Map<String, String> original, Map<String, String> sublist) {
        ArrayList<String> omitted = new ArrayList<String>();
        for (String key : original.keySet()) {
            if (sublist.containsKey(key)) continue;
            omitted.add(key);
        }
        return omitted;
    }

    public static Map<String, PGXMarker> getMarkerInfoMap(String gene) throws PGXException, SQLException {
        HashMap<String, PGXMarker> output = new HashMap<String, PGXMarker>();
        List<String> markerList = PGXDBFunctions.getMarkers(gene);
        Collections.sort(markerList);
        for (String marker : markerList) {
            String sql = "SELECT M.chromosome, M.position, M.ref, M.alt FROM marker_coordinates M WHERE M.marker = '" + marker + "' ";
            ResultSet rs = PGXDB.executeQuery(sql);
            if (!rs.next()) continue;
            List<Object> row = PGXDB.getRowAsList(rs);
            output.put(marker, new PGXMarker(marker, (String)row.get(0), (String)row.get(1), (String)row.get(2), (String)row.get(3)));
        }
        return output;
    }

    public static List<PGXMarker> getMarkerInfo(String gene) throws PGXException, SQLException {
        return new ArrayList<PGXMarker>(PGXDBFunctions.getMarkerInfoMap(gene).values());
    }

    public static String getMarkerID(Variant var) throws SQLException {
        String output = null;
        String sql = "SELECT M.marker FROM marker_coordinates M WHERE M.chromosome = '" + var.getChromosome() + "' " + "\tAND M.position = " + var.getStart() + " ";
        ResultSet rs = PGXDB.executeQuery(sql);
        if (rs.next()) {
            List<Object> row = PGXDB.getRowAsList(rs);
            output = (String)row.get(0);
        }
        return output;
    }

    public static List<String> getPubMedIDs(String gene) {
        List<String> pmIDs = new ArrayList<String>();
        String sql = "SELECT DISTINCT(pubmed_id) FROM haplotype_activity WHERE gene = '" + gene + "' ";
        try {
            ResultSet rs = PGXDB.executeQuery(sql);
            while (rs.next()) {
                String pmidString = (String)PGXDB.getRowAsList(rs).get(0);
                pmIDs = Arrays.asList(pmidString.split(";"));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return pmIDs;
    }

    public static class PGXMarker {
        public String markerID;
        public String chromosome;
        public String position;
        public String ref;
        public String alt;

        public PGXMarker(String markerID, String chromosome, String position, String ref, String alt) {
            this.markerID = markerID;
            this.chromosome = chromosome;
            this.position = position;
            this.ref = ref;
            this.alt = alt;
        }
    }

    private static class Pair {
        String genotype;
        String marker;

        public Pair(String marker, String genotype) {
            this.marker = marker;
            this.genotype = genotype;
        }
    }
}

